/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.registration;

import io.jans.as.client.RegisterRequest;
import io.jans.as.model.common.AuthenticationMethod;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.common.SubjectType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.register.ApplicationType;
import io.jans.as.model.register.RegisterErrorResponseType;
import io.jans.as.model.util.Pair;
import io.jans.as.model.util.URLPatternList;
import io.jans.as.model.util.Util;
import io.jans.as.server.util.ServerUtil;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.slf4j.Logger;

@Stateless
@Named
public class RegisterParamsValidator {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String LOCALHOST = "localhost";
    private static final String LOOPBACK = "127.0.0.1";

    public Pair<Boolean, String> validateParamsClientRegister(ApplicationType applicationType, SubjectType subjectType, List<GrantType> grantTypes, List<ResponseType> responseTypes, List<String> redirectUris) {
        if (applicationType == null) {
            return new Pair((Object)false, (Object)"application_type is not valid.");
        }
        if (grantTypes != null && (grantTypes.contains(GrantType.AUTHORIZATION_CODE) || grantTypes.contains(GrantType.IMPLICIT) || responseTypes.contains(ResponseType.CODE) && !grantTypes.contains(GrantType.DEVICE_CODE) && !grantTypes.contains(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS) && !grantTypes.contains(GrantType.CLIENT_CREDENTIALS) || responseTypes.contains(ResponseType.TOKEN) || responseTypes.contains(ResponseType.ID_TOKEN)) && (redirectUris == null || redirectUris.isEmpty())) {
            return new Pair((Object)false, (Object)"Redirect uris are empty.");
        }
        if (subjectType == null || !this.appConfiguration.getSubjectTypesSupported().contains(subjectType.toString())) {
            this.log.debug("Parameter subject_type is not valid.");
            return new Pair((Object)false, (Object)"Parameter subject_type is not valid.");
        }
        return new Pair((Object)true, (Object)"");
    }

    public void validateAlgorithms(RegisterRequest registerRequest) {
        if (registerRequest.getIdTokenSignedResponseAlg() != null && registerRequest.getIdTokenSignedResponseAlg() != SignatureAlgorithm.NONE && !this.appConfiguration.getIdTokenSigningAlgValuesSupported().contains(registerRequest.getIdTokenSignedResponseAlg().toString())) {
            this.log.debug("Parameter id_token_signed_response_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter id_token_signed_response_alg is not valid.");
        }
        if (registerRequest.getAccessTokenSigningAlg() != null && registerRequest.getAccessTokenSigningAlg() != SignatureAlgorithm.NONE && !this.appConfiguration.getAccessTokenSigningAlgValuesSupported().contains(registerRequest.getAccessTokenSigningAlg().toString())) {
            this.log.debug("Parameter access_token_signed_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter access_token_signed_alg is not valid.");
        }
        if (registerRequest.getIdTokenEncryptedResponseAlg() != null && !this.appConfiguration.getIdTokenEncryptionAlgValuesSupported().contains(registerRequest.getIdTokenEncryptedResponseAlg().toString())) {
            this.log.debug("Parameter id_token_encrypted_response_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter id_token_encrypted_response_alg is not valid.");
        }
        if (registerRequest.getIdTokenEncryptedResponseEnc() != null && !this.appConfiguration.getIdTokenEncryptionEncValuesSupported().contains(registerRequest.getIdTokenEncryptedResponseEnc().toString())) {
            this.log.debug("Parameter id_token_encrypted_response_enc is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter id_token_encrypted_response_enc is not valid.");
        }
        if (registerRequest.getUserInfoSignedResponseAlg() != null && !this.appConfiguration.getUserInfoSigningAlgValuesSupported().contains(registerRequest.getUserInfoSignedResponseAlg().toString())) {
            this.log.debug("Parameter userinfo_signed_response_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter userinfo_signed_response_alg is not valid.");
        }
        if (registerRequest.getUserInfoEncryptedResponseAlg() != null && !this.appConfiguration.getUserInfoEncryptionAlgValuesSupported().contains(registerRequest.getUserInfoEncryptedResponseAlg().toString())) {
            this.log.debug("Parameter userinfo_encrypted_response_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter userinfo_encrypted_response_alg is not valid.");
        }
        if (registerRequest.getUserInfoEncryptedResponseEnc() != null && !this.appConfiguration.getUserInfoEncryptionEncValuesSupported().contains(registerRequest.getUserInfoEncryptedResponseEnc().toString())) {
            this.log.debug("Parameter userinfo_encrypted_response_enc is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter userinfo_encrypted_response_enc is not valid.");
        }
        if (registerRequest.getIntrospectionSignedResponseAlg() != null && !this.appConfiguration.getIntrospectionSigningAlgValuesSupported().contains(registerRequest.getIntrospectionSignedResponseAlg().toString())) {
            this.log.debug("Parameter introspection_signed_response_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter introspection_signed_response_alg is not valid.");
        }
        if (registerRequest.getIntrospectionEncryptedResponseAlg() != null && !this.appConfiguration.getIntrospectionEncryptionAlgValuesSupported().contains(registerRequest.getIntrospectionEncryptedResponseAlg().toString())) {
            this.log.debug("Parameter introspection_encrypted_response_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter introspection_encrypted_response_alg is not valid.");
        }
        if (registerRequest.getIntrospectionEncryptedResponseEnc() != null && !this.appConfiguration.getIntrospectionEncryptionEncValuesSupported().contains(registerRequest.getIntrospectionEncryptedResponseEnc().toString())) {
            this.log.debug("Parameter introspection_encrypted_response_enc is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter introspection_encrypted_response_enc is not valid.");
        }
        if (registerRequest.getLogoutStatusJwtSignedResponseAlg() != null && !this.appConfiguration.getLogoutStatusJwtSigningAlgValuesSupported().contains(registerRequest.getLogoutStatusJwtSignedResponseAlg().toString())) {
            this.log.debug("Parameter logout_status_jwt_signed_response_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter logout_status_jwt_signed_response_alg is not valid.");
        }
        if (registerRequest.getTxTokenSignedResponseAlg() != null && !this.appConfiguration.getTxTokenSigningAlgValuesSupported().contains(registerRequest.getTxTokenSignedResponseAlg().toString())) {
            this.log.debug("Parameter tx_token_signed_response_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter tx_token_signed_response_alg is not valid.");
        }
        if (registerRequest.getTxTokenEncryptedResponseAlg() != null && !this.appConfiguration.getTxTokenEncryptionAlgValuesSupported().contains(registerRequest.getTxTokenEncryptedResponseAlg().toString())) {
            this.log.debug("Parameter tx_token_encrypted_response_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter tx_token_encrypted_response_alg is not valid.");
        }
        if (registerRequest.getTxTokenEncryptedResponseEnc() != null && !this.appConfiguration.getTxTokenEncryptionEncValuesSupported().contains(registerRequest.getTxTokenEncryptedResponseEnc().toString())) {
            this.log.debug("Parameter tx_token_encrypted_response_enc is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter tx_token_encrypted_response_enc is not valid.");
        }
        if (registerRequest.getRequestObjectSigningAlg() != null && !this.appConfiguration.getRequestObjectSigningAlgValuesSupported().contains(registerRequest.getRequestObjectSigningAlg().toString())) {
            this.log.debug("Parameter request_object_signing_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter request_object_signing_alg is not valid.");
        }
        if (registerRequest.getRequestObjectEncryptionAlg() != null && !this.appConfiguration.getRequestObjectEncryptionAlgValuesSupported().contains(registerRequest.getRequestObjectEncryptionAlg().toString())) {
            this.log.debug("Parameter request_object_encryption_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter request_object_encryption_alg is not valid.");
        }
        if (registerRequest.getRequestObjectEncryptionEnc() != null && !this.appConfiguration.getRequestObjectEncryptionEncValuesSupported().contains(registerRequest.getRequestObjectEncryptionEnc().toString())) {
            this.log.debug("Parameter request_object_encryption_enc is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter request_object_encryption_enc is not valid.");
        }
        if (registerRequest.getTokenEndpointAuthMethod() != null && !this.appConfiguration.getTokenEndpointAuthMethodsSupported().contains(registerRequest.getTokenEndpointAuthMethod().toString())) {
            this.log.debug("Parameter token_endpoint_auth_method is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter token_endpoint_auth_method is not valid.");
        }
        if (registerRequest.getAdditionalTokenEndpointAuthMethods() != null && !registerRequest.getAdditionalTokenEndpointAuthMethods().isEmpty()) {
            for (AuthenticationMethod authenticationMethod : registerRequest.getAdditionalTokenEndpointAuthMethods()) {
                if (this.appConfiguration.getTokenEndpointAuthMethodsSupported().contains(authenticationMethod.toString())) continue;
                this.log.debug("additional_token_endpoint_auth_method contains not valid value: {}", (Object)authenticationMethod);
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "additional_token_endpoint_auth_method contains not valid value.");
            }
        }
        if (registerRequest.getTokenEndpointAuthSigningAlg() != null && !this.appConfiguration.getTokenEndpointAuthSigningAlgValuesSupported().contains(registerRequest.getTokenEndpointAuthSigningAlg().toString())) {
            this.log.debug("Parameter token_endpoint_auth_signing_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter token_endpoint_auth_signing_alg is not valid.");
        }
        if (!(registerRequest.getAuthorizationSignedResponseAlg() == null || this.appConfiguration.getAuthorizationSigningAlgValuesSupported().contains(registerRequest.getAuthorizationSignedResponseAlg().toString()) && registerRequest.getAuthorizationSignedResponseAlg() != SignatureAlgorithm.NONE)) {
            this.log.debug("Parameter authorization_signed_response_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter authorization_signed_response_alg is not valid.");
        }
        if (registerRequest.getAuthorizationEncryptedResponseAlg() != null && !this.appConfiguration.getAuthorizationEncryptionAlgValuesSupported().contains(registerRequest.getAuthorizationEncryptedResponseAlg().toString())) {
            this.log.debug("Parameter authorization_encrypted_response_alg is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter authorization_encrypted_response_alg is not valid.");
        }
        if (registerRequest.getAuthorizationEncryptedResponseEnc() != null && !this.appConfiguration.getAuthorizationEncryptionEncValuesSupported().contains(registerRequest.getAuthorizationEncryptedResponseEnc().toString())) {
            this.log.debug("Parameter authorization_encrypted_response_enc is not valid.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Parameter authorization_encrypted_response_enc is not valid.");
        }
    }

    public boolean validateParamsClientRead(String clientId, String accessToken) {
        return StringUtils.isNotBlank((CharSequence)clientId) && StringUtils.isNotBlank((CharSequence)accessToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateRedirectUris(List<GrantType> grantTypes, List<ResponseType> responseTypes, ApplicationType applicationType, SubjectType subjectType, List<String> redirectUris, String sectorIdentifierUrl) {
        boolean valid = true;
        HashSet<String> redirectUriHosts = new HashSet<String>();
        if (redirectUris != null && !redirectUris.isEmpty()) {
            for (String redirectUri : redirectUris) {
                if (redirectUri == null || redirectUri.contains("#")) {
                    valid = false;
                    continue;
                }
                URI uri = null;
                try {
                    uri = new URI(redirectUri);
                }
                catch (URISyntaxException e) {
                    this.log.debug("Failed to parse redirect_uri: {}, error: {}", (Object)redirectUri, (Object)e.getMessage());
                    valid = false;
                    continue;
                }
                redirectUriHosts.add(uri.getHost());
                switch (applicationType) {
                    case WEB: {
                        if (!HTTP.equalsIgnoreCase(uri.getScheme()) || LOCALHOST.equalsIgnoreCase(uri.getHost()) || LOOPBACK.equalsIgnoreCase(uri.getHost())) break;
                        this.log.debug("Invalid protocol for redirect_uri: {} (only https protocol is allowed for application_type=web or localhost/127.0.0.1 for http)", (Object)redirectUri);
                        valid = false;
                        break;
                    }
                }
            }
        } else {
            valid = !grantTypes.contains(GrantType.AUTHORIZATION_CODE) && !grantTypes.contains(GrantType.IMPLICIT) && (!responseTypes.contains(ResponseType.CODE) || grantTypes.contains(GrantType.DEVICE_CODE) || grantTypes.contains(GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS) || grantTypes.contains(GrantType.CLIENT_CREDENTIALS)) && !responseTypes.contains(ResponseType.TOKEN) && !responseTypes.contains(ResponseType.ID_TOKEN);
        }
        this.log.trace("Validating redirect uris ... valid: {}, redirectUris: {}, grantTypes: {}, subjectType: {}", new Object[]{valid, redirectUris, grantTypes, subjectType});
        if (subjectType != null && subjectType.equals((Object)SubjectType.PAIRWISE) && StringUtils.isBlank((CharSequence)sectorIdentifierUrl) && redirectUriHosts.size() > 1) {
            valid = false;
        }
        boolean noRedirectUriInSectorIdentifierUri = false;
        if (valid && StringUtils.isNotBlank((CharSequence)sectorIdentifierUrl)) {
            try {
                URI uri = new URI(sectorIdentifierUrl);
                if (!HTTPS.equalsIgnoreCase(uri.getScheme())) {
                    valid = false;
                }
                String entity = null;
                try (Client clientRequest = ClientBuilder.newClient();){
                    Response clientResponse = clientRequest.target(sectorIdentifierUrl).request().buildGet().invoke();
                    int status = clientResponse.getStatus();
                    if (status == 200) {
                        entity = (String)clientResponse.readEntity(String.class);
                        JSONArray sectorIdentifierJsonArray = new JSONArray(entity);
                        valid = Util.asList((JSONArray)sectorIdentifierJsonArray).containsAll(redirectUris);
                    }
                }
            }
            catch (Exception e) {
                this.log.debug(e.getMessage(), (Throwable)e);
                valid = false;
            }
            finally {
                if (!valid) {
                    noRedirectUriInSectorIdentifierUri = true;
                }
            }
        }
        if (valid) {
            boolean bl = valid = this.checkWhiteListRedirectUris(redirectUris) && this.checkBlackListRedirectUris(redirectUris);
        }
        if (noRedirectUriInSectorIdentifierUri) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Failed to validate redirect uris. No redirect_uri in sector_identifier_uri content.");
        }
        return valid;
    }

    public boolean validateInitiateLoginUri(String initiateLoginUri) {
        boolean valid = false;
        try {
            URI uri = new URI(initiateLoginUri);
            if (HTTPS.equalsIgnoreCase(uri.getScheme())) {
                valid = true;
            }
        }
        catch (URISyntaxException e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            valid = false;
        }
        return valid;
    }

    private boolean checkWhiteListRedirectUris(List<String> redirectUris) {
        if (redirectUris == null || redirectUris.isEmpty()) {
            return true;
        }
        boolean valid = true;
        List whiteList = this.appConfiguration.getClientWhiteList();
        URLPatternList urlPatternList = new URLPatternList(whiteList);
        for (String redirectUri : redirectUris) {
            valid &= urlPatternList.isUrlListed(redirectUri);
        }
        return valid;
    }

    private boolean checkBlackListRedirectUris(List<String> redirectUris) {
        if (redirectUris == null || redirectUris.isEmpty()) {
            return true;
        }
        boolean valid = true;
        List blackList = this.appConfiguration.getClientBlackList();
        URLPatternList urlPatternList = new URLPatternList(blackList);
        for (String redirectUri : redirectUris) {
            valid &= !urlPatternList.isUrlListed(redirectUri);
        }
        return valid;
    }

    public void validateLogoutUri(List<String> logoutUris, List<String> redirectUris, ErrorResponseFactory errorResponseFactory) {
        if (logoutUris == null || logoutUris.isEmpty()) {
            return;
        }
        for (String logoutUri : logoutUris) {
            this.validateLogoutUri(logoutUri, redirectUris, errorResponseFactory);
        }
    }

    public void validateLogoutUri(String logoutUri, List<String> redirectUris, ErrorResponseFactory errorResponseFactory) {
        if (Util.isNullOrEmpty((String)logoutUri)) {
            return;
        }
        if (redirectUris == null || redirectUris.isEmpty()) {
            this.log.debug("Preconditions of logout uri validation are failed.");
            this.throwInvalidLogoutUri(errorResponseFactory);
            return;
        }
        try {
            Set<String> redirectUriHosts = RegisterParamsValidator.collectUriHosts(redirectUris);
            URI uri = new URI(logoutUri);
            if (!redirectUriHosts.contains(uri.getHost())) {
                this.log.debug("logout uri host is not within redirect_uris, logout_uri: {}, redirect_uris: {}", (Object)logoutUri, redirectUris);
                this.throwInvalidLogoutUri(errorResponseFactory);
                return;
            }
            if (!HTTPS.equalsIgnoreCase(uri.getScheme())) {
                this.log.debug("logout uri schema is not https, logout_uri: {}", (Object)logoutUri);
                this.throwInvalidLogoutUri(errorResponseFactory);
            }
        }
        catch (Exception e) {
            this.log.debug(e.getMessage(), (Throwable)e);
            this.throwInvalidLogoutUri(errorResponseFactory);
        }
    }

    private void throwInvalidLogoutUri(ErrorResponseFactory errorResponseFactory) throws WebApplicationException {
        throw new WebApplicationException(Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)errorResponseFactory.errorAsJson((IErrorType)RegisterErrorResponseType.INVALID_LOGOUT_URI, "Failed to valide logout uri.")).cacheControl(ServerUtil.cacheControl(true, false)).header("Pragma", (Object)"no-cache").build());
    }

    private static Set<String> collectUriHosts(List<String> uriList) throws URISyntaxException {
        HashSet<String> hosts = new HashSet<String>();
        for (String redirectUri : uriList) {
            URI uri = new URI(redirectUri);
            hosts.add(uri.getHost());
        }
        return hosts;
    }

    public boolean checkIfThereIsPasswordGrantType(List<GrantType> grantTypes) {
        if (grantTypes != null) {
            return grantTypes.stream().anyMatch(grantType -> grantType == GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS);
        }
        return false;
    }
}

