/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.token;

import com.google.common.base.Preconditions;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.exception.CryptoProviderException;
import io.jans.as.model.jwk.Algorithm;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.jwk.KeyOpsType;
import io.jans.as.model.jwk.Use;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtType;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.ServerCryptoProvider;
import io.jans.service.cdi.util.CdiUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtSigner {
    private static final Logger log = LoggerFactory.getLogger(JwtSigner.class);
    private AbstractCryptoProvider cryptoProvider;
    private final SignatureAlgorithm signatureAlgorithm;
    private final String audience;
    private final String hmacSharedSecret;
    private final AppConfiguration appConfiguration;
    private final JSONWebKeySet webKeys;
    private Jwt jwt;

    public JwtSigner(AppConfiguration appConfiguration, JSONWebKeySet webKeys, SignatureAlgorithm signatureAlgorithm, String audience) {
        this(appConfiguration, webKeys, signatureAlgorithm, audience, null);
    }

    public JwtSigner(AppConfiguration appConfiguration, JSONWebKeySet webKeys, SignatureAlgorithm signatureAlgorithm, String audience, String hmacSharedSecret) {
        this(appConfiguration, webKeys, signatureAlgorithm, audience, hmacSharedSecret, null);
    }

    public JwtSigner(AppConfiguration appConfiguration, JSONWebKeySet webKeys, SignatureAlgorithm signatureAlgorithm, String audience, String hmacSharedSecret, AbstractCryptoProvider cryptoProvider) {
        this.appConfiguration = appConfiguration;
        this.webKeys = webKeys;
        this.signatureAlgorithm = signatureAlgorithm;
        this.audience = audience;
        this.hmacSharedSecret = hmacSharedSecret;
        this.cryptoProvider = cryptoProvider != null ? cryptoProvider : new ServerCryptoProvider((AbstractCryptoProvider)CdiUtil.bean(AbstractCryptoProvider.class));
    }

    public static JwtSigner newJwtSigner(AppConfiguration appConfiguration, JSONWebKeySet webKeys, Client client) throws Exception {
        Preconditions.checkNotNull((Object)client, (Object)"Client must not be null");
        ClientService clientService = (ClientService)CdiUtil.bean(ClientService.class);
        return JwtSigner.newJwtSigner(appConfiguration, webKeys, client, clientService.decryptSecret(client.getClientSecret()));
    }

    public static JwtSigner newJwtSigner(AppConfiguration appConfiguration, JSONWebKeySet webKeys, Client client, String decryptedSecret) {
        Preconditions.checkNotNull((Object)client, (Object)"Client must not be null");
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)appConfiguration.getDefaultSignatureAlgorithm());
        if (client.getIdTokenSignedResponseAlg() != null) {
            signatureAlgorithm = SignatureAlgorithm.fromString((String)client.getIdTokenSignedResponseAlg());
        }
        return new JwtSigner(appConfiguration, webKeys, signatureAlgorithm, client.getClientId(), decryptedSecret);
    }

    public Jwt newJwt() throws CryptoProviderException {
        this.jwt = new Jwt();
        String keyId = this.getKid();
        if (keyId != null) {
            this.jwt.getHeader().setKeyId(keyId);
        }
        this.jwt.getHeader().setType(JwtType.JWT);
        this.jwt.getHeader().setAlgorithm(this.signatureAlgorithm);
        this.jwt.getClaims().setIssuer(this.appConfiguration.getIssuer());
        if (StringUtils.isNotBlank((CharSequence)this.audience)) {
            this.jwt.getClaims().setAudience(this.audience);
        }
        return this.jwt;
    }

    private String getKid() throws CryptoProviderException {
        String staticKid = this.appConfiguration.getStaticKid();
        if (StringUtils.isNotBlank((CharSequence)staticKid)) {
            log.trace("Use staticKid: {}", (Object)staticKid);
            return staticKid;
        }
        return this.cryptoProvider.getKeyId(this.webKeys, Algorithm.fromString((String)this.signatureAlgorithm.getName()), Use.SIGNATURE, KeyOpsType.CONNECT);
    }

    public Jwt sign() throws Exception {
        String signature = this.cryptoProvider.sign(this.jwt.getSigningInput(), this.jwt.getHeader().getKeyId(), this.hmacSharedSecret, this.signatureAlgorithm);
        this.jwt.setEncodedSignature(signature);
        return this.jwt;
    }

    public Jwt getJwt() {
        return this.jwt;
    }

    public void setJwt(Jwt jwt) {
        this.jwt = jwt;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setCryptoProvider(AbstractCryptoProvider cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }
}

