/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.par.ws.rs;

import io.jans.as.common.model.registration.Client;
import io.jans.as.common.util.RedirectUri;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.common.ResponseMode;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponse;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.util.QueryStringDecoder;
import io.jans.as.model.util.Util;
import io.jans.as.persistence.model.Par;
import io.jans.as.server.auth.DpopService;
import io.jans.as.server.authorize.ws.rs.AuthorizeRestWebServiceValidator;
import io.jans.as.server.model.audit.Action;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.par.ws.rs.ParResponse;
import io.jans.as.server.par.ws.rs.ParService;
import io.jans.as.server.par.ws.rs.ParValidator;
import io.jans.as.server.service.RedirectUriResponse;
import io.jans.as.server.service.RequestParameterService;
import io.jans.as.server.util.ServerUtil;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Path(value="/par")
public class ParRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ParService parService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private ParValidator parValidator;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private AuthorizeRestWebServiceValidator authorizeRestWebServiceValidator;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private DpopService dpopService;

    @POST
    @Produces(value={"application/json"})
    public Response requestPushedAuthorizationRequest(@FormParam(value="scope") String scope, @FormParam(value="authorization_details") String authorizationDetails, @FormParam(value="response_type") String responseType, @FormParam(value="client_id") String clientId, @FormParam(value="redirect_uri") String redirectUri, @FormParam(value="state") String state, @FormParam(value="response_mode") String responseMode, @FormParam(value="nonce") String nonce, @FormParam(value="display") String display, @FormParam(value="prompt") String prompt, @FormParam(value="max_age") Integer maxAge, @FormParam(value="ui_locales") String uiLocales, @FormParam(value="id_token_hint") String idTokenHint, @FormParam(value="login_hint") String loginHint, @FormParam(value="acr_values") String acrValuesStr, @FormParam(value="amr_values") String amrValuesStr, @FormParam(value="request") String request, @FormParam(value="request_uri") String requestUri, @FormParam(value="session_id") String sessionId, @FormParam(value="origin_headers") String originHeaders, @FormParam(value="code_challenge") String codeChallenge, @FormParam(value="code_challenge_method") String codeChallengeMethod, @FormParam(value="nbf") String nbf, @FormParam(value="custom_response_headers") String customResponseHeaders, @FormParam(value="claims") String claims, @Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse, @Context SecurityContext securityContext) {
        try {
            this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.PAR);
            OAuth2AuditLog auditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpRequest), Action.PAR_REQUEST);
            auditLog.setClientId(clientId);
            auditLog.setScope(scope);
            scope = ServerUtil.urlDecode(scope);
            String tokenBindingHeader = httpRequest.getHeader("Sec-Token-Binding");
            this.log.debug("Attempting to request PAR: responseType = {}, clientId = {}, scope = {}, redirectUri = {}, nonce = {}, state = {}, request = {}, isSecure = {}, sessionId = {}", new Object[]{responseType, clientId, scope, redirectUri, nonce, state, request, securityContext.isSecure(), sessionId});
            this.log.debug("Attempting to request PAR: acrValues = {}, amrValues = {}, originHeaders = {}, codeChallenge = {}, codeChallengeMethod = {}, customRespHeaders = {}, claims = {}, tokenBindingHeader = {}, authorizationDetails = {}", new Object[]{acrValuesStr, amrValuesStr, originHeaders, codeChallenge, codeChallengeMethod, customResponseHeaders, claims, tokenBindingHeader, authorizationDetails});
            this.parValidator.validateAuthentication(clientId, state);
            List responseTypes = ResponseType.fromString((String)responseType, (String)" ");
            ResponseMode responseModeObj = ResponseMode.getByValue((String)responseMode);
            Jwt requestObject = Jwt.parseSilently((String)request);
            clientId = this.getClientId(clientId, requestObject);
            Client client = this.authorizeRestWebServiceValidator.validateClient(clientId, state, true);
            redirectUri = this.getRedirectUri(redirectUri, requestObject);
            redirectUri = this.authorizeRestWebServiceValidator.validateRedirectUri(client, redirectUri, state, null, httpRequest, AuthorizeErrorResponseType.INVALID_REQUEST);
            RedirectUriResponse redirectUriResponse = new RedirectUriResponse(new RedirectUri(redirectUri, responseTypes, responseModeObj), state, httpRequest, this.errorResponseFactory);
            redirectUriResponse.setFapiCompatible(this.appConfiguration.isFapi());
            this.parValidator.validateRequestUriIsAbsent(requestUri);
            String dpopJkt = this.dpopService.getDPoPJwkThumbprint(httpRequest, client, auditLog);
            Integer parLifetime = client.getAttributes().getParLifetime();
            Par par = new Par();
            par.setDeletable(Boolean.valueOf(true));
            par.setTtl(parLifetime);
            par.setExpirationDate(Util.createExpirationDate((Integer)parLifetime));
            par.getAttributes().setScope(scope);
            par.getAttributes().setAuthorizationDetails(authorizationDetails);
            par.getAttributes().setNbf(Util.parseIntegerSilently((String)nbf));
            par.getAttributes().setResponseType(responseType);
            par.getAttributes().setClientId(clientId);
            par.getAttributes().setRedirectUri(redirectUri);
            par.getAttributes().setState(state);
            par.getAttributes().setResponseMode(responseMode);
            par.getAttributes().setNonce(nonce);
            par.getAttributes().setDisplay(display);
            par.getAttributes().setPrompt(prompt);
            par.getAttributes().setMaxAge(maxAge);
            par.getAttributes().setUiLocales(uiLocales);
            par.getAttributes().setIdTokenHint(idTokenHint);
            par.getAttributes().setLoginHint(loginHint);
            par.getAttributes().setAcrValuesStr(acrValuesStr);
            par.getAttributes().setAmrValuesStr(amrValuesStr);
            par.getAttributes().setRequest(request);
            par.getAttributes().setRequestUri(requestUri);
            par.getAttributes().setSessionId(sessionId);
            par.getAttributes().setOriginHeaders(originHeaders);
            par.getAttributes().setCodeChallenge(codeChallenge);
            par.getAttributes().setCodeChallengeMethod(codeChallengeMethod);
            par.getAttributes().setDpopJkt(dpopJkt);
            par.getAttributes().setCustomResponseHeaders(customResponseHeaders);
            par.getAttributes().setClaims(claims);
            par.getAttributes().setCustomParameters(this.requestParameterService.getCustomParameters(QueryStringDecoder.decode((String)httpRequest.getQueryString())));
            this.parValidator.validateRequestObject(redirectUriResponse, par, client);
            this.parValidator.validatePkce(par.getAttributes().getCodeChallenge(), par.getAttributes().getCodeChallengeMethod(), state);
            this.authorizeRestWebServiceValidator.validatePkce(par.getAttributes().getCodeChallenge(), redirectUriResponse, client);
            this.parService.persist(par);
            ParResponse parResponse = new ParResponse();
            parResponse.setRequestUri(ParService.toOutsideId(par.getId()));
            parResponse.setExpiresIn(par.getTtl());
            String responseAsString = ServerUtil.asJson(parResponse);
            this.log.debug("Created PAR {}", (Object)responseAsString);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)responseAsString).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (WebApplicationException e) {
            if (e.getResponse().getStatus() == Response.Status.FOUND.getStatusCode()) {
                throw this.errorResponseFactory.createBadRequestException(this.createErrorResponseFromRedirectErrorUri(e.getResponse().getLocation()));
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
    }

    @NotNull
    private ErrorResponse createErrorResponseFromRedirectErrorUri(@NotNull URI location) {
        RedirectUri locationRedirect = new RedirectUri(location.toString());
        locationRedirect.parseQueryString(location.getQuery());
        ErrorResponse response = new ErrorResponse();
        String error = locationRedirect.getResponseParameter("error");
        String errorDescription = locationRedirect.getResponseParameter("error_description");
        errorDescription = Optional.ofNullable(errorDescription).map(description -> Optional.ofNullable(ThreadContext.get((String)"X-Correlation-Id")).map(id -> description.concat(" CorrelationId: " + id)).orElse((String)description)).orElse(null);
        response.setErrorCode(error);
        response.setErrorDescription(errorDescription);
        return response;
    }

    private String getRedirectUri(String redirectUri, Jwt requestJwt) {
        if (StringUtils.isNotBlank((CharSequence)redirectUri) || requestJwt == null) {
            return redirectUri;
        }
        String valueFromJwt = requestJwt.getClaims().getClaimAsString("redirect_uri");
        this.log.trace("redirectUriFromJwt: {}", (Object)valueFromJwt);
        return valueFromJwt;
    }

    private String getClientId(String clientId, Jwt requestJwt) {
        if (StringUtils.isNotBlank((CharSequence)clientId) || requestJwt == null) {
            return clientId;
        }
        String valueFromJwt = requestJwt.getClaims().getClaimAsString("client_id");
        this.log.trace("clientIdFromJwt: {}", (Object)valueFromJwt);
        return valueFromJwt;
    }

    @PUT
    public Response unsupportedPutMethod() {
        this.log.error("PUT method is not allowed");
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"GET Method Not Allowed").build());
    }

    @GET
    public Response unsupportedGetMethod() {
        this.log.error("GET method is not allowed");
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"GET Method Not Allowed").build());
    }

    @HEAD
    public Response unsupportedHeadMethod() {
        this.log.error("HEAD method is not allowed");
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"HEAD Method Not Allowed").build());
    }

    @OPTIONS
    public Response unsupportedOptionsMethod() {
        this.log.error("OPTIONS method is not allowed");
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.METHOD_NOT_ALLOWED).entity((Object)"OPTIONS Method Not Allowed").build());
    }
}

