/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.par.ws.rs;

import com.google.common.collect.Lists;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.authorize.CodeVerifier;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.util.StringUtils;
import io.jans.as.model.util.Util;
import io.jans.as.persistence.model.Par;
import io.jans.as.server.authorize.ws.rs.AuthorizeRestWebServiceValidator;
import io.jans.as.server.model.authorize.Claim;
import io.jans.as.server.model.authorize.IdTokenMember;
import io.jans.as.server.model.authorize.JwtAuthorizationRequest;
import io.jans.as.server.model.authorize.ScopeChecker;
import io.jans.as.server.model.session.SessionClient;
import io.jans.as.server.security.Identity;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.RedirectUriResponse;
import io.jans.as.server.service.RequestParameterService;
import io.jans.as.server.util.ServerUtil;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ApplicationScoped
public class ParValidator {
    @Inject
    private Logger log;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private AuthorizeRestWebServiceValidator authorizeRestWebServiceValidator;
    @Inject
    private ScopeChecker scopeChecker;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private Identity identity;
    @Inject
    private ClientService clientService;

    public void validateRequestUriIsAbsent(@Nullable String requestUri) {
        this.validateRequestUriIsAbsent(requestUri, (IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST);
    }

    public void validateRequestUriIsAbsent(@Nullable String requestUri, @NotNull IErrorType error) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)requestUri)) {
            return;
        }
        this.log.trace("request_uri parameter is not allowed at PAR endpoint. Return error.");
        throw this.errorResponseFactory.createBadRequestException(error, "");
    }

    public void validateRequestObject(RedirectUriResponse redirectUriResponse, Par par, Client client) {
        String request = par.getAttributes().getRequest();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)request)) {
            return;
        }
        try {
            JwtAuthorizationRequest jwtRequest = JwtAuthorizationRequest.createJwtRequest(request, null, client, redirectUriResponse, this.cryptoProvider, this.appConfiguration);
            if (jwtRequest == null) {
                throw this.authorizeRestWebServiceValidator.createInvalidJwtRequestException(redirectUriResponse, "Failed to parse jwt.");
            }
            this.validateRequestUriIsAbsent(jwtRequest.getJsonPayload().optString("request_uri"), (IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT);
            this.setStateIntoPar(redirectUriResponse, par, jwtRequest);
            this.authorizeRestWebServiceValidator.validateRequestObject(jwtRequest, redirectUriResponse);
            if (!jwtRequest.getResponseTypes().isEmpty()) {
                par.getAttributes().setResponseType(jwtRequest.getJsonPayload().optString("response_type"));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jwtRequest.getClientId())) {
                par.getAttributes().setClientId(jwtRequest.getClientId());
            }
            if (jwtRequest.getNbf() != null) {
                par.getAttributes().setNbf(jwtRequest.getNbf());
            }
            if (jwtRequest.getExp() != null) {
                par.setTtl(jwtRequest.getExp());
                par.setExpirationDate(Util.createExpirationDate((Integer)jwtRequest.getExp()));
            }
            if (jwtRequest.getExp() != null) {
                par.setTtl(Integer.valueOf(ServerUtil.calculateTtl(jwtRequest.getExp())));
                par.setExpirationDate(new Date((long)jwtRequest.getExp().intValue() * 1000L));
            }
            if (!jwtRequest.getScopes().isEmpty()) {
                Set<String> scopes = this.scopeChecker.checkScopesPolicy(client, Lists.newArrayList(jwtRequest.getScopes()));
                par.getAttributes().setScope(StringUtils.implode(scopes, (String)" "));
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jwtRequest.getRedirectUri())) {
                par.getAttributes().setRedirectUri(jwtRequest.getRedirectUri());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jwtRequest.getNonce())) {
                par.getAttributes().setNonce(jwtRequest.getNonce());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jwtRequest.getCodeChallenge())) {
                par.getAttributes().setCodeChallenge(jwtRequest.getCodeChallenge());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jwtRequest.getCodeChallengeMethod())) {
                par.getAttributes().setCodeChallengeMethod(jwtRequest.getCodeChallengeMethod());
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jwtRequest.getDpopJkt())) {
                par.getAttributes().setDpopJkt(jwtRequest.getDpopJkt());
            }
            if (jwtRequest.getDisplay() != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jwtRequest.getDisplay().getParamName())) {
                par.getAttributes().setDisplay(jwtRequest.getDisplay().getParamName());
            }
            if (!jwtRequest.getPrompts().isEmpty()) {
                par.getAttributes().setPrompt(jwtRequest.getJsonPayload().optString("prompt"));
            }
            if (jwtRequest.getResponseMode() != null) {
                redirectUriResponse.getRedirectUri().setResponseMode(jwtRequest.getResponseMode());
                par.getAttributes().setResponseMode(jwtRequest.getJsonPayload().optString("response_mode"));
            }
            this.setParAttributesFromIdTokenMember(par, jwtRequest);
            this.requestParameterService.getCustomParameters(jwtRequest, par.getAttributes().getCustomParameters());
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("Invalid JWT authorization request. Message : " + e.getMessage(), (Throwable)e);
            throw this.authorizeRestWebServiceValidator.createInvalidJwtRequestException(redirectUriResponse, "Invalid JWT authorization request");
        }
    }

    private void setParAttributesFromIdTokenMember(@NotNull Par par, @NotNull JwtAuthorizationRequest jwtRequest) {
        Claim acrClaim;
        IdTokenMember idTokenMember = jwtRequest.getIdTokenMember();
        if (idTokenMember == null) {
            return;
        }
        if (idTokenMember.getMaxAge() != null) {
            par.getAttributes().setMaxAge(idTokenMember.getMaxAge());
        }
        if ((acrClaim = idTokenMember.getClaim("acr")) != null && acrClaim.getClaimValue() != null) {
            par.getAttributes().setAcrValuesStr(acrClaim.getClaimValue().getValueAsString());
        }
    }

    private void setStateIntoPar(@NotNull RedirectUriResponse redirectUriResponse, @NotNull Par par, @NotNull JwtAuthorizationRequest jwtRequest) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jwtRequest.getState())) {
            par.getAttributes().setState(jwtRequest.getState());
            redirectUriResponse.setState(jwtRequest.getState());
        }
        if (this.appConfiguration.isFapi() && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)jwtRequest.getState())) {
            par.getAttributes().setState("");
            redirectUriResponse.setState("");
        }
    }

    public void validateAuthentication(String clientId, String state) {
        Client client;
        SessionClient sessionClient = this.identity.getSessionClient();
        Client client2 = client = sessionClient != null ? sessionClient.getClient() : null;
        if (client == null) {
            client = this.clientService.getClient(clientId);
        }
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getParForbidPublicClient()) && (client == null || this.clientService.isPublic(client))) {
            this.log.trace("Client is public or not authenticated which is not allowed by 'parForbidPublicClient' AS configuration property.");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state, "")).build());
        }
    }

    public void validatePkce(String codeChallenge, String codeChallengeMethod, String state) {
        if (!this.appConfiguration.isFapi()) {
            return;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)codeChallengeMethod) || CodeVerifier.CodeChallengeMethod.fromString((String)codeChallengeMethod) == CodeVerifier.CodeChallengeMethod.PLAIN) {
            this.log.error("code_challenge_method is invalid: {} (plain or blank method is not allowed)", (Object)codeChallengeMethod);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, state, "")).build());
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)codeChallenge)) {
            this.log.error("code_challenge is blank");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, state, "")).build());
        }
    }
}

