/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.register.ws.rs;

import com.google.common.base.Strings;
import io.jans.as.client.RegisterRequest;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.SoftwareStatementValidationType;
import io.jans.as.model.common.SubjectType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.configuration.TrustedIssuerConfig;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.exception.CryptoProviderException;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.register.RegisterErrorResponseType;
import io.jans.as.model.register.RegisterRequestParam;
import io.jans.as.model.ssa.SsaValidationType;
import io.jans.as.model.util.Pair;
import io.jans.as.model.util.StringUtils;
import io.jans.as.server.ciba.CIBARegisterParamsValidatorService;
import io.jans.as.server.model.common.AbstractToken;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.model.registration.RegisterParamsValidator;
import io.jans.as.server.register.ws.rs.SsaValidationConfigContext;
import io.jans.as.server.register.ws.rs.SsaValidationConfigService;
import io.jans.as.server.service.external.ExternalDynamicClientRegistrationService;
import io.jans.as.server.service.net.UriService;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

@Stateless
@Named
public class RegisterValidator {
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private ExternalDynamicClientRegistrationService externalDynamicClientRegistrationService;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private CIBARegisterParamsValidatorService cibaRegisterParamsValidatorService;
    @Inject
    private RegisterParamsValidator registerParamsValidator;
    @Inject
    private SsaValidationConfigService ssaValidationConfigService;
    @Inject
    private UriService uriService;

    public void validateNotBlank(String input, String errorReason) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)input)) {
            this.log.trace("Failed to perform client action, reason: {}", (Object)errorReason);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "");
        }
    }

    public void validateEvidence(RegisterRequest registerRequest) {
        if (BooleanUtils.isFalse((Boolean)this.appConfiguration.getDcrAttestationEvidenceRequired())) {
            return;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registerRequest.getEvidence())) {
            return;
        }
        throw this.createStaleEvidenceWebApplicationException();
    }

    public WebApplicationException createStaleEvidenceWebApplicationException() {
        String entity = this.errorResponseFactory.errorAsJson((IErrorType)RegisterErrorResponseType.STALE_EVIDENCE, "");
        String nonce = UUID.randomUUID().toString();
        JSONObject json = new JSONObject(entity);
        json.put("nonce", (Object)nonce);
        return new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)json.toString()).type(MediaType.APPLICATION_JSON_TYPE).build());
    }

    public void validateRequestObject(String requestParams, JSONObject softwareStatement, HttpServletRequest httpRequest) {
        try {
            if (BooleanUtils.isFalse((Boolean)this.appConfiguration.getDcrSignatureValidationEnabled())) {
                return;
            }
            Jwt jwt = Jwt.parseOrThrow((String)requestParams);
            SignatureAlgorithm signatureAlgorithm = jwt.getHeader().getSignatureAlgorithm();
            SsaValidationConfigContext ssaContext = new SsaValidationConfigContext(jwt, SsaValidationType.DCR);
            boolean isHmac = AlgorithmFamily.HMAC.equals((Object)signatureAlgorithm.getFamily());
            if (isHmac) {
                this.validateRequestObjectHmac(httpRequest, ssaContext);
                return;
            }
            String jwksUri = null;
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getDcrSignatureValidationSoftwareStatementJwksURIClaim())) {
                jwksUri = softwareStatement.optString(this.appConfiguration.getDcrSignatureValidationSoftwareStatementJwksURIClaim());
            }
            if (org.apache.commons.lang3.StringUtils.isBlank(jwksUri) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getDcrSignatureValidationJwksUri())) {
                jwksUri = this.appConfiguration.getDcrSignatureValidationJwksUri();
            }
            String jwksStr = this.getJwksString(softwareStatement);
            JSONObject jwks = this.getJwks(httpRequest, jwt, jwksUri, jwksStr);
            this.log.trace("Validating request object with jwks: {} ...", (Object)jwks);
            boolean validSignature = this.cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), jwt.getHeader().getKeyId(), jwks, null, signatureAlgorithm);
            this.log.trace("Request object validation result: {}", (Object)validSignature);
            if (validSignature) {
                return;
            }
            if (this.validateRequestObjectSignatureWithSsaValidationConfigs(requestParams)) {
                return;
            }
            throw new InvalidJwtException("Invalid request object.");
        }
        catch (Exception e) {
            if (this.validateRequestObjectSignatureWithSsaValidationConfigs(requestParams)) {
                return;
            }
            String msg = "Unable to validate request object JWT.";
            this.log.error("Unable to validate request object JWT.", (Throwable)e);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Unable to validate request object JWT.");
        }
    }

    private boolean validateRequestObjectSignatureWithSsaValidationConfigs(String requestParams) {
        try {
            SsaValidationConfigContext ssaContext = new SsaValidationConfigContext(Jwt.parseOrThrow((String)requestParams), SsaValidationType.DCR);
            boolean valid = this.ssaValidationConfigService.hasValidSignature(ssaContext);
            this.log.trace("Request object validation result for ssaValidationConfigs: {}", (Object)valid);
            if (valid) {
                this.log.trace("Request object successfully validated by ssaValidationConfig: {}", (Object)ssaContext.getSuccessfulConfig());
                return true;
            }
        }
        catch (InvalidJwtException e) {
            this.log.error("Unable to validate request object JWT.", (Throwable)e);
        }
        return false;
    }

    private void validateRequestObjectHmac(HttpServletRequest httpRequest, SsaValidationConfigContext ssaContext) throws CryptoProviderException, InvalidJwtException {
        Jwt jwt = ssaContext.getJwt();
        if (this.ssaValidationConfigService.isHmacValid(ssaContext)) {
            this.log.trace("Request object successfully validated by ssaValidationConfig: {}", (Object)ssaContext.getSuccessfulConfig());
            return;
        }
        String hmacSecret = this.appConfiguration.getDcrSignatureValidationSharedSecret();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)hmacSecret)) {
            hmacSecret = this.externalDynamicClientRegistrationService.getDcrHmacSecret(httpRequest, jwt);
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)hmacSecret)) {
            this.log.error("No hmacSecret provided in Dynamic Client Registration script (method getDcrHmacSecret didn't return actual secret). ");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_SOFTWARE_STATEMENT, "");
        }
        boolean validSignature = this.cryptoProvider.verifySignature(jwt.getSigningInput(), jwt.getEncodedSignature(), null, null, hmacSecret, jwt.getHeader().getSignatureAlgorithm());
        this.log.trace("Request object validation result: {}", (Object)validSignature);
        if (validSignature) {
            return;
        }
        throw new InvalidJwtException("Invalid cryptographic segment in the request object.");
    }

    @Nullable
    private String getJwksString(JSONObject softwareStatement) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getDcrSignatureValidationSoftwareStatementJwksClaim())) {
            return softwareStatement.optString(this.appConfiguration.getDcrSignatureValidationSoftwareStatementJwksClaim());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.appConfiguration.getDcrSignatureValidationJwks())) {
            return this.appConfiguration.getDcrSignatureValidationJwks();
        }
        return null;
    }

    @Nullable
    private JSONObject getJwks(HttpServletRequest httpRequest, Jwt jwt, String jwksUri, String jwksStr) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jwksUri)) {
            return this.uriService.loadJson(jwksUri);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jwksStr)) {
            return new JSONObject(jwksStr);
        }
        if (this.externalDynamicClientRegistrationService.isEnabled()) {
            this.log.trace("No values are set for dcrSignatureValidationJwksUri and dcrSignatureValidationJwks, invoking script ...");
            JSONObject jwks = this.externalDynamicClientRegistrationService.getDcrJwks(httpRequest, jwt);
            if (jwks == null) {
                this.log.error("No jwks provided in Dynamic Client Registration script (method getDcrJwks didn't return actual jwks). ");
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_SOFTWARE_STATEMENT, "");
            }
            return jwks;
        }
        return null;
    }

    public JSONObject validateSoftwareStatement(HttpServletRequest httpServletRequest, JSONObject requestObject) {
        JSONObject jsonObject = this.validateSSA(httpServletRequest, requestObject);
        if (jsonObject == null) {
            return null;
        }
        TrustedIssuerConfig trustedIssuerConfig = this.validateIssuer(jsonObject);
        this.applyTrustedIssuerConfig(trustedIssuerConfig, jsonObject);
        return jsonObject;
    }

    public void applyTrustedIssuerConfig(TrustedIssuerConfig trustedIssuerConfig, JSONObject jsonObject) {
        JSONArray scopeJsonArray;
        if (trustedIssuerConfig == null) {
            return;
        }
        List automaticallyGrantedScopes = trustedIssuerConfig.getAutomaticallyGrantedScopes();
        if (automaticallyGrantedScopes.isEmpty()) {
            return;
        }
        HashSet scopes = new HashSet(automaticallyGrantedScopes);
        String scopeString = jsonObject.optString(RegisterRequestParam.SCOPE.toString());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)scopeString)) {
            scopes.addAll(StringUtils.spaceSeparatedToList((String)scopeString));
        }
        if ((scopeJsonArray = jsonObject.optJSONArray(RegisterRequestParam.SCOPE.toString())) != null) {
            scopes.addAll(StringUtils.toList((JSONArray)scopeJsonArray));
        }
        jsonObject.putOpt(RegisterRequestParam.SCOPE.toString(), (Object)StringUtils.implode(scopes, (String)" "));
    }

    public TrustedIssuerConfig validateIssuer(JSONObject jsonObject) {
        String issuer = jsonObject.optString("iss");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)issuer)) {
            this.log.trace("SSA does not contain 'iss' (issuer).");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_SOFTWARE_STATEMENT, "Failed to find 'iss' (issuer) in software statement");
        }
        Map trustedSsaIssuers = this.appConfiguration.getTrustedSsaIssuers();
        if (trustedSsaIssuers.isEmpty()) {
            return null;
        }
        TrustedIssuerConfig trustedIssuerConfig = (TrustedIssuerConfig)trustedSsaIssuers.get(issuer);
        if (trustedIssuerConfig == null) {
            this.log.trace("SSA issuer is not added as trusted in 'trustedSsaIssuers' AS configuration.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_SOFTWARE_STATEMENT, "Failed to validate 'iss' (issuer) of software statement.");
        }
        return trustedIssuerConfig;
    }

    public JSONObject validateSSA(HttpServletRequest httpServletRequest, JSONObject requestObject) {
        if (!requestObject.has(RegisterRequestParam.SOFTWARE_STATEMENT.toString())) {
            return null;
        }
        try {
            boolean validSignature;
            JSONObject jwks;
            Jwt softwareStatement = Jwt.parseOrThrow((String)requestObject.getString(RegisterRequestParam.SOFTWARE_STATEMENT.toString()));
            SignatureAlgorithm signatureAlgorithm = softwareStatement.getHeader().getSignatureAlgorithm();
            SoftwareStatementValidationType validationType = SoftwareStatementValidationType.fromString((String)this.appConfiguration.getSoftwareStatementValidationType());
            this.printWarningIfNeeded(validationType);
            if (validationType == SoftwareStatementValidationType.NONE) {
                this.log.trace("software_statement validation was skipped due to `softwareStatementValidationType` configuration property set to none. (Not recommended.)");
                return softwareStatement.getClaims().toJsonObject();
            }
            if (validationType == SoftwareStatementValidationType.SCRIPT) {
                return this.validateSoftwareStatementForScript(httpServletRequest, requestObject, softwareStatement, signatureAlgorithm);
            }
            if (validationType == SoftwareStatementValidationType.BUILTIN) {
                return this.ssaValidationConfigService.validateSsaForBuiltIn(softwareStatement);
            }
            if ((validationType == SoftwareStatementValidationType.JWKS_URI || validationType == SoftwareStatementValidationType.JWKS) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.appConfiguration.getSoftwareStatementValidationClaimName())) {
                this.log.error("softwareStatementValidationClaimName configuration property is not specified. Please specify claim name from software_statement which points to jwks (or jwks_uri).");
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_SOFTWARE_STATEMENT, "Failed to validate software statement");
            }
            String jwksUriClaim = null;
            if (validationType == SoftwareStatementValidationType.JWKS_URI) {
                jwksUriClaim = softwareStatement.getClaims().getClaimAsString(this.appConfiguration.getSoftwareStatementValidationClaimName());
            }
            String jwksClaim = null;
            if (validationType == SoftwareStatementValidationType.JWKS) {
                jwksClaim = softwareStatement.getClaims().getClaimAsString(this.appConfiguration.getSoftwareStatementValidationClaimName());
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)jwksUriClaim) && org.apache.commons.lang3.StringUtils.isBlank(jwksClaim)) {
                String msg = String.format("software_statement does not contain `%s` claim and thus is considered as invalid.", this.appConfiguration.getSoftwareStatementValidationClaimName());
                this.log.error(msg);
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_SOFTWARE_STATEMENT, msg);
            }
            JSONObject jSONObject = jwks = Strings.isNullOrEmpty((String)jwksUriClaim) ? null : this.uriService.loadJson(jwksUriClaim);
            if (jwks == null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jwksClaim)) {
                jwks = new JSONObject(jwksClaim);
            }
            if (!(validSignature = this.cryptoProvider.verifySignature(softwareStatement.getSigningInput(), softwareStatement.getEncodedSignature(), softwareStatement.getHeader().getKeyId(), jwks, null, signatureAlgorithm))) {
                throw new InvalidJwtException("Invalid cryptographic segment in the software statement");
            }
            return softwareStatement.getClaims().toJsonObject();
        }
        catch (Exception e) {
            String msg = "Invalid software_statement.";
            this.log.error("Invalid software_statement.", (Throwable)e);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_SOFTWARE_STATEMENT, "Invalid software_statement.");
        }
    }

    private void printWarningIfNeeded(SoftwareStatementValidationType validationType) {
        if (validationType == SoftwareStatementValidationType.SCRIPT || validationType == SoftwareStatementValidationType.BUILTIN) {
            return;
        }
        this.log.warn("It is strongly recommended to use SCRIPT or BUILTIN value for softwareStatementValidationType configuration property.");
    }

    @Nullable
    private JSONObject validateSoftwareStatementForScript(HttpServletRequest httpServletRequest, JSONObject requestObject, Jwt softwareStatement, SignatureAlgorithm signatureAlgorithm) throws CryptoProviderException, InvalidJwtException {
        if (!this.externalDynamicClientRegistrationService.isEnabled()) {
            this.log.error("Server is mis-configured. softwareStatementValidationType=script but there is no any Dynamic Client Registration script enabled.");
            return null;
        }
        if (AlgorithmFamily.HMAC.equals((Object)signatureAlgorithm.getFamily())) {
            String hmacSecret = this.externalDynamicClientRegistrationService.getSoftwareStatementHmacSecret(httpServletRequest, requestObject, softwareStatement);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)hmacSecret)) {
                this.log.error("No hmacSecret provided in Dynamic Client Registration script (method getSoftwareStatementHmacSecret didn't return actual secret). ");
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_SOFTWARE_STATEMENT, "");
            }
            if (!this.cryptoProvider.verifySignature(softwareStatement.getSigningInput(), softwareStatement.getEncodedSignature(), null, null, hmacSecret, signatureAlgorithm)) {
                throw new InvalidJwtException("Invalid signature in the software statement");
            }
            return softwareStatement.getClaims().toJsonObject();
        }
        JSONObject softwareStatementJwks = this.externalDynamicClientRegistrationService.getSoftwareStatementJwks(httpServletRequest, requestObject, softwareStatement);
        if (softwareStatementJwks == null) {
            this.log.error("No jwks provided in Dynamic Client Registration script (method getSoftwareStatementJwks didn't return actual jwks). ");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_SOFTWARE_STATEMENT, "");
        }
        if (!this.cryptoProvider.verifySignature(softwareStatement.getSigningInput(), softwareStatement.getEncodedSignature(), softwareStatement.getHeader().getKeyId(), softwareStatementJwks, null, signatureAlgorithm)) {
            throw new InvalidJwtException("Invalid signature in the software statement");
        }
        return softwareStatement.getClaims().toJsonObject();
    }

    public void validateSubjectIdentifierAttribute(RegisterRequest registerRequest) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registerRequest.getSubjectIdentifierAttribute())) {
            if (Boolean.FALSE.equals(this.appConfiguration.getPublicSubjectIdentifierPerClientEnabled())) {
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_PUBLIC_SUBJECT_IDENTIFIER_ATTRIBUTE, "The public subject identifier per client is disabled.");
            }
            if (registerRequest.getSubjectType() != SubjectType.PUBLIC) {
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_PUBLIC_SUBJECT_IDENTIFIER_ATTRIBUTE, "The custom subject identifier requires public subject type.");
            }
            if (!this.appConfiguration.getSubjectIdentifiersPerClientSupported().contains(registerRequest.getSubjectIdentifierAttribute())) {
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_PUBLIC_SUBJECT_IDENTIFIER_ATTRIBUTE, "Invalid subject identifier attribute.");
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registerRequest.getRedirectUrisRegex()) && Boolean.FALSE.equals(this.appConfiguration.getRedirectUrisRegexEnabled())) {
            throw this.errorResponseFactory.createBadRequestException((IErrorType)RegisterErrorResponseType.INVALID_REDIRECT_URIS_REGEX, "The redirect URI's Regex is disabled.");
        }
    }

    public void validateAuthorizationAccessToken(String accessToken, String clientId) {
        if (BooleanUtils.isFalse((Boolean)this.appConfiguration.getDcrAuthorizationWithClientCredentials())) {
            return;
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)accessToken) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)clientId)) {
            this.log.trace("Access Token or clientId is blank.");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)RegisterErrorResponseType.INVALID_TOKEN, "The Access Token is not valid for the Client ID.")).build());
        }
        AuthorizationGrant grant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(accessToken);
        if (grant == null) {
            this.log.trace("Unable to find grant by access token: {}", (Object)accessToken);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)RegisterErrorResponseType.INVALID_TOKEN, "The Access Token grant is not found.")).build());
        }
        AbstractToken accessTokenObj = grant.getAccessToken(accessToken);
        if (accessTokenObj == null || !accessTokenObj.isValid()) {
            this.log.trace("Unable to find access token object or otherwise it's expired.");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)RegisterErrorResponseType.INVALID_TOKEN, "The Access Token object is not found or otherwise expired.")).build());
        }
        if (!clientId.equals(grant.getClientId())) {
            this.log.trace("ClientId from request does not match to access token's client id.");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)RegisterErrorResponseType.INVALID_TOKEN, "The Access Token object is not found or otherwise expired.")).build());
        }
    }

    public void validateCiba(RegisterRequest r) {
        if (!this.cibaRegisterParamsValidatorService.validateParams(r.getBackchannelTokenDeliveryMode(), r.getBackchannelClientNotificationEndpoint(), r.getBackchannelAuthenticationRequestSigningAlg(), r.getGrantTypes(), r.getSubjectType(), r.getSectorIdentifierUri(), r.getJwks(), r.getJwksUri())) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "Invalid Client Metadata registering to use CIBA (Client Initiated Backchannel Authentication).");
        }
    }

    public void validateRedirectUris(RegisterRequest r) {
        if (!this.registerParamsValidator.validateRedirectUris(r.getGrantTypes(), r.getResponseTypes(), r.getApplicationType(), r.getSubjectType(), r.getRedirectUris(), r.getSectorIdentifierUri())) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_REDIRECT_URI, "Failed to validate redirect uris.");
        }
    }

    public void validateParamsClientRegister(RegisterRequest r) {
        Pair<Boolean, String> validateResult = this.registerParamsValidator.validateParamsClientRegister(r.getApplicationType(), r.getSubjectType(), r.getGrantTypes(), r.getResponseTypes(), r.getRedirectUris());
        if (BooleanUtils.isFalse((Boolean)((Boolean)validateResult.getFirst()))) {
            this.log.trace("Client parameters are invalid, returns invalid_request error. Reason: {}", validateResult.getSecond());
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, (String)validateResult.getSecond());
        }
    }

    public void validateInitiateLoginUri(RegisterRequest r) {
        if (!Strings.isNullOrEmpty((String)r.getInitiateLoginUri()) && !this.registerParamsValidator.validateInitiateLoginUri(r.getInitiateLoginUri())) {
            this.log.debug("The Initiate Login Uri is invalid. The initiate_login_uri must use the https schema: {}", (Object)r.getInitiateLoginUri());
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "The Initiate Login Uri is invalid. The initiate_login_uri must use the https schema.");
        }
    }

    public void validateClaimsRedirectUris(RegisterRequest r) {
        if (r.getClaimsRedirectUris() != null && !r.getClaimsRedirectUris().isEmpty() && !this.registerParamsValidator.validateRedirectUris(r.getGrantTypes(), r.getResponseTypes(), r.getApplicationType(), r.getSubjectType(), r.getClaimsRedirectUris(), r.getSectorIdentifierUri())) {
            this.log.debug("Value of one or more claims_redirect_uris is invalid, claims_redirect_uris: {}", (Object)r.getClaimsRedirectUris());
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLAIMS_REDIRECT_URI, "Value of one or more claims_redirect_uris is invalid");
        }
    }

    public void validatePasswordGrantType(RegisterRequest r) {
        if (BooleanUtils.isFalse((Boolean)this.appConfiguration.getDynamicRegistrationPasswordGrantTypeEnabled()) && this.registerParamsValidator.checkIfThereIsPasswordGrantType(r.getGrantTypes())) {
            this.log.info("Password Grant Type is not allowed for Dynamic Client Registration.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.ACCESS_DENIED, "Password Grant Type is not allowed for Dynamic Client Registration.");
        }
    }

    public void validateDcrAuthorizationWithClientCredentials(RegisterRequest r) {
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getDcrAuthorizationWithClientCredentials()) && !r.getGrantTypes().contains(GrantType.CLIENT_CREDENTIALS)) {
            this.log.info("Register request does not contain grant_type=client_credentials, however dcrAuthorizationWithClientCredentials=true which is forbidden.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.ACCESS_DENIED, "Client Credentials Grant Type is not present in Dynamic Client Registration request.");
        }
    }
}

