/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.register.ws.rs.action;

import io.jans.as.client.RegisterRequest;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.service.common.InumService;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.common.SubjectType;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.register.RegisterErrorResponseType;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.model.audit.Action;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.registration.RegisterParamsValidator;
import io.jans.as.server.register.ws.rs.RegisterJsonService;
import io.jans.as.server.register.ws.rs.RegisterService;
import io.jans.as.server.register.ws.rs.RegisterValidator;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.external.ExternalDynamicClientRegistrationService;
import io.jans.as.server.util.ServerUtil;
import io.jans.util.security.StringEncrypter;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;

@Stateless
@Named
public class RegisterCreateAction {
    @Inject
    private Logger log;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private InumService inumService;
    @Inject
    private ClientService clientService;
    @Inject
    private ExternalDynamicClientRegistrationService externalDynamicClientRegistrationService;
    @Inject
    private RegisterParamsValidator registerParamsValidator;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private RegisterValidator registerValidator;
    @Inject
    private RegisterJsonService registerJsonService;
    @Inject
    private RegisterService registerService;

    public Response createClient(String requestParams, HttpServletRequest httpRequest, SecurityContext securityContext) {
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.REGISTRATION);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.CREATED);
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpRequest), Action.CLIENT_REGISTRATION);
        try {
            this.log.trace("Registration request = {}", (Object)requestParams);
            JSONObject requestObject = this.registerService.parseRequestObjectWithoutValidation(requestParams);
            JSONObject softwareStatement = this.registerValidator.validateSoftwareStatement(httpRequest, requestObject);
            this.overrideRequestObjectFromSoftwareStatement(requestObject, softwareStatement);
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getDcrSignatureValidationEnabled())) {
                this.registerValidator.validateRequestObject(requestParams, softwareStatement, httpRequest);
            }
            RegisterRequest r = RegisterRequest.fromJson((JSONObject)requestObject);
            this.log.info("Attempting to register client: applicationType = {}, clientName = {}, redirectUris = {}, isSecure = {}, sectorIdentifierUri = {}, defaultAcrValues = {}, evidence = {}", new Object[]{r.getApplicationType(), r.getClientName(), r.getRedirectUris(), securityContext.isSecure(), r.getSectorIdentifierUri(), r.getDefaultAcrValues(), r.getEvidence()});
            this.registerValidator.validateEvidence(r);
            this.registerValidator.validatePasswordGrantType(r);
            this.registerValidator.validateDcrAuthorizationWithClientCredentials(r);
            this.setSubjectType(r);
            this.setIdTokenSignedResponseAlg(r);
            this.setAccessTokenSigningAlgFallback(r);
            this.registerParamsValidator.validateAlgorithms(r);
            this.registerValidator.validateClaimsRedirectUris(r);
            this.registerValidator.validateInitiateLoginUri(r);
            this.registerValidator.validateParamsClientRegister(r);
            this.registerValidator.validateRedirectUris(r);
            this.registerValidator.validateSubjectIdentifierAttribute(r);
            this.registerValidator.validateCiba(r);
            this.registerParamsValidator.validateLogoutUri(r.getFrontChannelLogoutUri(), (List<String>)r.getRedirectUris(), this.errorResponseFactory);
            this.registerParamsValidator.validateLogoutUri(r.getBackchannelLogoutUri(), (List<String>)r.getRedirectUris(), this.errorResponseFactory);
            String clientsBaseDN = this.staticConfiguration.getBaseDn().getClients();
            String inum = this.inumService.generateClientInum();
            String generatedClientSecret = UUID.randomUUID().toString();
            Client client = new Client();
            client.setDn("inum=" + inum + "," + clientsBaseDN);
            client.setClientId(inum);
            client.setDeletable(Boolean.valueOf(true));
            client.setClientSecret(this.clientService.encryptSecret(generatedClientSecret));
            client.setRegistrationAccessToken(this.clientService.generateRegistrationAccessToken());
            client.setIdTokenTokenBindingCnf(r.getIdTokenTokenBindingCnf());
            GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            client.setClientIdIssuedAt(calendar.getTime());
            int lifetime = this.getClientLifetime(r);
            if (lifetime > 0) {
                ((Calendar)calendar).add(13, lifetime);
                client.setClientSecretExpiresAt(calendar.getTime());
                client.setExpirationDate(calendar.getTime());
                client.setTtl(Integer.valueOf(lifetime));
            }
            client.setDeletable(Boolean.valueOf(client.getExpirationDate() != null));
            this.setClientName(r, client);
            this.registerService.updateClientFromRequestObject(client, r, false);
            this.executeDynamicScrypt(r, client, httpRequest);
            Date currentTime = Calendar.getInstance().getTime();
            client.setLastAccessTime(currentTime);
            client.setLastLogonTime(currentTime);
            client.setPersistClientAuthorizations(BooleanUtils.isTrue((Boolean)this.appConfiguration.getDynamicRegistrationPersistClientAuthorizations()));
            this.clientService.persist(client);
            JSONObject jsonObject = this.registerJsonService.getJSONObject(client);
            jsonObject = this.modifyPostScript(jsonObject, new ExecutionContext(httpRequest, null).setClient(client));
            builder.entity((Object)this.registerJsonService.jsonObjectToString(jsonObject));
            this.log.info("Client registered: clientId = {}, applicationType = {}, clientName = {}, redirectUris = {}, sectorIdentifierUri = {}, redirectUrisRegex = {}", new Object[]{client.getClientId(), client.getApplicationType(), client.getClientName(), client.getRedirectUris(), client.getSectorIdentifierUri(), client.getAttributes().getRedirectUrisRegex()});
            oAuth2AuditLog.setClientId(client.getClientId());
            oAuth2AuditLog.setScope(this.registerService.clientScopesToString(client));
            oAuth2AuditLog.setSuccess(true);
        }
        catch (WebApplicationException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            builder = this.registerService.createInternalErrorResponse("Unknown");
            this.log.error(e.getMessage(), (Throwable)e);
        }
        builder.cacheControl(ServerUtil.cacheControl(true, false));
        builder.header("Pragma", (Object)"no-cache");
        builder.type(MediaType.APPLICATION_JSON_TYPE);
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }

    public int getClientLifetime(RegisterRequest registerRequest) {
        int lifetime = this.appConfiguration.getDynamicRegistrationExpirationTime();
        Integer requestedLifeTime = registerRequest.getLifetime();
        if (BooleanUtils.isFalse((Boolean)this.appConfiguration.getDcrForbidExpirationTimeInRequest()) && requestedLifeTime != null) {
            return requestedLifeTime;
        }
        return lifetime;
    }

    private void executeDynamicScrypt(RegisterRequest r, Client client, HttpServletRequest httpRequest) {
        boolean registerClient = true;
        if (this.externalDynamicClientRegistrationService.isEnabled()) {
            registerClient = this.externalDynamicClientRegistrationService.executeExternalCreateClientMethods(r, client, httpRequest);
        }
        if (!registerClient) {
            this.clientService.removeFromCache(client);
            this.log.trace("Client parameters are invalid, returns invalid_request error. External registration script returned false.");
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)RegisterErrorResponseType.INVALID_CLIENT_METADATA, "External registration script returned false.");
        }
    }

    private void overrideRequestObjectFromSoftwareStatement(JSONObject requestObject, JSONObject softwareStatement) {
        if (softwareStatement == null) {
            return;
        }
        this.log.trace("Override request parameters by software_statement");
        for (String key : softwareStatement.keySet()) {
            requestObject.putOpt(key, softwareStatement.get(key));
        }
    }

    private void setSubjectType(RegisterRequest r) {
        if (r.getSubjectType() == null) {
            SubjectType defaultSubjectType = SubjectType.fromString((String)this.appConfiguration.getDefaultSubjectType());
            if (defaultSubjectType != null) {
                r.setSubjectType(defaultSubjectType);
            } else if (this.appConfiguration.getSubjectTypesSupported().contains(SubjectType.PUBLIC.toString())) {
                r.setSubjectType(SubjectType.PUBLIC);
            } else if (this.appConfiguration.getSubjectTypesSupported().contains(SubjectType.PAIRWISE.toString())) {
                r.setSubjectType(SubjectType.PAIRWISE);
            }
        }
    }

    private void setAccessTokenSigningAlgFallback(RegisterRequest r) {
        if (r.getAccessTokenSigningAlg() == null) {
            r.setAccessTokenSigningAlg(SignatureAlgorithm.fromString((String)this.appConfiguration.getDefaultSignatureAlgorithm()));
        }
    }

    private void setIdTokenSignedResponseAlg(RegisterRequest r) {
        if (r.getIdTokenSignedResponseAlg() == null) {
            r.setIdTokenSignedResponseAlg(SignatureAlgorithm.fromString((String)this.appConfiguration.getDefaultSignatureAlgorithm()));
        }
    }

    private void setClientName(RegisterRequest r, Client client) {
        if (StringUtils.isBlank((CharSequence)r.getClientName()) && r.getRedirectUris() != null && !r.getRedirectUris().isEmpty()) {
            try {
                URI redUri = new URI((String)r.getRedirectUris().get(0));
                client.setClientName(redUri.getHost());
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                client.setClientName("Unknown");
            }
        }
    }

    private JSONObject modifyPostScript(JSONObject jsonObject, ExecutionContext executionContext) throws StringEncrypter.EncryptionException {
        if (!this.externalDynamicClientRegistrationService.modifyPostResponse(jsonObject, executionContext)) {
            return this.registerJsonService.getJSONObject(executionContext.getClient());
        }
        return jsonObject;
    }
}

