/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import com.google.common.collect.Lists;
import io.jans.as.common.service.common.ApplicationFactory;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.model.auth.AuthenticationMode;
import io.jans.as.server.model.config.ConfigurationFactory;
import io.jans.as.server.service.ClientLastUpdateAtTimer;
import io.jans.as.server.service.KeyGeneratorTimer;
import io.jans.as.server.service.MetricService;
import io.jans.as.server.service.cdi.event.AuthConfigurationEvent;
import io.jans.as.server.service.cdi.event.ReloadAuthScript;
import io.jans.as.server.service.ciba.CibaRequestsProcessorJob;
import io.jans.as.server.service.cluster.ClusterNodeManager;
import io.jans.as.server.service.expiration.ExpirationNotificatorTimer;
import io.jans.as.server.service.external.ExternalAuthenticationService;
import io.jans.as.server.service.logger.LoggerService;
import io.jans.as.server.service.stat.StatService;
import io.jans.as.server.service.stat.StatTimer;
import io.jans.as.server.service.status.ldap.LdapStatusTimer;
import io.jans.config.GluuConfiguration;
import io.jans.config.IDPAuthConf;
import io.jans.exception.ConfigurationException;
import io.jans.model.AuthenticationScriptUsageType;
import io.jans.model.SimpleProperty;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.ldap.GluuLdapConfiguration;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.PersistenceEntryManagerFactory;
import io.jans.orm.exception.BasePersistenceException;
import io.jans.orm.ldap.impl.LdapEntryManagerFactory;
import io.jans.orm.model.PersistenceConfiguration;
import io.jans.orm.util.properties.FileConfiguration;
import io.jans.service.ApplicationConfigurationFactory;
import io.jans.service.EncryptionService;
import io.jans.service.PythonService;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.ApplicationInitialized;
import io.jans.service.cdi.event.ApplicationInitializedEvent;
import io.jans.service.cdi.event.LdapConfigurationReload;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.cdi.util.CdiUtil;
import io.jans.service.custom.lib.CustomLibrariesLoader;
import io.jans.service.custom.script.CustomScriptActivator;
import io.jans.service.custom.script.CustomScriptManager;
import io.jans.service.document.store.manager.DocumentStoreManager;
import io.jans.service.external.ExternalPersistenceExtensionService;
import io.jans.service.metric.inject.ReportMetric;
import io.jans.service.timer.QuartzSchedulerManager;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import io.jans.util.StringHelper;
import io.jans.util.security.SecurityProviderUtility;
import io.jans.util.security.StringEncrypter;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.ServletContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.weld.util.reflection.ParameterizedTypeImpl;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class AppInitializer {
    private static final int DEFAULT_INTERVAL = 30;
    private static final String DOCUMENT_STORE_MANAGER_JANS_AUTH_TYPE = "jans-auth";
    @Inject
    private Logger log;
    @Inject
    private BeanManager beanManager;
    @Inject
    private Event<String> event;
    @Inject
    private Event<ApplicationInitializedEvent> eventApplicationInitialized;
    @Inject
    private Event<TimerEvent> timerEvent;
    @Inject
    @Named(value="persistenceEntryManager")
    private Instance<PersistenceEntryManager> persistenceEntryManagerInstance;
    @Inject
    @Named(value="persistenceMetricEntryManager")
    @ReportMetric
    private Instance<PersistenceEntryManager> persistenceMetricEntryManagerInstance;
    @Inject
    @Named(value="persistenceAuthEntryManager")
    private Instance<List<PersistenceEntryManager>> persistenceAuthEntryManagerInstance;
    @Inject
    @Named(value="persistenceAuthConfig")
    private Instance<List<GluuLdapConfiguration>> persistenceAuthConfigInstance;
    @Inject
    private ApplicationFactory applicationFactory;
    @Inject
    private Instance<ApplicationConfigurationFactory> applicationConfigurationFactory;
    @Inject
    private Instance<AuthenticationMode> authenticationModeInstance;
    @Inject
    private Instance<EncryptionService> encryptionServiceInstance;
    @Inject
    private PythonService pythonService;
    @Inject
    private ClusterNodeManager clusterManager;
    @Inject
    private MetricService metricService;
    @Inject
    private CustomScriptManager customScriptManager;
    @Inject
    private Instance<CustomScriptActivator> customScriptActivatorInstance;
    @Inject
    private ExternalPersistenceExtensionService externalPersistenceExtensionService;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private ClientLastUpdateAtTimer clientLastUpdateAtTimer;
    @Inject
    private KeyGeneratorTimer keyGeneratorTimer;
    @Inject
    private StatTimer statTimer;
    @Inject
    private ExpirationNotificatorTimer expirationNotificatorTimer;
    @Inject
    private CustomLibrariesLoader customLibrariesLoader;
    @Inject
    private LdapStatusTimer ldapStatusTimer;
    @Inject
    private QuartzSchedulerManager quartzSchedulerManager;
    @Inject
    private LoggerService loggerService;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private CibaRequestsProcessorJob cibaRequestsProcessorJob;
    @Inject
    private StatService statService;
    @Inject
    private DocumentStoreManager documentStoreManager;
    private AtomicBoolean isActive;
    private long lastFinishedTime;
    private AuthenticationMode authenticationMode;
    private List<GluuLdapConfiguration> persistenceAuthConfigs;

    @PostConstruct
    public void createApplicationComponents() {
        try {
            SecurityProviderUtility.installBCProvider();
        }
        catch (ClassCastException ex) {
            this.log.error("Failed to install BC provider properly");
        }
    }

    public void applicationInitialized(@Observes @Initialized(value=ApplicationScoped.class) Object init) {
        this.log.debug("Initializing application services");
        this.configurationFactory.create();
        for (ApplicationConfigurationFactory configurationFactory : this.applicationConfigurationFactory) {
            configurationFactory.create();
        }
        PersistenceEntryManager localPersistenceEntryManager = (PersistenceEntryManager)this.persistenceEntryManagerInstance.get();
        this.log.trace("Attempting to use {}: {}", (Object)"persistenceEntryManager", (Object)localPersistenceEntryManager.getOperationService());
        GluuConfiguration newConfiguration = this.loadConfiguration(localPersistenceEntryManager, "jansDbAuth", "jansAuthMode");
        this.persistenceAuthConfigs = this.loadPersistenceAuthConfigs(newConfiguration);
        this.pythonService.initPythonInterpreter(this.configurationFactory.getBaseConfiguration().getString("pythonModulesDir", null));
        ArrayList supportedCustomScriptTypes = Lists.newArrayList((Object[])CustomScriptType.values());
        supportedCustomScriptTypes.remove(CustomScriptType.LINK_INTERCEPTION);
        supportedCustomScriptTypes.remove(CustomScriptType.SCIM);
        supportedCustomScriptTypes.remove(CustomScriptType.IDP);
        supportedCustomScriptTypes.remove(CustomScriptType.CONFIG_API);
        supportedCustomScriptTypes.remove(CustomScriptType.FIDO2_EXTENSION);
        supportedCustomScriptTypes.remove(CustomScriptType.LOCK_EXTENSION);
        this.addPluginSupportedScripts(supportedCustomScriptTypes);
        this.statService.init();
        this.initSchedulerService();
        this.clusterManager.initTimer();
        this.metricService.initTimer();
        this.configurationFactory.initTimer();
        this.loggerService.initTimer(true);
        this.ldapStatusTimer.initTimer();
        this.clientLastUpdateAtTimer.initTimer();
        this.customScriptManager.initTimer((List)supportedCustomScriptTypes);
        this.keyGeneratorTimer.initTimer();
        this.statTimer.initTimer();
        this.expirationNotificatorTimer.initTimer();
        this.documentStoreManager.initTimer(Arrays.asList(DOCUMENT_STORE_MANAGER_JANS_AUTH_TYPE));
        this.initTimer();
        this.initCibaRequestsProcessor();
        this.setDefaultAuthenticationMethod(newConfiguration);
        this.eventApplicationInitialized.select(new Annotation[]{ApplicationInitialized.Literal.APPLICATION}).fire((Object)new ApplicationInitializedEvent());
    }

    private void addPluginSupportedScripts(List<CustomScriptType> supportedCustomScriptTypes) {
        for (CustomScriptActivator customScriptActivator : this.customScriptActivatorInstance) {
            List additionalActiveCustomScripts = customScriptActivator.getActiveCustomScripts();
            this.log.info("Addting plugin custom scripts: {}", (Object)additionalActiveCustomScripts);
            supportedCustomScriptTypes.addAll(additionalActiveCustomScripts);
        }
    }

    protected void initSchedulerService() {
        this.quartzSchedulerManager.start();
        String disableScheduler = System.getProperties().getProperty("gluu.disable.scheduler");
        if (Boolean.parseBoolean(disableScheduler)) {
            this.log.warn("Suspending Quartz Scheduler Service...");
            this.quartzSchedulerManager.standby();
        }
    }

    @Produces
    @ApplicationScoped
    public StringEncrypter getStringEncrypter() {
        String encodeSalt = this.configurationFactory.getCryptoConfigurationSalt();
        if (StringHelper.isEmpty((String)encodeSalt)) {
            throw new ConfigurationException("Encode salt isn't defined");
        }
        try {
            return StringEncrypter.instance((String)encodeSalt);
        }
        catch (StringEncrypter.EncryptionException ex) {
            throw new ConfigurationException("Failed to create StringEncrypter instance");
        }
    }

    public void initTimer() {
        this.isActive = new AtomicBoolean(false);
        this.setLastFinishedTime(System.currentTimeMillis());
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(60, 30), (Object)new AuthConfigurationEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void reloadConfigurationTimerEvent(@Observes @Scheduled AuthConfigurationEvent authConfigurationEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reloadConfiguration();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while reloading application configuration", ex);
        }
        finally {
            this.isActive.set(false);
            this.setLastFinishedTime(System.currentTimeMillis());
        }
    }

    private void reloadConfiguration() {
        PersistenceEntryManager localPersistenceEntryManager = (PersistenceEntryManager)this.persistenceEntryManagerInstance.get();
        this.log.trace("Attempting to use {}: {}", (Object)"persistenceEntryManager", (Object)localPersistenceEntryManager.getOperationService());
        GluuConfiguration newConfiguration = this.loadConfiguration(localPersistenceEntryManager, "jansDbAuth", "jansAuthMode");
        List<GluuLdapConfiguration> newPersistenceAuthConfigs = this.loadPersistenceAuthConfigs(newConfiguration);
        if (!this.persistenceAuthConfigs.equals(newPersistenceAuthConfigs)) {
            this.recreatePersistenceAuthEntryManagers(newPersistenceAuthConfigs);
            this.persistenceAuthConfigs = newPersistenceAuthConfigs;
            this.event.select(new Annotation[]{ReloadAuthScript.Literal.INSTANCE}).fire((Object)"CustomScriptModifiedInternlTypesEvent");
        }
        this.setDefaultAuthenticationMethod(newConfiguration);
    }

    public PersistenceEntryManager createPersistenceAuthEntryManager(GluuLdapConfiguration persistenceAuthConfig) {
        PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.applicationFactory.getPersistenceEntryManagerFactory(LdapEntryManagerFactory.class);
        Properties persistenceConnectionProperties = this.prepareAuthConnectionProperties(persistenceAuthConfig, persistenceEntryManagerFactory.getPersistenceType());
        PersistenceEntryManager persistenceAuthEntryManager = persistenceEntryManagerFactory.createEntryManager(persistenceConnectionProperties);
        this.log.debug("Created custom authentication PersistenceEntryManager: {}", (Object)persistenceAuthEntryManager);
        this.externalPersistenceExtensionService.executePersistenceExtensionAfterCreate(persistenceConnectionProperties, persistenceAuthEntryManager);
        return persistenceAuthEntryManager;
    }

    protected Properties preparePersistanceProperties() {
        PersistenceConfiguration persistenceConfiguration = this.configurationFactory.getPersistenceConfiguration();
        FileConfiguration persistenceConfig = persistenceConfiguration.getConfiguration();
        Properties connectionProperties = persistenceConfig.getProperties();
        EncryptionService securityService = (EncryptionService)this.encryptionServiceInstance.get();
        return securityService.decryptAllProperties(connectionProperties);
    }

    protected Properties prepareCustomPersistanceProperties(String configId) {
        Properties connectionProperties = this.preparePersistanceProperties();
        if (StringHelper.isNotEmpty((String)configId)) {
            connectionProperties = (Properties)connectionProperties.clone();
            String baseGroup = configId + ".";
            for (Object key : connectionProperties.keySet()) {
                String propertyName = (String)key;
                if (!propertyName.startsWith(baseGroup)) continue;
                propertyName = propertyName.substring(baseGroup.length());
                Object value = connectionProperties.get(key);
                connectionProperties.put(propertyName, value);
            }
        }
        return connectionProperties;
    }

    @Produces
    @ApplicationScoped
    @Named(value="persistenceEntryManager")
    public PersistenceEntryManager createPersistenceEntryManager() {
        Properties connectionProperties = this.preparePersistanceProperties();
        PersistenceEntryManager persistenceEntryManager = this.applicationFactory.getPersistenceEntryManagerFactory().createEntryManager(connectionProperties);
        this.log.info("Created {}: {} with operation service: {}", new Object[]{"persistenceEntryManager", persistenceEntryManager, persistenceEntryManager.getOperationService()});
        this.externalPersistenceExtensionService.executePersistenceExtensionAfterCreate(connectionProperties, persistenceEntryManager);
        return persistenceEntryManager;
    }

    @Produces
    @ApplicationScoped
    @Named(value="persistenceMetricEntryManager")
    @ReportMetric
    public PersistenceEntryManager createMetricPersistenceEntryManager() {
        Properties connectionProperties = this.prepareCustomPersistanceProperties("metric");
        PersistenceEntryManager persistenceEntryManager = this.applicationFactory.getPersistenceEntryManagerFactory().createEntryManager(connectionProperties);
        this.log.info("Created {}: {} with operation service: {}", new Object[]{"persistenceMetricEntryManager", persistenceEntryManager, persistenceEntryManager.getOperationService()});
        this.externalPersistenceExtensionService.executePersistenceExtensionAfterCreate(connectionProperties, persistenceEntryManager);
        return persistenceEntryManager;
    }

    @Produces
    @ApplicationScoped
    @Named(value="persistenceAuthConfig")
    public List<GluuLdapConfiguration> createPersistenceAuthConfigs() {
        return this.persistenceAuthConfigs;
    }

    @Produces
    @ApplicationScoped
    @Named(value="persistenceAuthEntryManager")
    public List<PersistenceEntryManager> createPersistenceAuthEntryManager() {
        ArrayList<PersistenceEntryManager> persistenceAuthEntryManagers = new ArrayList<PersistenceEntryManager>();
        if (this.persistenceAuthConfigs.size() == 0) {
            return persistenceAuthEntryManagers;
        }
        PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.applicationFactory.getPersistenceEntryManagerFactory(LdapEntryManagerFactory.class);
        List<Properties> persistenceAuthProperties = this.prepareAuthConnectionProperties(this.persistenceAuthConfigs, persistenceEntryManagerFactory.getPersistenceType());
        this.log.trace("Attempting to create LDAP auth PersistenceEntryManager with properties: {}", persistenceAuthProperties);
        for (int i = 0; i < persistenceAuthProperties.size(); ++i) {
            PersistenceEntryManager persistenceAuthEntryManager = persistenceEntryManagerFactory.createEntryManager(persistenceAuthProperties.get(i));
            this.log.debug("Created {}#{}: {}", new Object[]{"persistenceAuthEntryManager", i, persistenceAuthEntryManager});
            persistenceAuthEntryManagers.add(persistenceAuthEntryManager);
            this.externalPersistenceExtensionService.executePersistenceExtensionAfterCreate(persistenceAuthProperties.get(i), persistenceAuthEntryManager);
        }
        return persistenceAuthEntryManagers;
    }

    public void recreatePersistenceEntryManager(@Observes @LdapConfigurationReload String event) {
        this.recreatePersistanceEntryManagerImpl(this.persistenceEntryManagerInstance, "persistenceEntryManager", new Annotation[0]);
        this.recreatePersistanceEntryManagerImpl(this.persistenceEntryManagerInstance, "persistenceMetricEntryManager", new Annotation[]{ReportMetric.Literal.INSTANCE});
    }

    protected void recreatePersistanceEntryManagerImpl(Instance<PersistenceEntryManager> instance, String persistenceEntryManagerName, Annotation ... qualifiers) {
        PersistenceEntryManager oldPersistenceEntryManager = (PersistenceEntryManager)CdiUtil.getContextBean((BeanManager)this.beanManager, PersistenceEntryManager.class, (String)persistenceEntryManagerName, (Annotation[])new Annotation[0]);
        this.closePersistenceEntryManager(oldPersistenceEntryManager, persistenceEntryManagerName);
        PersistenceEntryManager persistenceEntryManager = (PersistenceEntryManager)instance.get();
        instance.destroy((Object)persistenceEntryManager);
        this.log.info("Recreated instance {}: {} with operation service: {}", new Object[]{persistenceEntryManagerName, persistenceEntryManager, persistenceEntryManager.getOperationService()});
    }

    private void closePersistenceEntryManager(PersistenceEntryManager oldPersistenceEntryManager, String persistenceEntryManagerName) {
        if (oldPersistenceEntryManager != null && oldPersistenceEntryManager.getOperationService() != null) {
            this.log.debug("Attempting to destroy {}:{} with operation service: {}", new Object[]{persistenceEntryManagerName, oldPersistenceEntryManager, oldPersistenceEntryManager.getOperationService()});
            oldPersistenceEntryManager.destroy();
            this.log.debug("Destroyed {}:{} with operation service: {}", new Object[]{persistenceEntryManagerName, oldPersistenceEntryManager, oldPersistenceEntryManager.getOperationService()});
            this.externalPersistenceExtensionService.executePersistenceExtensionAfterDestroy(oldPersistenceEntryManager);
        }
    }

    public void closePersistenceEntryManagers(List<PersistenceEntryManager> oldPersistenceEntryManagers) {
        if (oldPersistenceEntryManagers == null) {
            return;
        }
        for (PersistenceEntryManager oldPersistenceEntryManager : oldPersistenceEntryManagers) {
            this.log.debug("Attempting to destroy {}: {}", (Object)"persistenceAuthEntryManager", (Object)oldPersistenceEntryManager);
            oldPersistenceEntryManager.destroy();
            this.log.debug("Destroyed {}: {}", (Object)"persistenceAuthEntryManager", (Object)oldPersistenceEntryManager);
            this.externalPersistenceExtensionService.executePersistenceExtensionAfterDestroy(oldPersistenceEntryManager);
        }
    }

    public void recreatePersistenceAuthEntryManagers(List<GluuLdapConfiguration> newPersistenceAuthConfigs) {
        List oldPersistenceAuthEntryManagers = (List)CdiUtil.getContextBean((BeanManager)this.beanManager, (Type)new ParameterizedTypeImpl(List.class, new Type[]{PersistenceEntryManager.class}), (String)"persistenceAuthEntryManager", (Annotation[])new Annotation[0]);
        this.persistenceAuthConfigs = newPersistenceAuthConfigs;
        this.closePersistenceEntryManagers(oldPersistenceAuthEntryManagers);
        for (PersistenceEntryManager oldPersistenceAuthEntryManager : oldPersistenceAuthEntryManagers) {
            this.log.debug("Attempting to destroy {}: {}", (Object)"persistenceAuthEntryManager", (Object)oldPersistenceAuthEntryManager);
            oldPersistenceAuthEntryManager.destroy();
            this.log.debug("Destroyed {}: {}", (Object)"persistenceAuthEntryManager", (Object)oldPersistenceAuthEntryManager);
            this.externalPersistenceExtensionService.executePersistenceExtensionAfterDestroy(oldPersistenceAuthEntryManager);
        }
        List persistenceAuthEntryManagers = (List)this.persistenceAuthEntryManagerInstance.get();
        this.persistenceAuthEntryManagerInstance.destroy((Object)persistenceAuthEntryManagers);
        this.log.info("Recreated instance {}: {}", (Object)"persistenceAuthEntryManager", (Object)persistenceAuthEntryManagers);
        List oldPersistenceAuthConfigs = (List)this.persistenceAuthConfigInstance.get();
        this.persistenceAuthConfigInstance.destroy((Object)oldPersistenceAuthConfigs);
    }

    private List<Properties> prepareAuthConnectionProperties(List<GluuLdapConfiguration> persistenceAuthConfigs, String persistenceType) {
        ArrayList<Properties> result = new ArrayList<Properties>();
        for (GluuLdapConfiguration persistenceAuthConfig : persistenceAuthConfigs) {
            Properties decrypytedConnectionProperties = this.prepareAuthConnectionProperties(persistenceAuthConfig, persistenceType);
            result.add(decrypytedConnectionProperties);
        }
        return result;
    }

    private Properties prepareAuthConnectionProperties(GluuLdapConfiguration persistenceAuthConfig, String persistenceType) {
        String prefix = persistenceType + "#";
        FileConfiguration configuration = this.configurationFactory.getPersistenceConfiguration().getConfiguration();
        Properties properties = new Properties();
        for (Map.Entry<Object, Object> propItem : configuration.getProperties().entrySet()) {
            String key = (String)propItem.getKey();
            if (!key.startsWith(persistenceType)) continue;
            properties.put(key, propItem.getValue());
        }
        if (persistenceAuthConfig != null) {
            properties.setProperty(prefix + "servers", this.buildServersString(persistenceAuthConfig.getServers()));
            String bindDn = persistenceAuthConfig.getBindDN();
            if (StringHelper.isNotEmpty((String)bindDn)) {
                properties.setProperty(prefix + "bindDN", bindDn);
                properties.setProperty(prefix + "bindPassword", persistenceAuthConfig.getBindPassword());
            }
            properties.setProperty(prefix + "useSSL", Boolean.toString(persistenceAuthConfig.isUseSSL()));
            properties.setProperty(prefix + "maxconnections", Integer.toString(persistenceAuthConfig.getMaxConnections()));
            properties.remove(prefix + "ssl.trustStoreFile");
            properties.remove(prefix + "ssl.trustStorePin");
            properties.remove(prefix + "ssl.trustStoreFormat");
        }
        EncryptionService securityService = (EncryptionService)this.encryptionServiceInstance.get();
        return securityService.decryptAllProperties(properties);
    }

    private String buildServersString(List<?> servers) {
        StringBuilder sb = new StringBuilder();
        if (servers == null) {
            return sb.toString();
        }
        boolean first = true;
        for (Object server : servers) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            if (server instanceof SimpleProperty) {
                sb.append(((SimpleProperty)server).getValue());
                continue;
            }
            sb.append(server);
        }
        return sb.toString();
    }

    private void setDefaultAuthenticationMethod(GluuConfiguration configuration) {
        String actualAuthMethod;
        String currentAuthMethod = null;
        if (this.authenticationMode != null) {
            currentAuthMethod = this.authenticationMode.getName();
        }
        if (!StringHelper.equals((String)currentAuthMethod, (String)(actualAuthMethod = this.getActualDefaultAuthenticationMethod(configuration)))) {
            this.authenticationMode = null;
            if (actualAuthMethod != null) {
                this.authenticationMode = new AuthenticationMode(actualAuthMethod);
            }
            this.authenticationModeInstance.destroy((Object)((AuthenticationMode)this.authenticationModeInstance.get()));
        }
    }

    private String getActualDefaultAuthenticationMethod(GluuConfiguration configuration) {
        if (configuration != null && configuration.getAuthenticationMode() != null) {
            return configuration.getAuthenticationMode();
        }
        CustomScriptConfiguration defaultExternalAuthenticator = this.externalAuthenticationService.getDefaultExternalAuthenticator(AuthenticationScriptUsageType.INTERACTIVE);
        if (defaultExternalAuthenticator != null) {
            return defaultExternalAuthenticator.getName();
        }
        return "simple_password_auth";
    }

    @Produces
    @ApplicationScoped
    public AuthenticationMode getDefaultAuthenticationMode() {
        return this.authenticationMode;
    }

    private GluuConfiguration loadConfiguration(PersistenceEntryManager localPersistenceEntryManager, String ... persistenceReturnAttributes) {
        String configurationDn = this.configurationFactory.getBaseDn().getConfiguration();
        if (StringHelper.isEmpty((String)configurationDn)) {
            return null;
        }
        GluuConfiguration configuration = null;
        try {
            configuration = (GluuConfiguration)localPersistenceEntryManager.find((Object)configurationDn, GluuConfiguration.class, persistenceReturnAttributes);
        }
        catch (BasePersistenceException ex) {
            this.log.error("Failed to load global configuration entry from DB", (Throwable)ex);
            return null;
        }
        return configuration;
    }

    private List<GluuLdapConfiguration> loadPersistenceAuthConfigs(GluuConfiguration configuration) {
        ArrayList<GluuLdapConfiguration> config = new ArrayList<GluuLdapConfiguration>();
        List<IDPAuthConf> persistenceIdpAuthConfigs = this.loadLdapIdpAuthConfigs(configuration);
        if (persistenceIdpAuthConfigs == null) {
            return config;
        }
        for (IDPAuthConf persistenceIdpAuthConfig : persistenceIdpAuthConfigs) {
            GluuLdapConfiguration persistenceAuthConfig = persistenceIdpAuthConfig.asLdapConfiguration();
            if (persistenceAuthConfig == null || !persistenceAuthConfig.isEnabled()) continue;
            config.add(persistenceAuthConfig);
        }
        return config;
    }

    private List<IDPAuthConf> loadLdapIdpAuthConfigs(GluuConfiguration configuration) {
        if (configuration == null || configuration.getIdpAuthn() == null) {
            return null;
        }
        ArrayList<IDPAuthConf> configurations = new ArrayList<IDPAuthConf>();
        for (IDPAuthConf authConf : configuration.getIdpAuthn()) {
            if (!authConf.getType().equalsIgnoreCase("ldap") && !authConf.getType().equalsIgnoreCase("auth")) continue;
            configurations.add(authConf);
        }
        return configurations;
    }

    public void destroy(@Observes @BeforeDestroyed(value=ApplicationScoped.class) ServletContext init) {
        this.log.info("Stopping services and closing DB connections at server shutdown...");
        this.log.debug("Checking who intiated destroy", new Throwable());
        this.metricService.close();
        PersistenceEntryManager persistenceEntryManager = (PersistenceEntryManager)this.persistenceEntryManagerInstance.get();
        this.closePersistenceEntryManager(persistenceEntryManager, "persistenceEntryManager");
        List persistenceAuthEntryManagers = (List)this.persistenceAuthEntryManagerInstance.get();
        this.closePersistenceEntryManagers(persistenceAuthEntryManagers);
    }

    public long getLastFinishedTime() {
        return this.lastFinishedTime;
    }

    public void setLastFinishedTime(long lastFinishedTime) {
        this.lastFinishedTime = lastFinishedTime;
    }

    private void initCibaRequestsProcessor() {
        Set featureFlags = FeatureFlagType.from((AppConfiguration)this.appConfiguration);
        if ((featureFlags.isEmpty() || featureFlags.contains(FeatureFlagType.CIBA)) && this.appConfiguration.getBackchannelRequestsProcessorJobIntervalSec() > 0) {
            if (this.cibaRequestsProcessorJob != null) {
                this.cibaRequestsProcessorJob.initTimer();
            }
        } else {
            this.log.warn("Ciba requests processor hasn't been started because the interval is not valid to run or this is disabled, value: {}", (Object)this.appConfiguration.getBackchannelRequestsProcessorJobIntervalSec());
        }
    }
}

