/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.configuration.AuthenticationProtectionConfiguration;
import io.jans.service.cdi.event.ConfigurationUpdate;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;

@ApplicationScoped
@Named
public class AuthenticationProtectionService
extends io.jans.service.security.protect.AuthenticationProtectionService {
    private static final int DEFAULT_ATTEMPT_EXPIRATION = 15;
    private static final int DEFAULT_MAXIMUM_ALLOWED_ATTEMPTS_WITHOUT_DELAY = 4;
    private static final int DEFAULT_DELAY_TIME = 2;
    private static final String DEFAULT_KEY_PREFIX = "user";
    @Inject
    private AppConfiguration appConfiguration;

    protected void init() {
        this.updateConfiguration(this.appConfiguration);
    }

    public void updateConfiguration(@Observes @ConfigurationUpdate AppConfiguration appConfiguration) {
        AuthenticationProtectionConfiguration authenticationProtectionConfiguration = appConfiguration.getAuthenticationProtectionConfiguration();
        if (authenticationProtectionConfiguration == null) {
            this.attemptExpiration = 15;
            this.maximumAllowedAttemptsWithoutDelay = 4;
            this.delayTime = 2;
        } else {
            this.attemptExpiration = authenticationProtectionConfiguration.getAttemptExpiration();
            this.maximumAllowedAttemptsWithoutDelay = authenticationProtectionConfiguration.getMaximumAllowedAttemptsWithoutDelay();
            this.delayTime = authenticationProtectionConfiguration.getDelayTime();
        }
    }

    protected String getKeyPrefix() {
        return DEFAULT_KEY_PREFIX;
    }

    public boolean isEnabled() {
        AuthenticationProtectionConfiguration authenticationProtectionConfiguration = this.appConfiguration.getAuthenticationProtectionConfiguration();
        return authenticationProtectionConfiguration != null && authenticationProtectionConfiguration.getBruteForceProtectionEnabled() != false;
    }
}

