/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.common.model.registration.Client;
import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.persistence.model.ClientAuthorization;
import io.jans.as.server.service.ClientService;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.orm.model.base.SimpleBranch;
import io.jans.util.StringHelper;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Named
public class ClientAuthorizationsService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private ClientService clientService;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private AppConfiguration appConfiguration;

    public void addBranch() {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("authorizations");
        branch.setDn(this.createDn(null));
        this.ldapEntryManager.persist((Object)branch);
    }

    public boolean containsBranch() {
        return this.ldapEntryManager.contains(this.createDn(null), SimpleBranch.class);
    }

    public void prepareBranch() {
        String baseDn = this.createDn(null);
        if (!this.ldapEntryManager.hasBranchesSupport(baseDn)) {
            return;
        }
        if (!this.containsBranch()) {
            this.addBranch();
        }
    }

    public ClientAuthorization find(String userInum, String clientId) {
        this.prepareBranch();
        String id = ClientAuthorizationsService.createId(userInum, clientId);
        try {
            return (ClientAuthorization)this.ldapEntryManager.find(ClientAuthorization.class, (Object)this.createDn(id));
        }
        catch (EntryPersistenceException e) {
            this.log.trace("Unable to find client persistence for {}", (Object)id);
            return null;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void clearAuthorizations(ClientAuthorization clientAuthorization, boolean persistInPersistence) {
        if (clientAuthorization == null) {
            return;
        }
        if (persistInPersistence) {
            this.ldapEntryManager.remove((Object)clientAuthorization);
        }
    }

    public void add(String userInum, String clientId, Set<String> scopes, String authorizationDetails) {
        this.log.trace("Attempting to add client authorization, scopes: {}, clientId: {}, userInum: {}, authorizationDetails: {}", new Object[]{scopes, clientId, userInum, authorizationDetails});
        Client client = this.clientService.getClient(clientId);
        this.prepareBranch();
        ClientAuthorization clientAuthorization = this.find(userInum, clientId);
        if (clientAuthorization == null) {
            String id = ClientAuthorizationsService.createId(userInum, clientId);
            clientAuthorization = new ClientAuthorization();
            clientAuthorization.setId(id);
            clientAuthorization.setDn(this.createDn(id));
            clientAuthorization.setClientId(clientId);
            clientAuthorization.setUserId(userInum);
            clientAuthorization.setScopes(scopes.toArray(new String[scopes.size()]));
            clientAuthorization.getAttributes().setAuthorizationDetails(authorizationDetails);
            clientAuthorization.setDeletable(client.getAttributes().getKeepClientAuthorizationAfterExpiration() == false);
            clientAuthorization.setExpirationDate(client.getExpirationDate());
            clientAuthorization.setTtl(Integer.valueOf(this.appConfiguration.getDynamicRegistrationExpirationTime()));
            this.ldapEntryManager.persist((Object)clientAuthorization);
        } else if (ArrayUtils.isNotEmpty((Object[])clientAuthorization.getScopes())) {
            HashSet<String> set = new HashSet<String>(scopes);
            set.addAll(Arrays.asList(clientAuthorization.getScopes()));
            boolean changed = false;
            if (set.size() != clientAuthorization.getScopes().length) {
                clientAuthorization.setScopes(set.toArray(new String[set.size()]));
                changed = true;
            }
            if (StringUtils.isNotBlank((CharSequence)authorizationDetails)) {
                if (StringUtils.isBlank((CharSequence)clientAuthorization.getAttributes().getAuthorizationDetails())) {
                    clientAuthorization.getAttributes().setAuthorizationDetails(authorizationDetails);
                    changed = true;
                } else {
                    boolean isAuthorizationDetailsChanged;
                    boolean bl = isAuthorizationDetailsChanged = !AuthzDetails.similar((String)authorizationDetails, (String)clientAuthorization.getAttributes().getAuthorizationDetails());
                    if (isAuthorizationDetailsChanged) {
                        clientAuthorization.getAttributes().setAuthorizationDetails(AuthzDetails.simpleMerge((String)authorizationDetails, (String)clientAuthorization.getAttributes().getAuthorizationDetails()));
                        changed = true;
                    }
                }
            }
            if (changed) {
                this.ldapEntryManager.merge((Object)clientAuthorization);
            }
        }
    }

    public static String createId(String userId, String clientId) {
        return userId + "_" + clientId;
    }

    public String createDn(String jsId) {
        String baseDn = this.staticConfiguration.getBaseDn().getAuthorizations();
        if (StringHelper.isEmpty((String)jsId)) {
            return baseDn;
        }
        return String.format("jansId=%s,%s", jsId, baseDn);
    }
}

