/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.model.common.WebKeyStorage;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.CryptoProviderFactory;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class CryptoProviderProviderFactory {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;

    @Produces
    @ApplicationScoped
    public AbstractCryptoProvider getCryptoProvider() throws Exception {
        this.log.debug("Started to create crypto provider");
        WebKeyStorage webKeyStorage = this.appConfiguration.getWebKeysStorage();
        if (webKeyStorage == null) {
            throw new RuntimeException("Failed to initialize cryptoProvider, cryptoProviderType is not specified!");
        }
        AbstractCryptoProvider cryptoProvider = CryptoProviderFactory.getCryptoProvider((AppConfiguration)this.appConfiguration);
        if (cryptoProvider == null) {
            throw new RuntimeException("Failed to initialize cryptoProvider, cryptoProviderType is unsupported: " + webKeyStorage);
        }
        return cryptoProvider;
    }
}

