/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import io.jans.as.common.util.RedirectUri;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.server.util.RedirectUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectUriResponse {
    private static final Logger log = LoggerFactory.getLogger(RedirectUriResponse.class);
    private final RedirectUri redirectUri;
    private String state;
    private final HttpServletRequest httpRequest;
    private final ErrorResponseFactory errorFactory;
    private boolean fapiCompatible = false;

    public RedirectUriResponse(RedirectUri redirectUri, String state, HttpServletRequest httpRequest, ErrorResponseFactory errorFactory) {
        this.redirectUri = redirectUri;
        this.state = state;
        this.httpRequest = httpRequest;
        this.errorFactory = errorFactory;
    }

    public WebApplicationException createWebException(IErrorType errorType) {
        return this.createWebException(errorType, null);
    }

    public WebApplicationException createWebException(IErrorType errorType, String reason) {
        if (this.fapiCompatible) {
            log.trace("Reason: {}", (Object)reason);
            reason = null;
        }
        this.redirectUri.parseQueryString(this.errorFactory.getErrorAsQueryString(errorType, this.state, reason));
        return new WebApplicationException(RedirectUtil.getRedirectResponseBuilder(this.redirectUri, this.httpRequest).build());
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Response.ResponseBuilder createErrorBuilder(IErrorType errorType) {
        this.redirectUri.parseQueryString(this.errorFactory.getErrorAsQueryString(errorType, this.state));
        return RedirectUtil.getRedirectResponseBuilder(this.redirectUri, this.httpRequest);
    }

    public RedirectUri getRedirectUri() {
        return this.redirectUri;
    }

    public boolean isFapiCompatible() {
        return this.fapiCompatible;
    }

    public void setFapiCompatible(boolean fapiCompatible) {
        this.fapiCompatible = fapiCompatible;
    }
}

