/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.ciba;

import io.jans.as.model.ciba.PushErrorResponseType;
import io.jans.as.model.common.BackchannelTokenDeliveryMode;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.ciba.CIBAPingCallbackService;
import io.jans.as.server.ciba.CIBAPushErrorService;
import io.jans.as.server.model.common.CibaRequestCacheControl;
import io.jans.as.server.model.common.CibaRequestStatus;
import io.jans.as.server.model.ldap.CIBARequest;
import io.jans.as.server.service.ciba.CibaRequestService;
import io.jans.as.server.util.ServerUtil;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.CibaRequestsProcessorEvent;
import io.jans.service.cdi.event.Scheduled;
import io.jans.service.timer.event.TimerEvent;
import io.jans.service.timer.schedule.TimerSchedule;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class CibaRequestsProcessorJob {
    public static final int CHUNK_SIZE = 500;
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private Event<TimerEvent> processorEvent;
    @Inject
    private CIBAPushErrorService cibaPushErrorService;
    @Inject
    private CIBAPingCallbackService cibaPingCallbackService;
    @Inject
    private CibaRequestService cibaRequestService;
    private long lastFinishedTime;
    private AtomicBoolean isActive;
    private ExecutorService executorService;

    public void initTimer() {
        this.log.debug("Initializing CIBA requests processor");
        this.isActive = new AtomicBoolean(false);
        int intervalSec = this.appConfiguration.getBackchannelRequestsProcessorJobIntervalSec();
        this.processorEvent.fire((Object)new TimerEvent(new TimerSchedule(intervalSec, intervalSec), (Object)new CibaRequestsProcessorEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
        this.lastFinishedTime = System.currentTimeMillis();
        this.executorService = Executors.newCachedThreadPool(ServerUtil.daemonThreadFactory());
    }

    @Asynchronous
    public void process(@Observes @Scheduled CibaRequestsProcessorEvent cibaRequestsProcessorEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            if (this.jobIsFree()) {
                this.processImpl();
                this.lastFinishedTime = System.currentTimeMillis();
            } else {
                this.log.trace("Starting conditions aren't reached for CIBA requestes processor");
            }
        }
        finally {
            this.isActive.set(false);
        }
    }

    private boolean jobIsFree() {
        int interval = this.appConfiguration.getBackchannelRequestsProcessorJobIntervalSec();
        if (interval < 0) {
            this.log.info("CIBA Requests processor timer is disabled.");
            this.log.warn("CIBA Requests processor timer Interval (cleanServiceInterval in oxauth configuration) is negative which turns OFF internal clean up by the server. Please set it to positive value if you wish internal CIBA Requests processor up timer run.");
            return false;
        }
        long timeDiffrence = System.currentTimeMillis() - this.lastFinishedTime;
        return timeDiffrence >= (long)interval * 1000L;
    }

    public void processImpl() {
        try {
            int chunkSize = this.appConfiguration.getBackchannelRequestsProcessorJobChunkSize() <= 0 ? 500 : this.appConfiguration.getBackchannelRequestsProcessorJobChunkSize();
            List<CIBARequest> expiredRequests = this.cibaRequestService.loadExpiredByStatus(CibaRequestStatus.PENDING, chunkSize);
            expiredRequests.forEach(cibaRequest -> this.cibaRequestService.updateStatus((CIBARequest)cibaRequest, CibaRequestStatus.IN_PROCESS));
            for (CIBARequest expiredRequest : expiredRequests) {
                CibaRequestCacheControl cibaRequest2 = this.cibaRequestService.getCibaRequest(expiredRequest.getAuthReqId());
                if (cibaRequest2 != null) {
                    this.executorService.execute(() -> this.processExpiredRequest(cibaRequest2, expiredRequest.getAuthReqId()));
                }
                this.cibaRequestService.removeCibaRequest(expiredRequest);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to process CIBA request from cache.", (Throwable)e);
        }
    }

    private void processExpiredRequest(CibaRequestCacheControl cibaRequest, String authReqId) {
        if (cibaRequest.getStatus() != CibaRequestStatus.PENDING && cibaRequest.getStatus() != CibaRequestStatus.EXPIRED) {
            return;
        }
        this.log.info("Authentication request id {} has expired", (Object)authReqId);
        this.cibaRequestService.removeCibaCacheRequest(cibaRequest.cacheKey());
        if (cibaRequest.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.PUSH) {
            this.cibaPushErrorService.pushError(cibaRequest.getAuthReqId(), cibaRequest.getClient().getBackchannelClientNotificationEndpoint(), cibaRequest.getClientNotificationToken(), PushErrorResponseType.EXPIRED_TOKEN, "Request has expired and there was no answer from the end user.");
        } else if (cibaRequest.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.PING) {
            this.cibaPingCallbackService.pingCallback(cibaRequest.getAuthReqId(), cibaRequest.getClient().getBackchannelClientNotificationEndpoint(), cibaRequest.getClientNotificationToken());
        }
    }
}

