/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.date;

import io.jans.as.model.common.CallerType;
import io.jans.as.model.configuration.AppConfiguration;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class DateFormatterService {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;

    public Serializable formatClaim(Date date, CallerType callerType) {
        return this.formatClaim(date, callerType.name().toLowerCase());
    }

    public Serializable formatClaim(Date date, String patternKey) {
        Map formatterMap = this.appConfiguration.getDateFormatterPatterns();
        if (formatterMap.isEmpty()) {
            return this.formatClaimFallback(date);
        }
        String explicitFormatter = (String)formatterMap.get(patternKey);
        if (StringUtils.isNotBlank((CharSequence)explicitFormatter)) {
            return new SimpleDateFormat(explicitFormatter).format(date);
        }
        String commonFormatter = (String)formatterMap.get(CallerType.COMMON.name().toLowerCase());
        if (StringUtils.isNotBlank((CharSequence)commonFormatter)) {
            return new SimpleDateFormat(commonFormatter).format(date);
        }
        return this.formatClaimFallback(date);
    }

    public Serializable formatClaimFallback(Date date) {
        return Long.valueOf(date.getTime() / 1000L);
    }
}

