/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.service.external.context.ExternalUpdateTokenContext;
import io.jans.model.authzen.AccessEvaluationRequest;
import io.jans.model.authzen.AccessEvaluationResponse;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.authzen.AccessEvaluationType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@ApplicationScoped
public class ExternalAccessEvaluationService
extends ExternalScriptService {
    @Inject
    private transient AppConfiguration appConfiguration;

    public ExternalAccessEvaluationService() {
        super(CustomScriptType.ACCESS_EVALUATION);
    }

    public AccessEvaluationResponse externalEvaluate(AccessEvaluationRequest request, ExecutionContext context) {
        CustomScriptConfiguration script = this.identifyScript();
        if (script == null) {
            this.log.debug("Failed to identify script by resource type {}", (Object)request.getResource().getType());
            return AccessEvaluationResponse.FALSE;
        }
        context.setScript(script);
        try {
            this.log.trace("Executing 'externalEvaluate' method, script name: {}, request: {}", (Object)script.getName(), (Object)request);
            ExternalUpdateTokenContext scriptContext = ExternalUpdateTokenContext.of(context);
            AccessEvaluationType evaluationType = (AccessEvaluationType)script.getExternalType();
            AccessEvaluationResponse result = evaluationType.evaluate(request, (Object)scriptContext);
            this.log.trace("Finished 'externalEvaluate' method, script name: {}, result: {} for request: {}, hasWebApplicationException {}", new Object[]{script.getName(), result, request, scriptContext.getWebApplicationException() != null});
            scriptContext.throwWebApplicationExceptionIfSet();
            return result;
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.saveScriptError(script.getCustomScript(), e);
            return AccessEvaluationResponse.FALSE;
        }
    }

    private CustomScriptConfiguration identifyScript() {
        CustomScriptConfiguration script;
        String scriptName = this.appConfiguration.getAccessEvaluationScriptName();
        CustomScriptConfiguration customScriptConfiguration = script = StringUtils.isNotBlank((CharSequence)scriptName) ? this.getCustomScriptConfigurationByName(scriptName) : null;
        if (script == null) {
            this.log.trace("Unable to find access_evaluation script by configuration property 'accessEvaluationScriptName' {}", (Object)scriptName);
            List scripts = this.getCustomScriptConfigurations();
            if (scripts != null && !scripts.isEmpty()) {
                this.log.trace("Use first access_evaluation script in database because unable to find script specified by 'accessEvaluationScriptName': {}", (Object)scriptName);
                script = (CustomScriptConfiguration)scripts.get(0);
            }
        }
        this.log.debug("Access evaluatoin with script {}, id {}", (Object)(script != null ? script.getName() : ""), (Object)(script != null ? script.getInum() : ""));
        return script;
    }
}

