/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.common.model.session.AuthorizationChallengeSession;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.server.authorize.ws.rs.AuthzRequest;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.service.external.context.ExternalScriptContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.authzchallenge.AuthorizationChallengeType;
import io.jans.orm.PersistenceEntryManager;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

@ApplicationScoped
public class ExternalAuthorizationChallengeService
extends ExternalScriptService {
    @Inject
    private transient AppConfiguration appConfiguration;
    @Inject
    private transient ErrorResponseFactory errorResponseFactory;
    @Inject
    private transient PersistenceEntryManager persistenceEntryManager;

    public ExternalAuthorizationChallengeService() {
        super(CustomScriptType.AUTHORIZATION_CHALLENGE);
    }

    public Map<String, String> getAuthenticationMethodClaims(ExecutionContext executionContext) {
        List<String> acrValues = executionContext.getAuthzRequest().getAcrValuesList();
        CustomScriptConfiguration script = this.identifyScript(acrValues);
        if (script == null) {
            String msg = String.format("Unable to identify script by acr_values %s.", acrValues);
            this.log.debug(msg);
            return new HashMap<String, String>();
        }
        this.log.trace("Executing python 'getAuthenticationMethodClaims' method, script name: {}, clientId: {}", (Object)script.getName(), (Object)executionContext.getAuthzRequest().getClientId());
        executionContext.setScript(script);
        HashMap<String, String> result = new HashMap();
        try {
            AuthorizationChallengeType authorizationChallengeType = (AuthorizationChallengeType)script.getExternalType();
            ExternalScriptContext scriptContext = new ExternalScriptContext(executionContext);
            result = authorizationChallengeType.getAuthenticationMethodClaims((Object)scriptContext);
            scriptContext.throwWebApplicationExceptionIfSet();
        }
        catch (WebApplicationException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("WebApplicationException from script", (Throwable)e);
            }
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
        }
        this.log.trace("Finished 'getAuthenticationMethodClaims' method, script name: {}, clientId: {}, result: {}", new Object[]{script.getName(), executionContext.getAuthzRequest().getClientId(), result});
        return result;
    }

    public boolean externalAuthorize(ExecutionContext executionContext) {
        List<String> acrValues = executionContext.getAuthzRequest().getAcrValuesList();
        CustomScriptConfiguration script = this.identifyScript(acrValues);
        if (script == null) {
            String msg = String.format("Unable to identify script by acr_values %s.", acrValues);
            this.log.debug(msg);
            throw new WebApplicationException(this.errorResponseFactory.newErrorResponse(Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, executionContext.getAuthzRequest().getState(), msg)).build());
        }
        this.log.trace("Executing python 'authorize' method, script name: {}, clientId: {}, scope: {}, authorizationChallengeSession: {}", new Object[]{script.getName(), executionContext.getAuthzRequest().getClientId(), executionContext.getAuthzRequest().getScope(), executionContext.getAuthzRequest().getAuthorizationChallengeSession()});
        executionContext.setScript(script);
        boolean result = false;
        try {
            AuthorizationChallengeType authorizationChallengeType = (AuthorizationChallengeType)script.getExternalType();
            ExternalScriptContext scriptContext = new ExternalScriptContext(executionContext);
            result = authorizationChallengeType.authorize((Object)scriptContext);
            this.saveRequestParametersInSession(scriptContext);
            scriptContext.throwWebApplicationExceptionIfSet();
        }
        catch (WebApplicationException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("WebApplicationException from script", (Throwable)e);
            }
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            throw new WebApplicationException(this.errorResponseFactory.newErrorResponse(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, executionContext.getAuthzRequest().getState(), "Unable to run authorization challenge script.")).build());
        }
        this.log.trace("Finished 'authorize' method, script name: {}, clientId: {}, result: {}", new Object[]{script.getName(), executionContext.getAuthzRequest().getClientId(), result});
        return result;
    }

    private void saveRequestParametersInSession(ExternalScriptContext scriptContext) {
        AuthzRequest authzRequest = scriptContext.getAuthzRequest();
        AuthorizationChallengeSession session = authzRequest.getAuthorizationChallengeSessionObject();
        if (session == null) {
            this.log.trace("Authorization challenge session is not found.");
            return;
        }
        Map attributes = session.getAttributes().getAttributes();
        Map parameterMap = scriptContext.getHttpRequest().getParameterMap();
        if (parameterMap == null || parameterMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : parameterMap.entrySet()) {
            if (attributes.containsKey(entry.getKey()) || !ArrayUtils.isNotEmpty((Object[])((String[])entry.getValue()))) continue;
            String value = ((String[])entry.getValue())[0];
            attributes.put((String)entry.getKey(), value);
            this.log.trace("Put in session request parameter: {}, value: {}", entry.getKey(), (Object)value);
        }
        try {
            this.persistenceEntryManager.merge((Object)session);
        }
        catch (Exception e) {
            this.log.error("Failed to save authorization challenge session: " + session.getId(), (Throwable)e);
        }
    }

    public CustomScriptConfiguration identifyScript(List<String> acrValues) {
        this.log.trace("Identifying script, acr_values: {}", acrValues);
        if (acrValues == null || acrValues.isEmpty()) {
            this.log.trace("No acr_values, return default script");
            return this.getCustomScriptConfigurationByName(this.appConfiguration.getAuthorizationChallengeDefaultAcr());
        }
        for (String acr : acrValues) {
            CustomScriptConfiguration script = this.getCustomScriptConfigurationByName(acr);
            if (script == null) continue;
            this.log.trace("Found script {} by acr {}", (Object)script.getInum(), (Object)acr);
            return script;
        }
        this.log.trace("Unable to find script by acr_values {}", acrValues);
        return this.getCustomScriptConfigurationByName(this.appConfiguration.getAuthorizationChallengeDefaultAcr());
    }

    public void externalPrepareAuthzRequest(AuthzRequest authzRequest) {
        List<String> acrValues = authzRequest.getAcrValuesList();
        CustomScriptConfiguration script = this.identifyScript(acrValues);
        if (script == null) {
            String msg = String.format("Unable to identify script by acr_values %s.", acrValues);
            this.log.debug(msg);
            throw new WebApplicationException(this.errorResponseFactory.newErrorResponse(Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, authzRequest.getState(), msg)).build());
        }
        this.log.trace("Executing python 'prepareAuthzRequest' method, script name: {}, clientId: {}, scope: {}, authorizationChallengeSession: {}, sessionAttributes: {}", new Object[]{script.getName(), authzRequest.getClientId(), authzRequest.getScope(), authzRequest.getAuthorizationChallengeSessionAttributesSafely()});
        ExecutionContext executionContext = ExecutionContext.of(authzRequest);
        executionContext.setScript(script);
        try {
            AuthorizationChallengeType authorizationChallengeType = (AuthorizationChallengeType)script.getExternalType();
            ExternalScriptContext scriptContext = new ExternalScriptContext(executionContext);
            authorizationChallengeType.prepareAuthzRequest((Object)scriptContext);
            scriptContext.throwWebApplicationExceptionIfSet();
        }
        catch (WebApplicationException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("WebApplicationException from script", (Throwable)e);
            }
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            throw new WebApplicationException(this.errorResponseFactory.newErrorResponse(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, executionContext.getAuthzRequest().getState(), "Unable to run 'prepareAuthzRequest' method authorization challenge script.")).build());
        }
        this.log.trace("Finished 'prepareAuthzRequest' method, script name: {}, clientId: {}, sessionAttributes: {}", new Object[]{script.getName(), executionContext.getAuthzRequest().getClientId(), authzRequest.getAuthorizationChallengeSessionAttributesSafely()});
    }
}

