/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.authzdetails.AuthzDetail;
import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.error.IErrorType;
import io.jans.as.server.authorize.ws.rs.AuthzRequest;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.service.external.context.ExternalScriptContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.authzdetails.AuthzDetailType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.ws.rs.WebApplicationException;
import java.util.Set;

@ApplicationScoped
public class ExternalAuthzDetailTypeService
extends ExternalScriptService {
    public ExternalAuthzDetailTypeService() {
        super(CustomScriptType.AUTHZ_DETAIL);
    }

    public Set<String> getSupportedAuthzDetailsTypes() {
        return this.customScriptConfigurationsNameMap.keySet();
    }

    public void externalValidateAuthzDetails(AuthzRequest authzRequest) {
        ExecutionContext executionContext = ExecutionContext.of(authzRequest);
        this.externalValidateAuthzDetails(executionContext);
    }

    public void externalValidateAuthzDetails(ExecutionContext executionContext) {
        AuthzDetails authzDetails = executionContext.getAuthzDetails();
        for (AuthzDetail authzDetail : authzDetails.getDetails()) {
            this.validateSingleAuthzDetail(executionContext, authzDetail);
        }
    }

    private void validateSingleAuthzDetail(ExecutionContext executionContext, AuthzDetail authzDetail) {
        executionContext.setAuthzDetail(authzDetail);
        String type = authzDetail.getType();
        CustomScriptConfiguration script = this.getCustomScriptConfigurationByName(type);
        if (script == null) {
            this.log.error("Unable to find 'AuthzDetailType' custom script by name {}", (Object)type);
            throw executionContext.getAuthzRequest().getRedirectUriResponse().createWebException((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, "Unable to find 'AuthzDetailType' custom script by name " + type);
        }
        this.externalValidateDetail(executionContext, script);
    }

    public void externalValidateDetail(ExecutionContext executionContext, CustomScriptConfiguration script) {
        this.log.trace("Executing python 'validateDetail' method, script name: {}, clientId: {}, authzDetail: {}", new Object[]{script.getName(), executionContext.getClient().getClientId(), executionContext.getAuthzDetail()});
        executionContext.setScript(script);
        boolean result = false;
        try {
            AuthzDetailType authzDetailType = (AuthzDetailType)script.getExternalType();
            ExternalScriptContext scriptContext = new ExternalScriptContext(executionContext);
            result = authzDetailType.validateDetail((Object)scriptContext);
            scriptContext.throwWebApplicationExceptionIfSet();
        }
        catch (WebApplicationException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("WebApplicationException from script", (Throwable)e);
            }
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
        }
        this.log.trace("Finished 'validateDetail' method, script name: {}, clientId: {}, result: {}", new Object[]{script.getName(), executionContext.getClient().getClientId(), result});
        if (!result) {
            throw executionContext.getAuthzRequest().getRedirectUriResponse().createWebException((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, "Access is denied by 'AuthzDetailType' custom script 'validateDetail' method.");
        }
    }

    public String externalGetUiRepresentation(ExecutionContext executionContext, AuthzDetail detail) {
        executionContext.setAuthzDetail(detail);
        String type = detail.getType();
        CustomScriptConfiguration script = this.getCustomScriptConfigurationByName(type);
        if (script == null) {
            this.log.error("Unable to find 'AuthzDetailType' custom script by name {}", (Object)type);
            return detail.getJsonObject().toString();
        }
        return this.externalGetUiRepresentation(executionContext, script);
    }

    public String externalGetUiRepresentation(ExecutionContext executionContext, CustomScriptConfiguration script) {
        this.log.trace("Executing python 'getUiRepresentation' method, script name: {}, clientId: {}, authzDetail: {}", new Object[]{script.getName(), executionContext.getAuthzRequest().getClientId(), executionContext.getAuthzDetail()});
        executionContext.setScript(script);
        String result = executionContext.getAuthzDetail().toString();
        try {
            AuthzDetailType authzDetailType = (AuthzDetailType)script.getExternalType();
            ExternalScriptContext scriptContext = new ExternalScriptContext(executionContext);
            result = authzDetailType.getUiRepresentation((Object)scriptContext);
            scriptContext.throwWebApplicationExceptionIfSet();
        }
        catch (WebApplicationException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("WebApplicationException from script", (Throwable)e);
            }
            throw e;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
        }
        this.log.trace("Finished 'getUiRepresentation' method, script name: {}, clientId: {}, result: {}", new Object[]{script.getName(), executionContext.getAuthzRequest().getClientId(), result});
        return result;
    }
}

