/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.common.model.registration.Client;
import io.jans.as.server.service.external.context.ExternalPostAuthnContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.postauthn.PostAuthnType;
import io.jans.service.custom.script.ExternalScriptService;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Named;
import java.util.List;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalPostAuthnService
extends ExternalScriptService {
    public ExternalPostAuthnService() {
        super(CustomScriptType.POST_AUTHN);
    }

    public boolean externalForceReAuthentication(Client client, ExternalPostAuthnContext context) {
        List scripts = this.getCustomScriptConfigurationsByDns(client.getAttributes().getPostAuthnScripts());
        if (scripts.isEmpty()) {
            return false;
        }
        this.log.trace("Found {} post-authn scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            if (this.externalForceReAuthentication(script, context)) continue;
            return false;
        }
        this.log.debug("Forcing re-authentication via post-authn script.");
        return true;
    }

    public boolean externalForceAuthorization(Client client, ExternalPostAuthnContext context) {
        List scripts = this.getCustomScriptConfigurationsByDns(client.getAttributes().getPostAuthnScripts());
        if (scripts.isEmpty()) {
            return false;
        }
        this.log.trace("Found {} post-authn scripts.", (Object)scripts.size());
        for (CustomScriptConfiguration script : scripts) {
            if (this.externalForceAuthorization(script, context)) continue;
            return false;
        }
        this.log.debug("Forcing authorization via post-authn script.");
        return true;
    }

    public boolean externalForceReAuthentication(CustomScriptConfiguration scriptConfiguration, ExternalPostAuthnContext context) {
        try {
            this.log.trace("Executing external 'externalForceReAuthentication' method, script name: {}, context: {}", (Object)scriptConfiguration.getName(), (Object)context);
            PostAuthnType script = (PostAuthnType)scriptConfiguration.getExternalType();
            context.setScript(scriptConfiguration);
            boolean result = script.forceReAuthentication((Object)context);
            this.log.trace("Finished external 'externalForceReAuthentication' method, script name: {}, context: {}, result: {}", new Object[]{scriptConfiguration.getName(), context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }

    public boolean externalForceAuthorization(CustomScriptConfiguration scriptConfiguration, ExternalPostAuthnContext context) {
        try {
            this.log.trace("Executing external 'externalForceAuthorization' method, script name: {}, context: {}", (Object)scriptConfiguration.getName(), (Object)context);
            PostAuthnType script = (PostAuthnType)scriptConfiguration.getExternalType();
            context.setScript(scriptConfiguration);
            boolean result = script.forceAuthorization((Object)context);
            this.log.trace("Finished external 'externalForceAuthorization' method, script name: {}, context: {}, result: {}", new Object[]{scriptConfiguration.getName(), context, result});
            return result;
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(scriptConfiguration.getCustomScript(), ex);
            return false;
        }
    }
}

