/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service.external;

import io.jans.as.server.service.external.ExternalUmaRptPolicyService;
import io.jans.as.server.uma.authorization.UmaGatherContext;
import io.jans.model.custom.script.CustomScriptType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.uma.UmaClaimsGatheringType;
import io.jans.service.LookupService;
import io.jans.service.custom.script.CustomScriptManager;
import io.jans.service.custom.script.ExternalScriptService;
import io.jans.service.custom.script.ExternalTypeCreator;
import io.jans.util.StringHelper;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@ApplicationScoped
@DependsOn(value={"appInitializer"})
@Named
public class ExternalUmaClaimsGatheringService
extends ExternalScriptService {
    @Inject
    private LookupService lookupService;
    @Inject
    private CustomScriptManager scriptManager;
    @Inject
    private ExternalTypeCreator externalTypeCreator;
    protected Map<String, CustomScriptConfiguration> scriptInumMap;

    public ExternalUmaClaimsGatheringService() {
        super(CustomScriptType.UMA_CLAIMS_GATHERING);
    }

    protected void reloadExternal() {
        this.scriptInumMap = this.buildExternalConfigurationsInumMap(this.customScriptConfigurations);
    }

    public CustomScriptConfiguration determineScript(String[] scriptNames) {
        this.log.trace("Trying to determine claims-gathering script, scriptNames: {} ...", (Object)Arrays.toString(scriptNames));
        ArrayList<CustomScriptConfiguration> scripts = new ArrayList<CustomScriptConfiguration>();
        for (String scriptName : scriptNames) {
            CustomScriptConfiguration script = this.getCustomScriptConfigurationByName(scriptName);
            if (script != null) {
                scripts.add(script);
                continue;
            }
            this.log.error("Failed to load claims-gathering script with name: {}", (Object)scriptName);
        }
        if (scripts.isEmpty()) {
            return null;
        }
        CustomScriptConfiguration highestPriority = Collections.max(scripts, new Comparator<CustomScriptConfiguration>(){

            @Override
            public int compare(CustomScriptConfiguration o1, CustomScriptConfiguration o2) {
                return Integer.compare(o1.getLevel(), o2.getLevel());
            }
        });
        this.log.trace("Determined claims-gathering script successfully. Name: {}, inum: {}", (Object)highestPriority.getName(), (Object)highestPriority.getInum());
        return highestPriority;
    }

    private Map<String, CustomScriptConfiguration> buildExternalConfigurationsInumMap(List<CustomScriptConfiguration> customScriptConfigurations) {
        HashMap<String, CustomScriptConfiguration> reloadedExternalConfigurations = new HashMap<String, CustomScriptConfiguration>(customScriptConfigurations.size());
        for (CustomScriptConfiguration customScriptConfiguration : customScriptConfigurations) {
            reloadedExternalConfigurations.put(customScriptConfiguration.getInum(), customScriptConfiguration);
        }
        return reloadedExternalConfigurations;
    }

    public CustomScriptConfiguration getScriptByDn(String scriptDn) {
        String authorizationPolicyInum = this.lookupService.getInumFromDn(scriptDn);
        return this.getScriptByInum(authorizationPolicyInum);
    }

    public CustomScriptConfiguration getScriptByInum(String inum) {
        if (StringHelper.isEmpty((String)inum)) {
            return null;
        }
        return this.scriptInumMap.get(inum);
    }

    private UmaClaimsGatheringType gatherScript(CustomScriptConfiguration script) {
        return ExternalUmaRptPolicyService.HOTSWAP_UMA_SCRIPT ? (UmaClaimsGatheringType)ExternalUmaRptPolicyService.hotswap(this.externalTypeCreator, script, false) : (UmaClaimsGatheringType)script.getExternalType();
    }

    public boolean gather(CustomScriptConfiguration script, int step, UmaGatherContext context) {
        try {
            this.log.debug("Executing python 'gather' method, script: " + script.getName());
            boolean result = this.gatherScript(script).gather(step, (Object)context);
            this.log.debug("python 'gather' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'gather' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public int getNextStep(CustomScriptConfiguration script, int step, UmaGatherContext context) {
        try {
            this.log.debug("Executing python 'getNextStep' method, script: " + script.getName());
            int result = this.gatherScript(script).getNextStep(step, (Object)context);
            this.log.debug("python 'getNextStep' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'getNextStep' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return -1;
        }
    }

    public boolean prepareForStep(CustomScriptConfiguration script, int step, UmaGatherContext context) {
        try {
            this.log.debug("Executing python 'prepareForStep' method, script: " + script.getName());
            boolean result = this.gatherScript(script).prepareForStep(step, (Object)context);
            this.log.debug("python 'prepareForStep' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'prepareForStep' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return false;
        }
    }

    public int getStepsCount(CustomScriptConfiguration script, UmaGatherContext context) {
        try {
            this.log.debug("Executing python 'getStepsCount' method, script: " + script.getName());
            int result = this.gatherScript(script).getStepsCount((Object)context);
            this.log.debug("python 'getStepsCount' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'getStepsCount' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return -1;
        }
    }

    public String getPageForStep(CustomScriptConfiguration script, int step, UmaGatherContext context) {
        try {
            this.log.debug("Executing python 'getPageForStep' method, script: " + script.getName());
            String result = this.gatherScript(script).getPageForStep(step, (Object)context);
            this.log.debug("python 'getPageForStep' result: " + result);
            return result;
        }
        catch (Exception ex) {
            this.log.error("Failed to execute python 'getPageForStep' method, script: " + script.getName() + ", message: " + ex.getMessage(), (Throwable)ex);
            this.saveScriptError(script.getCustomScript(), ex);
            return "";
        }
    }
}

