/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.servlet;

import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.service.DiscoveryService;
import io.jans.as.server.service.LocalResponseCache;
import io.jans.as.server.service.external.ExternalAuthenticationService;
import io.jans.as.server.service.external.ExternalDiscoveryService;
import io.jans.as.server.service.external.ExternalDynamicScopeService;
import io.jans.as.server.util.ServerUtil;
import jakarta.inject.Inject;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;

@WebServlet(urlPatterns={"/.well-known/openid-configuration"}, loadOnStartup=10)
public class OpenIdConfiguration
extends HttpServlet {
    private static final long serialVersionUID = -8224898157373678904L;
    @Inject
    private transient Logger log;
    @Inject
    private transient DiscoveryService discoveryService;
    @Inject
    private transient ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private transient ExternalDynamicScopeService externalDynamicScopeService;
    @Inject
    private transient ExternalDiscoveryService externalDiscoveryService;
    @Inject
    private transient LocalResponseCache localResponseCache;

    protected void processRequest(HttpServletRequest servletRequest, HttpServletResponse httpResponse) throws IOException {
        if (!this.externalAuthenticationService.isLoaded() || !this.externalDynamicScopeService.isLoaded()) {
            httpResponse.sendError(503);
            this.log.error("Jans Auth still starting up!");
            return;
        }
        httpResponse.setContentType("application/json");
        try (PrintWriter out = httpResponse.getWriter();){
            JSONObject cachedResponse = this.localResponseCache.getDiscoveryResponse();
            if (cachedResponse != null) {
                this.log.trace("Cached discovery response returned.");
                out.println(ServerUtil.toPrettyJson(cachedResponse).replace("\\/", "/"));
                return;
            }
            JSONObject jsonObj = this.discoveryService.process();
            JSONObject clone = new JSONObject(jsonObj.toString());
            ExecutionContext context = new ExecutionContext(servletRequest, httpResponse);
            if (!this.externalDiscoveryService.modifyDiscovery(jsonObj, context)) {
                jsonObj = clone;
            }
            out.println(ServerUtil.toPrettyJson(jsonObj).replace("\\/", "/"));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "OpenID Provider Configuration Information";
    }

    public static void filterOutKeys(JSONObject jsonObj, AppConfiguration appConfiguration) {
        List allowedKeys;
        List denyKeys;
        if (BooleanUtils.isFalse((Boolean)appConfiguration.getAllowBlankValuesInDiscoveryResponse())) {
            for (Object key : new HashSet(jsonObj.keySet())) {
                if (jsonObj.get((String)key) != null && !StringUtils.isBlank((CharSequence)jsonObj.optString((String)key))) continue;
                jsonObj.remove((String)key);
            }
        }
        if (!(denyKeys = appConfiguration.getDiscoveryDenyKeys()).isEmpty()) {
            for (String key : new HashSet(jsonObj.keySet())) {
                if (!denyKeys.contains(key)) continue;
                jsonObj.remove(key);
            }
        }
        if (!(allowedKeys = appConfiguration.getDiscoveryAllowedKeys()).isEmpty()) {
            for (String key : new HashSet(jsonObj.keySet())) {
                if (allowedKeys.contains(key)) continue;
                jsonObj.remove(key);
            }
        }
    }
}

