/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.servlet;

import io.jans.as.server.service.SectorIdentifierService;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.json.JSONArray;
import org.slf4j.Logger;

@WebServlet(urlPatterns={"/sectoridentifier/*"})
public class SectorIdentifier
extends HttpServlet {
    private static final long serialVersionUID = -1222077047492070618L;
    @Inject
    private Logger log;
    @Inject
    private SectorIdentifierService sectorIdentifierService;

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/json");
        try (PrintWriter out = response.getWriter();){
            String urlPath = request.getPathInfo();
            String jsId = urlPath.substring(urlPath.lastIndexOf("/") + 1);
            io.jans.as.persistence.model.SectorIdentifier sectorIdentifier = this.sectorIdentifierService.getSectorIdentifierById(jsId);
            JSONArray jsonArray = new JSONArray();
            for (String redirectUri : sectorIdentifier.getRedirectUris()) {
                jsonArray.put((Object)redirectUri);
            }
            out.println(jsonArray.toString(4).replace("\\/", "/"));
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Sector Identifier";
    }
}

