/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ssa.ws.rs.action;

import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.ssa.Ssa;
import io.jans.as.common.model.ssa.SsaState;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.ssa.SsaErrorResponseType;
import io.jans.as.model.ssa.SsaScopeType;
import io.jans.as.server.service.external.ModifySsaResponseService;
import io.jans.as.server.service.external.context.ModifySsaResponseContext;
import io.jans.as.server.ssa.ws.rs.SsaContextBuilder;
import io.jans.as.server.ssa.ws.rs.SsaRestWebServiceValidator;
import io.jans.as.server.ssa.ws.rs.SsaService;
import io.jans.as.server.util.ServerUtil;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Stateless
@Named
public class SsaRevokeAction {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private SsaService ssaService;
    @Inject
    private SsaRestWebServiceValidator ssaRestWebServiceValidator;
    @Inject
    private ModifySsaResponseService modifySsaResponseService;
    @Inject
    private SsaContextBuilder ssaContextBuilder;

    public Response revoke(String jti, String orgId, HttpServletRequest httpRequest) {
        this.log.debug("Attempting to revoke ssa, jti: '{}', orgId: {}", (Object)jti, (Object)orgId);
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.SSA);
        Response.ResponseBuilder builder = Response.ok();
        try {
            if (this.isNotValidParam(jti, orgId)) {
                return this.ssaService.createNotAcceptableResponse().build();
            }
            Client client = this.ssaRestWebServiceValidator.getClientFromSession();
            this.ssaRestWebServiceValidator.checkScopesPolicy(client, SsaScopeType.SSA_ADMIN.getValue());
            List<Ssa> ssaList = this.ssaService.getSsaList(jti, orgId, SsaState.ACTIVE, client.getClientId(), client.getScopes());
            if (ssaList.isEmpty()) {
                return this.ssaService.createUnprocessableEntityResponse().build();
            }
            for (Ssa ssa : ssaList) {
                ssa.setState(SsaState.REVOKED);
                ssa.setExpirationDate(new Date());
                this.ssaService.merge(ssa);
                this.log.info("Ssa jti: '{}' updated status to '{}' and set it expired.", (Object)ssa.getId(), (Object)ssa.getState().getValue());
            }
            ModifySsaResponseContext context = this.ssaContextBuilder.buildModifySsaResponseContext(httpRequest, client);
            this.modifySsaResponseService.revoke(ssaList, context);
        }
        catch (WebApplicationException e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)SsaErrorResponseType.UNKNOWN_ERROR, "Unknown error");
        }
        builder.cacheControl(ServerUtil.cacheControl(true, false));
        builder.header("Pragma", (Object)"no-cache");
        builder.type(MediaType.APPLICATION_JSON_TYPE);
        return builder.build();
    }

    private boolean isNotValidParam(String jti, String orgId) {
        return StringUtils.isBlank((CharSequence)jti) && StringUtils.isBlank((CharSequence)orgId);
    }
}

