/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.token.ws.rs;

import com.google.common.base.Preconditions;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.common.service.AttributeService;
import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.model.token.TokenErrorResponseType;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.authorize.ws.rs.AuthzDetailsService;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.common.AccessToken;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.common.IdToken;
import io.jans.as.server.model.common.RefreshToken;
import io.jans.as.server.model.common.TokenExchangeGrant;
import io.jans.as.server.model.token.HandleTokenFactory;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.service.external.ExternalTokenExchangeService;
import io.jans.as.server.service.external.ExternalUpdateTokenService;
import io.jans.as.server.service.external.context.ExternalUpdateTokenContext;
import io.jans.as.server.token.ws.rs.TokenCreatorService;
import io.jans.as.server.token.ws.rs.TokenRestWebServiceImpl;
import io.jans.as.server.token.ws.rs.TokenRestWebServiceValidator;
import io.jans.as.server.util.ServerUtil;
import io.jans.model.custom.script.type.token.ScriptTokenExchangeControl;
import io.jans.model.user.SimpleUser;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@Stateless
@Named
public class TokenExchangeService {
    public static final String DEVICE_SECRET = "device_secret";
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private TokenRestWebServiceValidator tokenRestWebServiceValidator;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ExternalUpdateTokenService externalUpdateTokenService;
    @Inject
    private TokenCreatorService tokenCreatorService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private AuthzDetailsService authzDetailsService;
    @Inject
    private ExternalTokenExchangeService externalTokenExchangeService;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;

    public void rotateDeviceSecretOnRefreshToken(HttpServletRequest httpRequest, AuthorizationGrant refreshGrant, String scope) {
        if (StringUtils.isBlank((CharSequence)scope) || !scope.contains("device_sso")) {
            this.log.debug("Skip rotate device secret on refresh token. No device_sso scope.");
            return;
        }
        if (StringUtils.isBlank((CharSequence)refreshGrant.getSessionDn())) {
            return;
        }
        SessionId sessionId = this.sessionIdService.getSessionByDn(refreshGrant.getSessionDn());
        if (sessionId == null) {
            return;
        }
        String deviceSecret = httpRequest.getParameter(DEVICE_SECRET);
        if (StringUtils.isBlank((CharSequence)deviceSecret)) {
            this.rotateDeviceSecret(sessionId, deviceSecret, true);
        }
    }

    public String rotateDeviceSecret(SessionId sessionId, String deviceSecret) {
        return this.rotateDeviceSecret(sessionId, deviceSecret, false);
    }

    public String rotateDeviceSecret(SessionId sessionId, String deviceSecret, boolean forceRotation) {
        if (BooleanUtils.isFalse((Boolean)this.appConfiguration.getRotateDeviceSecret()) && !forceRotation) {
            return null;
        }
        String newDeviceSecret = HandleTokenFactory.generateDeviceSecret();
        List deviceSecrets = sessionId.getDeviceSecrets();
        deviceSecrets.remove(deviceSecret);
        deviceSecrets.add(newDeviceSecret);
        this.sessionIdService.updateSessionId(sessionId, false);
        return newDeviceSecret;
    }

    public JSONObject processTokenExchange(String scope, Function<JsonWebResponse, Void> idTokenPreProcessing, ExecutionContext executionContext) {
        HttpServletRequest httpRequest = executionContext.getHttpRequest();
        Client client = executionContext.getClient();
        OAuth2AuditLog auditLog = executionContext.getAuditLog();
        ScriptTokenExchangeControl scriptControl = this.externalTokenExchangeService.externalValidate(executionContext);
        String rotatedDeviceSecret = null;
        SessionId sessionId = null;
        if (!scriptControl.isSkipBuiltinValidation()) {
            String audience = httpRequest.getParameter("audience");
            String subjectToken = httpRequest.getParameter("subject_token");
            String subjectTokenType = httpRequest.getParameter("subject_token_type");
            String deviceSecret = httpRequest.getParameter("actor_token");
            String actorTokenType = httpRequest.getParameter("actor_token_type");
            this.tokenRestWebServiceValidator.validateAudience(audience, auditLog);
            this.tokenRestWebServiceValidator.validateSubjectTokenType(subjectTokenType, auditLog);
            this.tokenRestWebServiceValidator.validateActorTokenType(actorTokenType, auditLog);
            this.tokenRestWebServiceValidator.validateActorToken(deviceSecret, auditLog);
            sessionId = this.sessionIdService.getSessionByDeviceSecret(deviceSecret);
            this.tokenRestWebServiceValidator.validateSessionForTokenExchange(sessionId, deviceSecret, auditLog);
            Preconditions.checkNotNull((Object)sessionId);
            this.tokenRestWebServiceValidator.validateSubjectToken(deviceSecret, subjectToken, sessionId, auditLog);
            rotatedDeviceSecret = this.rotateDeviceSecret(sessionId, deviceSecret);
            if (scriptControl.getUser() == null) {
                scriptControl.setUser((SimpleUser)this.sessionIdService.getUser(sessionId));
            }
        }
        this.checkUserType(scriptControl.getUser(), executionContext);
        User user = scriptControl.getUser() != null ? (User)scriptControl.getUser() : new User();
        TokenExchangeGrant tokenExchangeGrant = this.authorizationGrantList.createTokenExchangeGrant(user, client);
        tokenExchangeGrant.setSessionDn(sessionId != null ? sessionId.getDn() : null);
        executionContext.setGrant(tokenExchangeGrant);
        scope = tokenExchangeGrant.checkScopesPolicy(scope);
        AuthzDetails checkedAuthzDetails = this.authzDetailsService.checkAuthzDetailsAndSave(executionContext.getAuthzDetails(), tokenExchangeGrant);
        AccessToken accessToken = tokenExchangeGrant.createAccessToken(executionContext);
        IdToken idToken = null;
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getOpenidScopeBackwardCompatibility()) && tokenExchangeGrant.getScopes().contains("openid")) {
            boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
            ExternalUpdateTokenContext context = new ExternalUpdateTokenContext(httpRequest, tokenExchangeGrant, client, this.appConfiguration, this.attributeService);
            executionContext.setIncludeIdTokenClaims(includeIdTokenClaims);
            executionContext.setPreProcessing(idTokenPreProcessing);
            executionContext.setPostProcessor(this.externalUpdateTokenService.buildModifyIdTokenProcessor(context));
            idToken = tokenExchangeGrant.createIdToken(null, null, null, null, null, executionContext);
        }
        RefreshToken reToken = this.tokenCreatorService.createRefreshToken(executionContext, scope);
        executionContext.getAuditLog().updateOAuth2AuditLog(tokenExchangeGrant, true);
        JSONObject jsonObj = new JSONObject();
        try {
            TokenRestWebServiceImpl.fillJsonObject(jsonObj, accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), reToken, scope, idToken, checkedAuthzDetails);
            jsonObj.put("issued_token_type", (Object)"urn:ietf:params:oauth:token-type:access_token");
            if (StringUtils.isNotBlank((CharSequence)rotatedDeviceSecret)) {
                jsonObj.put(DEVICE_SECRET, (Object)rotatedDeviceSecret);
            }
        }
        catch (JSONException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        JSONObject clone = new JSONObject(jsonObj.toString());
        if (this.externalTokenExchangeService.externalModifyResponse(jsonObj, executionContext)) {
            this.log.debug("Successfully run external token-exchange scripts.");
        } else {
            jsonObj = clone;
            this.log.trace("Canceled changes made by external token-exchange script since method returned `false`.");
        }
        return jsonObj;
    }

    private void checkUserType(SimpleUser user, ExecutionContext context) {
        if (user == null) {
            return;
        }
        if (!(user instanceof User)) {
            String msg = "Custom token-exchange script sets user which is not 'io.jans.as.common.model.common.User'. Please fix script.";
            this.log.error("Custom token-exchange script sets user which is not 'io.jans.as.common.model.common.User'. Please fix script.");
            throw new WebApplicationException(this.response(this.error(500, TokenErrorResponseType.INVALID_GRANT, "Custom token-exchange script sets user which is not 'io.jans.as.common.model.common.User'. Please fix script."), context.getAuditLog()));
        }
    }

    public String createNewDeviceSecret(String sessionDn, Client client, String scope) {
        if (StringUtils.isBlank((CharSequence)scope) || !scope.contains("device_sso")) {
            this.log.debug("Skip device secret. No device_sso scope.");
            return null;
        }
        if (client == null || !ArrayUtils.contains((Object[])client.getGrantTypes(), (Object)GrantType.TOKEN_EXCHANGE)) {
            this.log.debug("Skip device secret. Scope has {} value but client does not have Token Exchange Grant Type enabled ('urn:ietf:params:oauth:grant-type:token-exchange')", (Object)"device_sso");
            return null;
        }
        try {
            SessionId sessionId = this.sessionIdService.getSessionByDn(sessionDn);
            if (sessionId == null) {
                this.log.debug("Unable to find session by dn: {}", (Object)sessionDn);
                return null;
            }
            String newDeviceSecret = HandleTokenFactory.generateDeviceSecret();
            sessionId.getDeviceSecrets().add(newDeviceSecret);
            this.sessionIdService.updateSessionId(sessionId, false);
            return newDeviceSecret;
        }
        catch (Exception e) {
            this.log.error("Failed to generate device_secret", (Throwable)e);
            return null;
        }
    }

    private Response response(Response.ResponseBuilder builder, OAuth2AuditLog oAuth2AuditLog) {
        builder.cacheControl(ServerUtil.cacheControl(true, false));
        builder.header("Pragma", (Object)"no-cache");
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }

    public Response.ResponseBuilder error(int status, TokenErrorResponseType type, String reason) {
        return Response.status((int)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)type, reason));
    }
}

