/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.token.ws.rs;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.common.service.AttributeService;
import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.common.BackchannelTokenDeliveryMode;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.TokenType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.binding.TokenBindingMessage;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.model.token.TokenErrorResponseType;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.auth.DpopService;
import io.jans.as.server.authorize.ws.rs.AuthzDetailsService;
import io.jans.as.server.model.audit.Action;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.common.AccessToken;
import io.jans.as.server.model.common.AuthorizationCodeGrant;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.model.common.CIBAGrant;
import io.jans.as.server.model.common.CibaRequestCacheControl;
import io.jans.as.server.model.common.CibaRequestStatus;
import io.jans.as.server.model.common.ClientCredentialsGrant;
import io.jans.as.server.model.common.DeviceAuthorizationCacheControl;
import io.jans.as.server.model.common.DeviceAuthorizationStatus;
import io.jans.as.server.model.common.DeviceCodeGrant;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.common.IdToken;
import io.jans.as.server.model.common.RefreshToken;
import io.jans.as.server.model.common.ResourceOwnerPasswordCredentialsGrant;
import io.jans.as.server.model.session.SessionClient;
import io.jans.as.server.model.token.JwrService;
import io.jans.as.server.security.Identity;
import io.jans.as.server.service.AuthenticationFilterService;
import io.jans.as.server.service.AuthenticationService;
import io.jans.as.server.service.DeviceAuthorizationService;
import io.jans.as.server.service.GrantService;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.service.UserService;
import io.jans.as.server.service.ciba.CibaRequestService;
import io.jans.as.server.service.external.ExternalResourceOwnerPasswordCredentialsService;
import io.jans.as.server.service.external.ExternalUpdateTokenService;
import io.jans.as.server.service.external.context.ExternalResourceOwnerPasswordCredentialsContext;
import io.jans.as.server.service.external.context.ExternalUpdateTokenContext;
import io.jans.as.server.service.stat.StatService;
import io.jans.as.server.token.ws.rs.JwtGrantService;
import io.jans.as.server.token.ws.rs.TokenCreatorService;
import io.jans.as.server.token.ws.rs.TokenExchangeService;
import io.jans.as.server.token.ws.rs.TokenRestWebService;
import io.jans.as.server.token.ws.rs.TokenRestWebServiceValidator;
import io.jans.as.server.token.ws.rs.TxTokenService;
import io.jans.as.server.uma.service.UmaTokenService;
import io.jans.as.server.util.ServerUtil;
import io.jans.model.token.TokenEntity;
import io.jans.orm.exception.AuthenticationException;
import io.jans.orm.exception.operation.SearchException;
import io.jans.util.StringHelper;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@Path(value="/")
public class TokenRestWebServiceImpl
implements TokenRestWebService {
    @Inject
    private Logger log;
    @Inject
    private Identity identity;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private UserService userService;
    @Inject
    private GrantService grantService;
    @Inject
    private AuthenticationFilterService authenticationFilterService;
    @Inject
    private AuthenticationService authenticationService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private UmaTokenService umaTokenService;
    @Inject
    private ExternalResourceOwnerPasswordCredentialsService externalResourceOwnerPasswordCredentialsService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private CibaRequestService cibaRequestService;
    @Inject
    private DeviceAuthorizationService deviceAuthorizationService;
    @Inject
    private ExternalUpdateTokenService externalUpdateTokenService;
    @Inject
    private TokenRestWebServiceValidator tokenRestWebServiceValidator;
    @Inject
    private TokenExchangeService tokenExchangeService;
    @Inject
    private TokenCreatorService tokenCreatorService;
    @Inject
    private StatService statService;
    @Inject
    private DpopService dPoPService;
    @Inject
    private AuthzDetailsService authzDetailsService;
    @Inject
    private TxTokenService txTokenService;
    @Inject
    private JwtGrantService jwtGrantService;
    private final ConcurrentMap<String, String> refreshTokenLock = Maps.newConcurrentMap();

    @Override
    public Response requestAccessToken(String grantType, String code, String redirectUri, String username, String password, String scope, String authorizationDetails, String assertion, String refreshToken, String clientId, String clientSecret, String codeVerifier, String ticket, String claimToken, String claimTokenFormat, String pctCode, String rptCode, String authReqId, String deviceCode, HttpServletRequest request, HttpServletResponse response, SecurityContext sec) {
        this.log.debug("Attempting to request access token: grantType = {}, code = {}, redirectUri = {}, username = {}, refreshToken = {}, clientId = {}, ExtraParams = {}, isSecure = {}, codeVerifier = {}, ticket = {}, authorizationDetails = {}", new Object[]{grantType, code, redirectUri, username, refreshToken, clientId, ServerUtil.prepareForLogs(request.getParameterMap()), sec.isSecure(), codeVerifier, ticket, authorizationDetails});
        boolean isUma = StringUtils.isNotBlank((CharSequence)ticket);
        if (isUma) {
            return this.umaTokenService.requestRpt(grantType, ticket, claimToken, claimTokenFormat, pctCode, rptCode, scope, request, response);
        }
        OAuth2AuditLog auditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(request), Action.TOKEN_REQUEST);
        auditLog.setClientId(clientId);
        auditLog.setUsername(username);
        auditLog.setScope(scope);
        String tokenBindingHeader = request.getHeader("Sec-Token-Binding");
        scope = ServerUtil.urlDecode(scope);
        try {
            this.tokenRestWebServiceValidator.validateParams(grantType, code, refreshToken, auditLog);
            GrantType gt = GrantType.fromString((String)grantType);
            this.log.debug("Grant type: '{}'", (Object)gt);
            Client client = this.tokenRestWebServiceValidator.validateClient(this.getClient(), auditLog);
            this.tokenRestWebServiceValidator.validateGrantType(gt, client, auditLog);
            String dpopStr = this.dPoPService.getDPoPJwkThumbprint(request, client, auditLog);
            Function idTokenTokingBindingPreprocessing = TokenBindingMessage.createIdTokenTokingBindingPreprocessing((String)tokenBindingHeader, (String)client.getIdTokenTokenBindingCnf());
            SessionId sessionIdObj = this.sessionIdService.getSessionId(request);
            java.util.function.Function<JsonWebResponse, Void> idTokenPreProcessing = JwrService.wrapWithSidFunction((java.util.function.Function<JsonWebResponse, Void>)idTokenTokingBindingPreprocessing, sessionIdObj != null ? sessionIdObj.getOutsideSid() : null);
            ExecutionContext executionContext = new ExecutionContext(request, response);
            executionContext.setCertAsPem(request.getHeader("X-ClientCert"));
            executionContext.setDpop(dpopStr);
            executionContext.setClient(client);
            executionContext.setAppConfiguration(this.appConfiguration);
            executionContext.setAttributeService(this.attributeService);
            executionContext.setAuditLog(auditLog);
            executionContext.setScopes((Set<String>)(StringUtils.isNotBlank((CharSequence)scope) ? new HashSet<String>(Arrays.asList(scope.split(" "))) : new HashSet()));
            AuthzDetails authzDetails = this.authzDetailsService.validateAuthorizationDetails(authorizationDetails, executionContext);
            executionContext.setAuthzDetails(authzDetails);
            if (gt == GrantType.AUTHORIZATION_CODE) {
                return this.processAuthorizationCode(code, scope, codeVerifier, sessionIdObj, redirectUri, executionContext);
            }
            if (gt == GrantType.REFRESH_TOKEN) {
                return this.processRefreshTokenGrant(scope, refreshToken, idTokenPreProcessing, executionContext);
            }
            if (gt == GrantType.CLIENT_CREDENTIALS) {
                return this.processClientGredentials(scope, request, auditLog, client, idTokenPreProcessing, executionContext);
            }
            if (gt == GrantType.RESOURCE_OWNER_PASSWORD_CREDENTIALS) {
                return this.processROPC(username, password, scope, gt, idTokenPreProcessing, executionContext);
            }
            if (gt == GrantType.CIBA) {
                return this.processCIBA(scope, authReqId, idTokenPreProcessing, executionContext);
            }
            if (gt == GrantType.DEVICE_CODE) {
                return this.processDeviceCodeGrantType(executionContext, deviceCode, scope);
            }
            if (gt == GrantType.TOKEN_EXCHANGE) {
                if (this.txTokenService.isTxTokenFlow(request)) {
                    return this.txTokenService.processTxToken(executionContext);
                }
                JSONObject responseJson = this.tokenExchangeService.processTokenExchange(scope, idTokenPreProcessing, executionContext);
                return this.response(Response.ok().entity((Object)responseJson.toString()), auditLog);
            }
            if (gt == GrantType.JWT_BEARER) {
                JSONObject responseJson = this.jwtGrantService.processJwtBearer(assertion, scope, request, client, idTokenPreProcessing, executionContext);
                return this.response(Response.ok().entity((Object)responseJson.toString()), auditLog);
            }
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return this.response(Response.status((int)500), auditLog);
        }
        throw new WebApplicationException(this.tokenRestWebServiceValidator.error(400, TokenErrorResponseType.UNSUPPORTED_GRANT_TYPE, "Unsupported Grant Type.").build());
    }

    private Response processROPC(String username, String password, String scope, GrantType gt, java.util.function.Function<JsonWebResponse, Void> idTokenPreProcessing, ExecutionContext executionContext) throws SearchException {
        String userDn;
        boolean authenticated = false;
        User user = null;
        if (this.authenticationFilterService.isEnabled() && StringHelper.isNotEmpty((String)(userDn = this.authenticationFilterService.processAuthenticationFilters(executionContext.getHttpRequest().getParameterMap())))) {
            user = this.userService.getUserByDn(userDn, new String[0]);
            authenticated = true;
        }
        if (!authenticated) {
            user = this.authenticateUser(username, password, executionContext, user);
        }
        this.tokenRestWebServiceValidator.validateUser(user, executionContext.getAuditLog());
        ResourceOwnerPasswordCredentialsGrant resourceOwnerPasswordCredentialsGrant = this.authorizationGrantList.createResourceOwnerPasswordCredentialsGrant(user, executionContext.getClient());
        executionContext.setGrant(resourceOwnerPasswordCredentialsGrant);
        SessionId sessionId = this.identity.getSessionId();
        if (sessionId != null) {
            resourceOwnerPasswordCredentialsGrant.setAcrValues("simple_password_auth");
            resourceOwnerPasswordCredentialsGrant.setSessionDn(sessionId.getDn());
            resourceOwnerPasswordCredentialsGrant.save();
            sessionId.getSessionAttributes().put("authorized_grant", gt.getValue());
            boolean updateResult = this.sessionIdService.updateSessionId(sessionId, false, true, true);
            if (!updateResult) {
                this.log.debug("Failed to update session entry: '{}'", (Object)sessionId.getId());
            }
        }
        RefreshToken reToken = this.tokenCreatorService.createRefreshToken(executionContext, scope);
        scope = resourceOwnerPasswordCredentialsGrant.checkScopesPolicy(scope);
        AuthzDetails checkedAuthzDetails = this.authzDetailsService.checkAuthzDetailsAndSave(executionContext.getAuthzDetails(), resourceOwnerPasswordCredentialsGrant);
        AccessToken accessToken = resourceOwnerPasswordCredentialsGrant.createAccessToken(executionContext);
        IdToken idToken = null;
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getOpenidScopeBackwardCompatibility()) && resourceOwnerPasswordCredentialsGrant.getScopes().contains("openid")) {
            boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
            ExternalUpdateTokenContext context = new ExternalUpdateTokenContext(executionContext.getHttpRequest(), resourceOwnerPasswordCredentialsGrant, executionContext.getClient(), this.appConfiguration, this.attributeService);
            context.setExecutionContext(executionContext);
            executionContext.setIncludeIdTokenClaims(includeIdTokenClaims);
            executionContext.setPreProcessing(idTokenPreProcessing);
            executionContext.setPostProcessor(this.externalUpdateTokenService.buildModifyIdTokenProcessor(context));
            idToken = resourceOwnerPasswordCredentialsGrant.createIdToken(null, null, null, null, null, executionContext);
        }
        executionContext.getAuditLog().updateOAuth2AuditLog(resourceOwnerPasswordCredentialsGrant, true);
        return this.response(Response.ok().entity((Object)this.getJSonResponse(accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), reToken, scope, idToken, checkedAuthzDetails)), executionContext.getAuditLog());
    }

    private Response processClientGredentials(String scope, HttpServletRequest request, OAuth2AuditLog auditLog, Client client, java.util.function.Function<JsonWebResponse, Void> idTokenPreProcessing, ExecutionContext executionContext) {
        ClientCredentialsGrant clientCredentialsGrant = this.authorizationGrantList.createClientCredentialsGrant(new User(), client);
        scope = clientCredentialsGrant.checkScopesPolicy(scope);
        AuthzDetails checkedAuthzDetails = this.authzDetailsService.checkAuthzDetailsAndSave(executionContext.getAuthzDetails(), clientCredentialsGrant);
        executionContext.setGrant(clientCredentialsGrant);
        AccessToken accessToken = clientCredentialsGrant.createAccessToken(executionContext);
        IdToken idToken = null;
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getOpenidScopeBackwardCompatibility()) && clientCredentialsGrant.getScopes().contains("openid")) {
            boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
            ExternalUpdateTokenContext context = new ExternalUpdateTokenContext(request, clientCredentialsGrant, client, this.appConfiguration, this.attributeService);
            executionContext.setIncludeIdTokenClaims(includeIdTokenClaims);
            executionContext.setPreProcessing(idTokenPreProcessing);
            executionContext.setPostProcessor(this.externalUpdateTokenService.buildModifyIdTokenProcessor(context));
            idToken = clientCredentialsGrant.createIdToken(null, null, null, null, null, executionContext);
        }
        auditLog.updateOAuth2AuditLog(clientCredentialsGrant, true);
        return this.response(Response.ok().entity((Object)this.getJSonResponse(accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), null, scope, idToken, checkedAuthzDetails)), auditLog);
    }

    private Response processRefreshTokenGrant(String scope, String refreshToken, java.util.function.Function<JsonWebResponse, Void> idTokenPreProcessing, ExecutionContext executionContext) {
        TokenEntity lockedRefreshToken;
        Client client = executionContext.getClient();
        OAuth2AuditLog auditLog = executionContext.getAuditLog();
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByRefreshToken(client.getClientId(), refreshToken);
        this.tokenRestWebServiceValidator.validateGrant(authorizationGrant, client, refreshToken, auditLog);
        RefreshToken refreshTokenObject = authorizationGrant.getRefreshToken(refreshToken);
        this.tokenRestWebServiceValidator.validateRefreshToken(refreshTokenObject, auditLog);
        executionContext.setGrant(authorizationGrant);
        RefreshToken reToken = null;
        if (BooleanUtils.isFalse((Boolean)this.appConfiguration.getSkipRefreshTokenDuringRefreshing())) {
            if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getRefreshTokenExtendLifetimeOnRotation())) {
                reToken = this.tokenCreatorService.createRefreshToken(executionContext, scope);
            } else {
                this.log.trace("Create refresh token with fixed (not extended) lifetime taken from previous refresh token.");
                reToken = authorizationGrant.createRefreshToken(executionContext, refreshTokenObject.getExpirationDate());
            }
        }
        authorizationGrant.checkScopesPolicy(scope);
        scope = authorizationGrant.getScopesAsString();
        AuthzDetails checkedAuthzDetails = this.authzDetailsService.checkAuthzDetailsAndSave(executionContext.getAuthzDetails(), authorizationGrant);
        AccessToken accToken = authorizationGrant.createAccessToken(executionContext);
        IdToken idToken = null;
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getOpenidScopeBackwardCompatibility()) && authorizationGrant.getScopes().contains("openid")) {
            boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
            ExternalUpdateTokenContext context = new ExternalUpdateTokenContext(executionContext.getHttpRequest(), authorizationGrant, client, this.appConfiguration, this.attributeService);
            context.setExecutionContext(executionContext);
            executionContext.setIncludeIdTokenClaims(includeIdTokenClaims);
            executionContext.setPreProcessing(idTokenPreProcessing);
            executionContext.setPostProcessor(this.externalUpdateTokenService.buildModifyIdTokenProcessor(context));
            idToken = authorizationGrant.createIdToken(null, null, accToken, null, null, executionContext);
        }
        if ((lockedRefreshToken = this.lockAndRemoveRefreshToken(refreshToken)) == null) {
            this.log.trace("Failed to lock refresh token {}", (Object)refreshToken);
            return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "Failed to lock refresh token."), auditLog);
        }
        this.tokenExchangeService.rotateDeviceSecretOnRefreshToken(executionContext.getHttpRequest(), authorizationGrant, scope);
        this.statService.reportActiveUser(authorizationGrant.getUserId());
        auditLog.updateOAuth2AuditLog(authorizationGrant, true);
        String entity = this.getJSonResponse(accToken, accToken.getTokenType(), accToken.getExpiresIn(), reToken, scope, idToken, checkedAuthzDetails);
        return this.response(Response.ok().entity((Object)entity), auditLog);
    }

    /*
     * Exception decompiling
     */
    private TokenEntity lockAndRemoveRefreshToken(String refreshTokenCode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Response processAuthorizationCode(String code, String scope, String codeVerifier, SessionId sessionIdObj, String redirectUri, ExecutionContext executionContext) {
        Client client = executionContext.getClient();
        this.log.debug("Attempting to find authorizationCodeGrant by clientId: '{}', code: '{}'", (Object)client.getClientId(), (Object)code);
        AuthorizationCodeGrant authorizationCodeGrant = this.authorizationGrantList.getAuthorizationCodeGrant(code);
        executionContext.setGrant(authorizationCodeGrant);
        this.log.trace("AuthorizationCodeGrant : '{}'", (Object)authorizationCodeGrant);
        this.tokenRestWebServiceValidator.validateGrant(authorizationCodeGrant, client, code, executionContext.getAuditLog(), grant -> this.grantService.removeAllByAuthorizationCode(code));
        if (!authorizationCodeGrant.isAuthorizationChallenge()) {
            this.tokenRestWebServiceValidator.validateRedirectUri(redirectUri, executionContext.getAuditLog());
        }
        this.tokenRestWebServiceValidator.validatePKCE(authorizationCodeGrant, codeVerifier, executionContext.getAuditLog(), client);
        this.dPoPService.validateDpopThumprint(authorizationCodeGrant.getDpopJkt(), executionContext.getDpop());
        authorizationCodeGrant.setIsCachedWithNoPersistence(false);
        authorizationCodeGrant.save();
        RefreshToken reToken = this.tokenCreatorService.createRefreshToken(executionContext, scope);
        scope = authorizationCodeGrant.checkScopesPolicy(scope);
        AuthzDetails checkedAuthzDetails = this.authzDetailsService.checkAuthzDetailsAndSave(executionContext.getAuthzDetails(), authorizationCodeGrant);
        AccessToken accToken = authorizationCodeGrant.createAccessToken(executionContext);
        String deviceSecret = this.tokenExchangeService.createNewDeviceSecret(authorizationCodeGrant.getSessionDn(), client, authorizationCodeGrant.getScopesAsString());
        IdToken idToken = null;
        if (authorizationCodeGrant.getScopes().contains("openid")) {
            String nonce = authorizationCodeGrant.getNonce();
            boolean includeIdTokenClaims = Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims());
            String idTokenTokenBindingCnf = client.getIdTokenTokenBindingCnf();
            java.util.function.Function<JsonWebResponse, Void> authorizationCodePreProcessing = jsonWebResponse -> {
                if (StringUtils.isNotBlank((CharSequence)idTokenTokenBindingCnf) && StringUtils.isNotBlank((CharSequence)authorizationCodeGrant.getTokenBindingHash())) {
                    TokenBindingMessage.setCnfClaim((JsonWebResponse)jsonWebResponse, (String)authorizationCodeGrant.getTokenBindingHash(), (String)idTokenTokenBindingCnf);
                }
                return null;
            };
            ExternalUpdateTokenContext context = new ExternalUpdateTokenContext(executionContext.getHttpRequest(), authorizationCodeGrant, client, this.appConfiguration, this.attributeService);
            executionContext.setDeviceSecret(deviceSecret);
            executionContext.setIncludeIdTokenClaims(includeIdTokenClaims);
            executionContext.setPreProcessing(JwrService.wrapWithSidFunction(authorizationCodePreProcessing, sessionIdObj != null ? sessionIdObj.getOutsideSid() : null));
            executionContext.setPostProcessor(this.externalUpdateTokenService.buildModifyIdTokenProcessor(context));
            idToken = authorizationCodeGrant.createIdToken(nonce, authorizationCodeGrant.getAuthorizationCode(), accToken, null, null, executionContext);
        }
        executionContext.getAuditLog().updateOAuth2AuditLog(authorizationCodeGrant, true);
        this.grantService.removeAuthorizationCode(authorizationCodeGrant.getAuthorizationCode().getCode());
        JSONObject jsonObj = new JSONObject();
        try {
            TokenRestWebServiceImpl.fillJsonObject(jsonObj, accToken, accToken.getTokenType(), accToken.getExpiresIn(), reToken, scope, idToken, checkedAuthzDetails);
            if (StringUtils.isNotBlank((CharSequence)deviceSecret)) {
                jsonObj.put("device_token", (Object)deviceSecret);
            }
        }
        catch (JSONException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return this.response(Response.ok().entity((Object)jsonObj.toString()), executionContext.getAuditLog());
    }

    @Nullable
    private Client getClient() {
        SessionClient sessionClient = this.identity.getSessionClient();
        Client client = null;
        if (sessionClient != null) {
            client = sessionClient.getClient();
            this.log.debug("Get sessionClient: '{}'", (Object)sessionClient);
        }
        return client;
    }

    private User authenticateUser(String username, String password, ExecutionContext executionContext, User user) {
        if (this.externalResourceOwnerPasswordCredentialsService.isEnabled()) {
            ExternalResourceOwnerPasswordCredentialsContext context = new ExternalResourceOwnerPasswordCredentialsContext(executionContext);
            context.setUser(user);
            if (this.externalResourceOwnerPasswordCredentialsService.executeExternalAuthenticate(context)) {
                this.log.trace("RO PC - User is authenticated successfully by external script.");
                user = context.getUser();
            }
        } else {
            try {
                boolean authenticated = this.authenticationService.authenticate(username, password);
                if (authenticated) {
                    user = this.authenticationService.getAuthenticatedUser();
                }
            }
            catch (AuthenticationException ex) {
                this.log.trace("Failed to authenticate user ", (Throwable)new RuntimeException("User name or password is invalid"));
            }
        }
        return user;
    }

    private Response processDeviceCodeGrantType(ExecutionContext executionContext, String deviceCode, String scope) {
        this.log.debug("Attempting to find authorizationGrant by deviceCode: '{}'", (Object)deviceCode);
        Client client = executionContext.getClient();
        DeviceCodeGrant deviceCodeGrant = this.authorizationGrantList.getDeviceCodeGrant(deviceCode);
        executionContext.setGrant(deviceCodeGrant);
        this.log.trace("DeviceCodeGrant : '{}'", (Object)deviceCodeGrant);
        if (deviceCodeGrant != null) {
            if (!deviceCodeGrant.getClientId().equals(client.getClientId())) {
                throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "The client is not authorized."), executionContext.getAuditLog()));
            }
            RefreshToken refToken = this.tokenCreatorService.createRefreshToken(executionContext, scope);
            AccessToken accessToken = deviceCodeGrant.createAccessToken(executionContext);
            ExternalUpdateTokenContext context = new ExternalUpdateTokenContext(executionContext.getHttpRequest(), deviceCodeGrant, client, this.appConfiguration, this.attributeService);
            context.setExecutionContext(executionContext);
            executionContext.setIncludeIdTokenClaims(Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims()));
            executionContext.setPreProcessing(null);
            executionContext.setPostProcessor(this.externalUpdateTokenService.buildModifyIdTokenProcessor(context));
            IdToken idToken = deviceCodeGrant.createIdToken(null, null, accessToken, refToken, null, executionContext);
            deviceCodeGrant.checkScopesPolicy(scope);
            AuthzDetails checkedAuthzDetails = this.authzDetailsService.checkAuthzDetailsAndSave(executionContext.getAuthzDetails(), deviceCodeGrant);
            this.log.info("Device authorization in token endpoint processed and return to the client, device_code: {}", (Object)deviceCodeGrant.getDeviceCode());
            executionContext.getAuditLog().updateOAuth2AuditLog(deviceCodeGrant, true);
            this.grantService.removeByCode(deviceCodeGrant.getDeviceCode());
            return Response.ok().entity((Object)this.getJSonResponse(accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), refToken, scope, idToken, checkedAuthzDetails)).build();
        }
        DeviceAuthorizationCacheControl cacheData = this.deviceAuthorizationService.getDeviceAuthzByDeviceCode(deviceCode);
        this.log.trace("DeviceAuthorizationCacheControl data : '{}'", (Object)cacheData);
        this.tokenRestWebServiceValidator.validateDeviceAuthorization(client, deviceCode, cacheData, executionContext.getAuditLog());
        long currentTime = new Date().getTime();
        Long lastAccess = cacheData.getLastAccessControl();
        if (lastAccess == null) {
            lastAccess = currentTime;
        }
        cacheData.setLastAccessControl(currentTime);
        this.deviceAuthorizationService.saveInCache(cacheData, true, true);
        if (cacheData.getStatus() == DeviceAuthorizationStatus.PENDING) {
            int intervalSeconds = this.appConfiguration.getBackchannelAuthenticationResponseInterval();
            long timeFromLastAccess = currentTime - lastAccess;
            if (timeFromLastAccess > (long)(intervalSeconds * 1000)) {
                this.log.debug("Access hasn't been granted yet for deviceCode: '{}'", (Object)deviceCode);
                throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.AUTHORIZATION_PENDING, "User hasn't answered yet"), executionContext.getAuditLog()));
            }
            this.log.debug("Slow down protection deviceCode: '{}'", (Object)deviceCode);
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.SLOW_DOWN, "Client is asking too fast the token."), executionContext.getAuditLog()));
        }
        if (cacheData.getStatus() == DeviceAuthorizationStatus.DENIED) {
            this.log.debug("The end-user denied the authorization request for deviceCode: '{}'", (Object)deviceCode);
            throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.ACCESS_DENIED, "The end-user denied the authorization request."), executionContext.getAuditLog()));
        }
        this.log.debug("The authentication request has expired for deviceCode: '{}'", (Object)deviceCode);
        throw new WebApplicationException(this.response(this.error(400, TokenErrorResponseType.EXPIRED_TOKEN, "The authentication request has expired"), executionContext.getAuditLog()));
    }

    private Response response(Response.ResponseBuilder builder, OAuth2AuditLog oAuth2AuditLog) {
        builder.cacheControl(ServerUtil.cacheControl(true, false));
        builder.header("Pragma", (Object)"no-cache");
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }

    private Response.ResponseBuilder error(int status, TokenErrorResponseType type, String reason) {
        return Response.status((int)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)type, reason));
    }

    public String getJSonResponse(AccessToken accessToken, TokenType tokenType, Integer expiresIn, RefreshToken refreshToken, String scope, IdToken idToken, AuthzDetails checkedAuthzDetails) {
        JSONObject jsonObj = new JSONObject();
        try {
            TokenRestWebServiceImpl.fillJsonObject(jsonObj, accessToken, tokenType, expiresIn, refreshToken, scope, idToken, checkedAuthzDetails);
            TokenRestWebServiceImpl.addRefreshTokenLifetime(jsonObj, refreshToken, this.appConfiguration.getIncludeRefreshTokenLifetimeInTokenResponse());
        }
        catch (JSONException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return jsonObj.toString();
    }

    public static void addRefreshTokenLifetime(JSONObject jsonObj, RefreshToken refreshToken, boolean includeRefreshTokenLifetimeInResponse) {
        if (refreshToken != null && includeRefreshTokenLifetimeInResponse) {
            jsonObj.put("refresh_token_expires_in", refreshToken.getExpiresIn());
        }
    }

    public static void fillJsonObject(JSONObject jsonObj, AccessToken accessToken, TokenType tokenType, Integer expiresIn, RefreshToken refreshToken, String scope, IdToken idToken, AuthzDetails checkedAuthzDetails) {
        jsonObj.put("access_token", (Object)accessToken.getCode());
        jsonObj.put("token_type", (Object)tokenType.toString());
        if (expiresIn != null) {
            jsonObj.put("expires_in", (Object)expiresIn);
        }
        if (refreshToken != null) {
            jsonObj.put("refresh_token", (Object)refreshToken.getCode());
        }
        if (scope != null) {
            jsonObj.put("scope", (Object)scope);
        }
        if (idToken != null) {
            jsonObj.put("id_token", (Object)idToken.getCode());
        }
        if (checkedAuthzDetails != null && checkedAuthzDetails.getDetails() != null && !checkedAuthzDetails.getDetails().isEmpty()) {
            jsonObj.put("authorization_details", (Object)checkedAuthzDetails.asJsonArray());
        }
    }

    private Response processCIBA(String scope, String authReqId, java.util.function.Function<JsonWebResponse, Void> idTokenPreProcessing, ExecutionContext executionContext) {
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.CIBA);
        this.log.debug("Attempting to find authorizationGrant by authReqId: '{}'", (Object)authReqId);
        CIBAGrant cibaGrant = this.authorizationGrantList.getCIBAGrant(authReqId);
        executionContext.setGrant(cibaGrant);
        this.log.trace("AuthorizationGrant : '{}'", (Object)cibaGrant);
        Client client = executionContext.getClient();
        if (cibaGrant != null) {
            this.tokenRestWebServiceValidator.validateGrant(cibaGrant, client, authReqId, executionContext.getAuditLog());
            if (cibaGrant.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.PING || cibaGrant.getClient().getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.POLL) {
                if (!cibaGrant.isTokensDelivered()) {
                    RefreshToken refToken = this.tokenCreatorService.createRefreshToken(executionContext, scope);
                    AccessToken accessToken = cibaGrant.createAccessToken(executionContext);
                    ExternalUpdateTokenContext context = new ExternalUpdateTokenContext(executionContext.getHttpRequest(), cibaGrant, client, this.appConfiguration, this.attributeService);
                    context.setExecutionContext(executionContext);
                    executionContext.setIncludeIdTokenClaims(Boolean.TRUE.equals(this.appConfiguration.getLegacyIdTokenClaims()));
                    executionContext.setPreProcessing(idTokenPreProcessing);
                    executionContext.setPostProcessor(this.externalUpdateTokenService.buildModifyIdTokenProcessor(context));
                    IdToken idToken = cibaGrant.createIdToken(null, null, accessToken, refToken, null, executionContext);
                    cibaGrant.setTokensDelivered(true);
                    cibaGrant.save();
                    RefreshToken reToken = null;
                    if (this.tokenCreatorService.isRefreshTokenAllowed(client, scope, cibaGrant)) {
                        reToken = refToken;
                    }
                    scope = cibaGrant.checkScopesPolicy(scope);
                    AuthzDetails checkedAuthzDetails = this.authzDetailsService.checkAuthzDetailsAndSave(executionContext.getAuthzDetails(), cibaGrant);
                    executionContext.getAuditLog().updateOAuth2AuditLog(cibaGrant, true);
                    return this.response(Response.ok().entity((Object)this.getJSonResponse(accessToken, accessToken.getTokenType(), accessToken.getExpiresIn(), reToken, scope, idToken, checkedAuthzDetails)), executionContext.getAuditLog());
                }
                return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "AuthReqId is no longer available."), executionContext.getAuditLog());
            }
            this.log.debug("Client is not using Poll flow authReqId: '{}'", (Object)authReqId);
            return this.response(this.error(400, TokenErrorResponseType.UNAUTHORIZED_CLIENT, "The client is not authorized as it is configured in Push Mode"), executionContext.getAuditLog());
        }
        return this.processCIBAIfGrantIsNull(authReqId, executionContext);
    }

    private Response processCIBAIfGrantIsNull(String authReqId, ExecutionContext executionContext) {
        CibaRequestCacheControl cibaRequest = this.cibaRequestService.getCibaRequest(authReqId);
        this.log.trace("Ciba request : '{}'", (Object)cibaRequest);
        if (cibaRequest != null) {
            if (!cibaRequest.getClient().getClientId().equals(executionContext.getClient().getClientId())) {
                return this.response(this.error(400, TokenErrorResponseType.INVALID_GRANT, "The client is not authorized."), executionContext.getAuditLog());
            }
            long currentTime = new Date().getTime();
            Long lastAccess = cibaRequest.getLastAccessControl();
            if (lastAccess == null) {
                lastAccess = currentTime;
            }
            cibaRequest.setLastAccessControl(currentTime);
            this.cibaRequestService.update(cibaRequest);
            if (cibaRequest.getStatus() == CibaRequestStatus.PENDING) {
                int intervalSeconds = this.appConfiguration.getBackchannelAuthenticationResponseInterval();
                long timeFromLastAccess = currentTime - lastAccess;
                if (timeFromLastAccess > (long)(intervalSeconds * 1000)) {
                    this.log.debug("Access hasn't been granted yet for authReqId: '{}'", (Object)authReqId);
                    return this.response(this.error(400, TokenErrorResponseType.AUTHORIZATION_PENDING, "User hasn't answered yet"), executionContext.getAuditLog());
                }
                this.log.debug("Slow down protection authReqId: '{}'", (Object)authReqId);
                return this.response(this.error(400, TokenErrorResponseType.SLOW_DOWN, "Client is asking too fast the token."), executionContext.getAuditLog());
            }
            if (cibaRequest.getStatus() == CibaRequestStatus.DENIED) {
                this.log.debug("The end-user denied the authorization request for authReqId: '{}'", (Object)authReqId);
                return this.response(this.error(400, TokenErrorResponseType.ACCESS_DENIED, "The end-user denied the authorization request."), executionContext.getAuditLog());
            }
            if (cibaRequest.getStatus() == CibaRequestStatus.EXPIRED) {
                this.log.debug("The authentication request has expired for authReqId: '{}'", (Object)authReqId);
                return this.response(this.error(400, TokenErrorResponseType.EXPIRED_TOKEN, "The authentication request has expired"), executionContext.getAuditLog());
            }
        } else {
            this.log.debug("AuthorizationGrant is empty by authReqId: '{}'", (Object)authReqId);
            return this.response(this.error(400, TokenErrorResponseType.EXPIRED_TOKEN, "Unable to find grant object for given auth_req_id."), executionContext.getAuditLog());
        }
        return this.response(this.error(400, TokenErrorResponseType.EXPIRED_TOKEN, "Unable to find grant object for given auth_req_id."), executionContext.getAuditLog());
    }
}

