/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.uma.authorization;

import io.jans.as.model.jwt.Jwt;
import io.jans.as.server.uma.authorization.UmaPCT;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class Claims {
    private final Jwt claimsToken;
    private final String claimsTokenAsString;
    private final UmaPCT pct;
    private final Map<String, Object> claimMap = new ConcurrentHashMap<String, Object>();

    public Claims(Jwt claimsToken, UmaPCT pct, String claimsTokenAsString) {
        this.claimsToken = claimsToken;
        this.pct = pct;
        this.claimsTokenAsString = claimsTokenAsString;
    }

    public String getClaimsTokenAsString() {
        return this.claimsTokenAsString;
    }

    public Set<String> keys() {
        return this.claimMap.keySet();
    }

    public Object get(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        if (this.claimMap.containsKey(key)) {
            return this.claimMap.get(key);
        }
        if (this.claimsToken != null && this.claimsToken.getClaims() != null && this.claimsToken.getClaims().hasClaim(key)) {
            return this.claimsToken.getClaims().getClaim(key);
        }
        if (this.pct != null && this.pct.getClaims() != null && this.pct.getClaims().hasClaim(key)) {
            return this.pct.getClaims().getClaim(key);
        }
        return null;
    }

    public Object getClaimTokenClaim(String key) {
        if (this.claimsToken != null && this.claimsToken.getClaims() != null && this.claimsToken.getClaims().hasClaim(key)) {
            return this.claimsToken.getClaims().getClaim(key);
        }
        return null;
    }

    public Object getPctClaim(String key) {
        if (this.pct != null && this.pct.getClaims() != null && this.pct.getClaims().hasClaim(key)) {
            return this.pct.getClaims().getClaim(key);
        }
        return null;
    }

    public boolean has(String key) {
        return this.get(key) != null;
    }

    public void put(String key, Object value) {
        this.claimMap.put(key, value);
    }

    public void removeClaim(String key) {
        this.claimMap.remove(key);
    }
}

