/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.uma.authorization;

import io.jans.as.model.error.DefaultErrorResponse;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.uma.UmaErrorResponseType;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URLEncoder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmaWebException
extends WebApplicationException {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmaWebException.class);

    private UmaWebException() {
    }

    public UmaWebException(String redirectUri, ErrorResponseFactory factory, UmaErrorResponseType error, String state) {
        super(UmaWebException.createRedirectErrorResponse(redirectUri, factory, error, state));
    }

    public static Response createRedirectErrorResponse(String redirectUri, ErrorResponseFactory factory, UmaErrorResponseType errorType, String state) {
        return Response.status((Response.Status)Response.Status.FOUND).location(UmaWebException.createErrorUri(redirectUri, factory, errorType, state)).build();
    }

    public static URI createErrorUri(String redirectUri, ErrorResponseFactory factory, UmaErrorResponseType errorType, String state) {
        try {
            DefaultErrorResponse error = factory.getErrorResponse((IErrorType)errorType);
            redirectUri = ((String)redirectUri).contains("?") ? (String)redirectUri + "&" : (String)redirectUri + "?";
            redirectUri = (String)redirectUri + "error=" + error.getErrorCode();
            redirectUri = (String)redirectUri + "&error_description=" + URLEncoder.encode(error.getErrorDescription(), "UTF-8");
            if (StringUtils.isNotBlank((CharSequence)error.getErrorUri())) {
                redirectUri = (String)redirectUri + "&error_uri=" + URLEncoder.encode(error.getErrorUri(), "UTF-8");
            }
            if (StringUtils.isNotBlank((CharSequence)state)) {
                redirectUri = (String)redirectUri + "&state=" + state;
            }
            return new URI((String)redirectUri);
        }
        catch (Exception e) {
            LOGGER.error("Failed to construct uri: " + (String)redirectUri, (Throwable)e);
            throw factory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)UmaErrorResponseType.SERVER_ERROR, "Failed to construct uri");
        }
    }
}

