/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.uma.service;

import io.jans.as.model.config.StaticConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.uma.UmaPermission;
import io.jans.as.model.uma.UmaPermissionList;
import io.jans.as.model.util.Pair;
import io.jans.as.server.uma.service.UmaScopeService;
import io.jans.orm.PersistenceEntryManager;
import io.jans.orm.model.base.SimpleBranch;
import io.jans.orm.search.filter.Filter;
import io.jans.util.INumGenerator;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Stateless
@Named
public class UmaPermissionService {
    private static final String ORGUNIT_OF_RESOURCE_PERMISSION = "uma_permission";
    private static final int DEFAULT_TICKET_LIFETIME = 3600;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;
    @Inject
    private StaticConfiguration staticConfiguration;
    @Inject
    private UmaScopeService scopeService;
    @Inject
    private AppConfiguration appConfiguration;

    public static String getDn(String clientDn, String ticket) {
        return String.format("jansTicket=%s,%s", ticket, UmaPermissionService.getBranchDn(clientDn));
    }

    public static String getBranchDn(String clientDn) {
        return String.format("ou=%s,%s", ORGUNIT_OF_RESOURCE_PERMISSION, clientDn);
    }

    private List<io.jans.as.model.uma.persistence.UmaPermission> createPermissions(UmaPermissionList permissions, Pair<Date, Integer> expirationDate) {
        String configurationCode = INumGenerator.generate((int)8) + "." + System.currentTimeMillis();
        String ticket = this.generateNewTicket();
        ArrayList<io.jans.as.model.uma.persistence.UmaPermission> result = new ArrayList<io.jans.as.model.uma.persistence.UmaPermission>();
        for (UmaPermission permission : permissions) {
            io.jans.as.model.uma.persistence.UmaPermission p = new io.jans.as.model.uma.persistence.UmaPermission(permission.getResourceId(), this.scopeService.getScopeDNsByIdsAndAddToPersistenceIfNeeded(permission.getScopes()), ticket, configurationCode, expirationDate);
            if (permission.getParams() != null && !permission.getParams().isEmpty()) {
                p.getAttributes().putAll(permission.getParams());
            }
            result.add(p);
        }
        return result;
    }

    public String generateNewTicket() {
        return UUID.randomUUID().toString();
    }

    public String addPermission(UmaPermissionList permissionList, String clientDn) {
        try {
            List<io.jans.as.model.uma.persistence.UmaPermission> created = this.createPermissions(permissionList, this.ticketExpirationDate());
            for (io.jans.as.model.uma.persistence.UmaPermission permission : created) {
                this.addPermission(permission, clientDn);
            }
            return created.get(0).getTicket();
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            throw e;
        }
    }

    public Pair<Date, Integer> ticketExpirationDate() {
        int lifeTime = this.appConfiguration.getUmaTicketLifetime();
        if (lifeTime <= 0) {
            lifeTime = 3600;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, lifeTime);
        return new Pair((Object)calendar.getTime(), (Object)lifeTime);
    }

    public void addPermission(io.jans.as.model.uma.persistence.UmaPermission permission, String clientDn) {
        try {
            this.addBranchIfNeeded(clientDn);
            permission.setDn(UmaPermissionService.getDn(clientDn, permission.getTicket()));
            this.ldapEntryManager.persist((Object)permission);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void merge(io.jans.as.model.uma.persistence.UmaPermission permission) {
        permission.resetTtlFromExpirationDate();
        this.ldapEntryManager.merge((Object)permission);
    }

    public void mergeSilently(io.jans.as.model.uma.persistence.UmaPermission permission) {
        try {
            permission.resetTtlFromExpirationDate();
            this.ldapEntryManager.merge((Object)permission);
        }
        catch (Exception e) {
            this.log.error("Failed to persist permission: " + permission, (Throwable)e);
        }
    }

    public List<io.jans.as.model.uma.persistence.UmaPermission> getPermissionsByTicket(String ticket) {
        try {
            String baseDn = this.staticConfiguration.getBaseDn().getClients();
            Filter filter = Filter.createEqualityFilter((String)"jansTicket", (Object)ticket);
            return this.ldapEntryManager.findEntries(baseDn, io.jans.as.model.uma.persistence.UmaPermission.class, filter);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void deletePermission(String ticket) {
        try {
            List<io.jans.as.model.uma.persistence.UmaPermission> permissions = this.getPermissionsByTicket(ticket);
            for (io.jans.as.model.uma.persistence.UmaPermission p : permissions) {
                this.ldapEntryManager.remove((Object)p);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addBranch(String clientDn) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName(ORGUNIT_OF_RESOURCE_PERMISSION);
        branch.setDn(UmaPermissionService.getBranchDn(clientDn));
        this.ldapEntryManager.persist((Object)branch);
    }

    public void addBranchIfNeeded(String clientDn) {
        if (this.ldapEntryManager.hasBranchesSupport(clientDn) && !this.containsBranch(clientDn)) {
            this.addBranch(clientDn);
        }
    }

    public boolean containsBranch(String clientDn) {
        return this.ldapEntryManager.contains(UmaPermissionService.getBranchDn(clientDn), SimpleBranch.class);
    }

    public String changeTicket(List<io.jans.as.model.uma.persistence.UmaPermission> permissions, Map<String, String> attributes) {
        String newTicket = this.generateNewTicket();
        for (io.jans.as.model.uma.persistence.UmaPermission permission : permissions) {
            this.ldapEntryManager.remove((Object)permission);
            String dn = String.format("jansTicket=%s,%s", newTicket, StringUtils.substringAfter((String)permission.getDn(), (String)","));
            permission.setTicket(newTicket);
            permission.setDn(dn);
            permission.setAttributes(attributes);
            this.ldapEntryManager.persist((Object)permission);
            this.log.trace("New ticket: {}, old permission: {}", (Object)newTicket, (Object)dn);
        }
        return newTicket;
    }
}

