/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.audit;

import com.google.common.base.Objects;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.util.ServerUtil;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.ConfigurationUpdate;
import io.jans.util.StringHelper;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.ejb.DependsOn;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.pool.PooledConnectionFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;

@Named
@ApplicationScoped
@DependsOn(value={"appInitializer"})
public class ApplicationAuditLogger {
    private static final String BROKER_URL_PREFIX = "failover:(";
    private static final String BROKER_URL_SUFFIX = ")?timeout=5000&jms.useAsyncSend=true";
    private static final int ACK_MODE = 1;
    private static final String CLIENT_QUEUE_NAME = "oauth2.audit.logging";
    private static final boolean TRANSACTED = false;
    private final ReentrantLock lock = new ReentrantLock();
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    private final AtomicReference<PooledConnectionFactory> pooledConnectionFactory = new AtomicReference();
    private Set<String> jmsBrokerURISet;
    private String jmsUserName;
    private String jmsPassword;
    private boolean enabled;
    private boolean sendAuditJms;

    @PostConstruct
    public void init() {
        this.updateConfiguration(this.appConfiguration);
    }

    public void updateConfiguration(@Observes @ConfigurationUpdate AppConfiguration appConfiguration) {
        boolean configChanged;
        this.enabled = BooleanUtils.isTrue((Boolean)appConfiguration.getEnabledOAuthAuditLogging());
        this.sendAuditJms = StringHelper.isNotEmpty((String)appConfiguration.getJmsUserName()) && StringHelper.isNotEmpty((String)appConfiguration.getJmsPassword()) && CollectionUtils.isNotEmpty((Collection)appConfiguration.getJmsBrokerURISet());
        boolean bl = configChanged = !Objects.equal((Object)this.jmsUserName, (Object)appConfiguration.getJmsUserName()) || !Objects.equal((Object)this.jmsPassword, (Object)appConfiguration.getJmsPassword()) || !Objects.equal(this.jmsBrokerURISet, (Object)appConfiguration.getJmsBrokerURISet());
        if (configChanged) {
            this.destroy();
        }
    }

    @Asynchronous
    public void sendMessage(OAuth2AuditLog oAuth2AuditLog) {
        if (!this.enabled) {
            return;
        }
        boolean messageDelivered = false;
        if (this.sendAuditJms && this.tryToEstablishJMSConnection()) {
            messageDelivered = this.loggingThroughJMS(oAuth2AuditLog);
        }
        if (!messageDelivered) {
            this.loggingThroughFile(oAuth2AuditLog);
        }
    }

    @PreDestroy
    public void destroy() {
        if (this.pooledConnectionFactory.get() == null) {
            return;
        }
        ((PooledConnectionFactory)this.pooledConnectionFactory.getAndSet(null)).clear();
    }

    private boolean tryToEstablishJMSConnection() {
        if (this.pooledConnectionFactory.get() != null) {
            return true;
        }
        this.lock.lock();
        try {
            if (this.pooledConnectionFactory.get() == null) {
                boolean bl = this.tryToEstablishJMSConnectionImpl();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean tryToEstablishJMSConnectionImpl() {
        Set uriSet = this.appConfiguration.getJmsBrokerURISet();
        if (!this.enabled || CollectionUtils.isEmpty((Collection)uriSet)) {
            return false;
        }
        this.jmsBrokerURISet = new HashSet<String>(uriSet);
        this.jmsUserName = this.appConfiguration.getJmsUserName();
        this.jmsPassword = this.appConfiguration.getJmsPassword();
        Iterator jmsBrokerURIIterator = uriSet.iterator();
        StringBuilder uriBuilder = new StringBuilder();
        while (jmsBrokerURIIterator.hasNext()) {
            String jmsBrokerURI = (String)jmsBrokerURIIterator.next();
            uriBuilder.append("tcp://");
            uriBuilder.append(jmsBrokerURI);
            if (!jmsBrokerURIIterator.hasNext()) continue;
            uriBuilder.append(",");
        }
        String brokerUrl = BROKER_URL_PREFIX + uriBuilder + BROKER_URL_SUFFIX;
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.jmsUserName, this.jmsPassword, brokerUrl);
        PooledConnectionFactory pool = new PooledConnectionFactory(connectionFactory);
        pool.setIdleTimeout(5000);
        pool.setMaxConnections(10);
        pool.start();
        this.pooledConnectionFactory.set(pool);
        return true;
    }

    private boolean loggingThroughJMS(OAuth2AuditLog oAuth2AuditLog) {
        boolean bl;
        block21: {
            QueueConnection connection = this.pooledConnectionFactory.get().createQueueConnection();
            try {
                connection.start();
                try (QueueSession session = connection.createQueueSession(false, 1);
                     MessageProducer producer = session.createProducer((Destination)session.createQueue(CLIENT_QUEUE_NAME));){
                    TextMessage txtMessage = session.createTextMessage();
                    txtMessage.setText(ServerUtil.asPrettyJson(oAuth2AuditLog));
                    producer.send((Message)txtMessage);
                }
                bl = true;
                if (connection == null) break block21;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.log.error("Can't send message, please check your activeMQ configuration.", (Throwable)e);
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    private void loggingThroughFile(OAuth2AuditLog oAuth2AuditLog) {
        try {
            if (this.log.isInfoEnabled()) {
                this.log.info(ServerUtil.asPrettyJson(oAuth2AuditLog));
            }
        }
        catch (IOException e) {
            this.log.error("Can't serialize the audit log", (Throwable)e);
        }
    }
}

