/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.audit.debug.wrapper;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class RequestWrapper
extends HttpServletRequestWrapper {
    private final Map<String, String[]> parameterMap;
    private final HttpServletRequest delegate;
    private byte[] content;

    public RequestWrapper(HttpServletRequest request) {
        super(request);
        this.delegate = request;
        this.parameterMap = this.isFormPost() ? (request.getParameterMap() != null ? new HashMap(request.getParameterMap()) : Collections.emptyMap()) : Collections.emptyMap();
    }

    public Map<String, String[]> getParams() {
        if (ArrayUtils.isEmpty((byte[])this.content) || this.parameterMap.isEmpty()) {
            return this.delegate.getParameterMap();
        }
        return this.parameterMap;
    }

    public String getContent() {
        try {
            this.content = this.parameterMap.isEmpty() ? (ArrayUtils.isEmpty((byte[])this.content) ? IOUtils.toByteArray((InputStream)this.delegate.getInputStream()) : IOUtils.toByteArray((InputStream)((Object)new LoggingServletInputStream(this.content)))) : this.getContentFromParameterMap(this.parameterMap);
            String requestEncoding = this.delegate.getCharacterEncoding();
            String normalizedContent = StringUtils.normalizeSpace((String)new String(this.content, requestEncoding != null ? requestEncoding : StandardCharsets.UTF_8.name()));
            return StringUtils.isBlank((CharSequence)normalizedContent) ? null : normalizedContent;
        }
        catch (IOException e) {
            throw new IllegalStateException();
        }
    }

    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(0);
        Enumeration headerNames = this.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (headerName == null) continue;
            headers.put(headerName, this.getHeader(headerName));
        }
        return headers;
    }

    public Map<String, String> getParameters() {
        HashMap<String, String> params = new HashMap<String, String>();
        Iterator<Map.Entry<String, String[]>> iterator = this.getParams().entrySet().iterator();
        while (iterator.hasNext()) {
            String[] values;
            Map.Entry<String, String[]> entry;
            params.put(entry.getKey(), (values = (entry = iterator.next()).getValue()).length > 0 ? values[0] : null);
        }
        return params;
    }

    public boolean isFormPost() {
        String contentType = this.getContentType();
        return contentType != null && contentType.contains("application/x-www-form-urlencoded") && "POST".equalsIgnoreCase(this.getMethod());
    }

    private byte[] getContentFromParameterMap(Map<String, String[]> parameterMap) {
        StringBuilder sb = new StringBuilder();
        String ampersand = "&";
        Iterator<Map.Entry<String, String[]>> iterator = parameterMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Object[] value;
            Map.Entry<String, String[]> entry;
            sb.append(entry.getKey() + "=" + (String)((value = (entry = iterator.next()).getValue()).length == 1 ? value[0] : Arrays.toString(value)) + ampersand);
        }
        String params = sb.toString();
        return params.substring(0, params.length() - 1).getBytes();
    }

    private class LoggingServletInputStream
    extends ServletInputStream {
        private final InputStream is;

        private LoggingServletInputStream(byte[] content) {
            this.is = new ByteArrayInputStream(content);
        }

        public boolean isFinished() {
            return true;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public void close() throws IOException {
            super.close();
            this.is.close();
        }
    }
}

