/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authorize.ws.rs;

import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.common.model.session.SessionIdState;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.authzdetails.AuthzDetail;
import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.common.Prompt;
import io.jans.as.model.common.SubjectType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.util.Base64Util;
import io.jans.as.model.util.JwtUtil;
import io.jans.as.model.util.StringUtils;
import io.jans.as.model.util.Util;
import io.jans.as.persistence.model.ClientAuthorization;
import io.jans.as.persistence.model.Scope;
import io.jans.as.server.auth.Authenticator;
import io.jans.as.server.authorize.ws.rs.AuthorizeRestWebServiceValidator;
import io.jans.as.server.authorize.ws.rs.AuthzRequest;
import io.jans.as.server.authorize.ws.rs.ConsentGathererService;
import io.jans.as.server.i18n.LanguageBean;
import io.jans.as.server.model.auth.AuthenticationMode;
import io.jans.as.server.model.authorize.Claim;
import io.jans.as.server.model.authorize.JwtAuthorizationRequest;
import io.jans.as.server.model.authorize.ScopeChecker;
import io.jans.as.server.model.common.CibaRequestCacheControl;
import io.jans.as.server.model.common.DefaultScope;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.exception.AcrChangedException;
import io.jans.as.server.security.Identity;
import io.jans.as.server.service.AcrService;
import io.jans.as.server.service.AuthenticationService;
import io.jans.as.server.service.AuthorizeService;
import io.jans.as.server.service.ClientAuthorizationsService;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.CookieService;
import io.jans.as.server.service.ErrorHandlerService;
import io.jans.as.server.service.RedirectionUriService;
import io.jans.as.server.service.RequestParameterService;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.service.ciba.CibaRequestService;
import io.jans.as.server.service.external.ExternalAuthenticationService;
import io.jans.as.server.service.external.ExternalAuthzDetailTypeService;
import io.jans.as.server.service.external.ExternalConsentGatheringService;
import io.jans.as.server.service.external.ExternalPostAuthnService;
import io.jans.as.server.service.external.ExternalSelectAccountService;
import io.jans.as.server.service.external.context.ExternalPostAuthnContext;
import io.jans.jsf2.message.FacesMessages;
import io.jans.jsf2.service.FacesService;
import io.jans.model.AuthenticationScriptUsageType;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.orm.exception.EntryPersistenceException;
import io.jans.service.net.NetworkService;
import io.jans.util.StringHelper;
import io.jans.util.ilocale.LocaleUtil;
import jakarta.enterprise.context.RequestScoped;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;

@RequestScoped
@Named
public class AuthorizeAction {
    public static final String UNKNOWN = "Unknown";
    @Inject
    private Logger log;
    @Inject
    private ClientService clientService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private RedirectionUriService redirectionUriService;
    @Inject
    private ClientAuthorizationsService clientAuthorizationsService;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private ExternalConsentGatheringService externalConsentGatheringService;
    @Inject
    private ExternalSelectAccountService externalSelectAccountService;
    @Inject
    private AuthenticationMode defaultAuthenticationMode;
    @Inject
    private LanguageBean languageBean;
    @Inject
    private NetworkService networkService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private FacesService facesService;
    @Inject
    private FacesMessages facesMessages;
    @Inject
    private FacesContext facesContext;
    @Inject
    private ExternalContext externalContext;
    @Inject
    private ConsentGathererService consentGatherer;
    @Inject
    private AuthorizeService authorizeService;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private ScopeChecker scopeChecker;
    @Inject
    private ErrorHandlerService errorHandlerService;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private CookieService cookieService;
    @Inject
    private Authenticator authenticator;
    @Inject
    private AuthenticationService authenticationService;
    @Inject
    private ExternalPostAuthnService externalPostAuthnService;
    @Inject
    private CibaRequestService cibaRequestService;
    @Inject
    private Identity identity;
    @Inject
    private AuthorizeRestWebServiceValidator authorizeRestWebServiceValidator;
    @Inject
    private ExternalAuthzDetailTypeService externalAuthzDetailTypeService;
    private String scope;
    private String responseType;
    private String clientId;
    private String redirectUri;
    private String state;
    private String responseMode;
    private String nonce;
    private String display;
    private String prompt;
    private Integer maxAge;
    private String uiLocales;
    private String idTokenHint;
    private String loginHint;
    private String acrValues;
    private String amrValues;
    private String request;
    private String requestUri;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String authorizationDetails;
    private String claims;
    private String authReqId;
    private String sessionId;
    private String allowedScope;
    private AuthzDetails authzDetails;

    public void checkUiLocales() {
        List uiLocalesList = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.uiLocales)) {
            List<Locale> supportedLocales;
            uiLocalesList = Util.splittedStringAsList((String)this.uiLocales, (String)" ");
            Locale matchingLocale = LocaleUtil.localeMatch((List)uiLocalesList, supportedLocales = this.languageBean.getSupportedLocales());
            if (matchingLocale != null) {
                this.languageBean.setLocale(matchingLocale);
            }
        } else {
            Locale requestedLocale = this.facesContext.getExternalContext().getRequestLocale();
            if (requestedLocale != null) {
                this.languageBean.setLocale(requestedLocale);
                return;
            }
            Locale defaultLocale = this.facesContext.getApplication().getDefaultLocale();
            if (defaultLocale != null) {
                this.languageBean.setLocale(defaultLocale);
            }
        }
    }

    public void checkPermissionGranted() {
        try {
            this.log.trace("checkPermissionGranted clientId={}", (Object)this.clientId);
            this.checkPermissionGrantedInternal();
        }
        catch (Exception e) {
            this.log.error("Failed to perform checkPermissionGranted()", (Throwable)e);
            this.permissionDenied();
        }
    }

    public void checkPermissionGrantedInternal() throws IOException {
        if (this.clientId == null || this.clientId.isEmpty()) {
            this.log.debug("Permission denied. client_id should be not empty.");
            this.permissionDenied();
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("checkPermissionGrantedInternal - scope: {}, client_id: {}, prompts: {}, responseType: {}, authorization_details: {}", new Object[]{this.scope, this.clientId, this.prompt, this.responseType, this.authorizationDetails});
        }
        Client client = null;
        try {
            client = this.clientService.getClient(this.clientId);
        }
        catch (EntryPersistenceException ex) {
            this.log.debug("Permission denied. Failed to find client by inum '{}' in DB.", (Object)this.clientId, (Object)ex);
            this.permissionDenied();
            return;
        }
        if (client == null) {
            this.log.debug("Permission denied. Failed to find client_id '{}' in DB.", (Object)this.clientId);
            this.permissionDenied();
            return;
        }
        AuthzRequest authzRequest = new AuthzRequest();
        authzRequest.setHttpRequest((HttpServletRequest)this.externalContext.getRequest());
        authzRequest.setHttpResponse((HttpServletResponse)this.externalContext.getResponse());
        authzRequest.setClient(client);
        authzRequest.setAuthzDetailsString(this.authorizationDetails);
        authzRequest.setScope(this.scope);
        authzRequest.setPrompt(this.prompt);
        Set<String> grantedScopes = this.scopeChecker.checkScopesPolicy(client, this.scope);
        this.allowedScope = StringUtils.implode(grantedScopes, (String)" ");
        this.authzDetails = this.prepareAuthzDetails(this.authorizationDetails, authzRequest);
        SessionId session = this.getSession();
        List prompts = Prompt.fromString((String)this.prompt, (String)" ");
        try {
            this.redirectUri = this.authorizeRestWebServiceValidator.validateRedirectUri(client, this.redirectUri, this.state, session != null ? (String)session.getSessionAttributes().get("user_code") : null, (HttpServletRequest)this.externalContext.getRequest());
        }
        catch (WebApplicationException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.permissionDenied();
            return;
        }
        try {
            session = this.sessionIdService.assertAuthenticatedSessionCorrespondsToNewRequest(session, this.acrValues);
        }
        catch (AcrChangedException e) {
            this.log.debug("There is already existing session which has another acr then {}, session: {}", (Object)this.acrValues, (Object)session.getId());
            if (e.isForceReAuthentication()) {
                session = this.handleAcrChange(session, prompts);
            }
            this.log.error("ACR is changed, please provide a supported and enabled acr value");
            this.permissionDenied();
            return;
        }
        if (session == null || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)session.getUserDn()) || SessionIdState.AUTHENTICATED != session.getState()) {
            boolean enableRedirect;
            boolean persisted;
            Map parameterMap = this.externalContext.getRequestParameterMap();
            Map<String, String> requestParameterMap = this.requestParameterService.getAllowedParameters(parameterMap);
            String redirectTo = "/login.xhtml";
            requestParameterMap.put("acr", "simple_password_auth");
            List<String> acrValuesList = this.sessionIdService.acrValuesList(this.acrValues);
            boolean useExternalAuthenticator = this.externalAuthenticationService.isEnabled(AuthenticationScriptUsageType.INTERACTIVE);
            boolean skipScript = this.shouldSkipScript(acrValuesList);
            if (useExternalAuthenticator && !skipScript) {
                List<String> acrsToDetermineScript;
                CustomScriptConfiguration customScriptConfiguration;
                if (acrValuesList.isEmpty()) {
                    acrValuesList = Arrays.asList(this.defaultAuthenticationMode.getName());
                }
                if ((customScriptConfiguration = this.externalAuthenticationService.determineCustomScriptConfiguration(AuthenticationScriptUsageType.INTERACTIVE, acrsToDetermineScript = AcrService.getAcrsToDetermineScript(acrValuesList))) == null) {
                    this.log.error("Failed to get CustomScriptConfiguration. auth_step: {}, acr_values: {}", (Object)1, (Object)this.acrValues);
                    this.permissionDenied();
                    return;
                }
                Object acr = customScriptConfiguration.getName();
                if (AcrService.isAgama((String)acr) && !acrValuesList.isEmpty()) {
                    acr = acrValuesList.iterator().next();
                }
                requestParameterMap.put("acr", (String)acr);
                requestParameterMap.put("auth_step", Integer.toString(1));
                String string = this.externalAuthenticationService.executeExternalGetPageForStep(customScriptConfiguration, 1);
                if (StringHelper.isNotEmpty((String)string)) {
                    this.log.trace("Redirect to person authentication login page: {}", (Object)string);
                    redirectTo = string;
                }
            }
            String remoteIp = this.networkService.getRemoteIp();
            requestParameterMap.put("remote_ip", remoteIp);
            if (session != null && session.getSessionAttributes().containsKey("user_code")) {
                String userCode = (String)session.getSessionAttributes().get("user_code");
                requestParameterMap.put("user_code", userCode);
            }
            SessionId unauthenticatedSession = this.sessionIdService.generateUnauthenticatedSessionId(null, new Date(), SessionIdState.UNAUTHENTICATED, requestParameterMap, false);
            unauthenticatedSession.setSessionAttributes(requestParameterMap);
            unauthenticatedSession.addPermission(this.clientId, Boolean.valueOf(false));
            if (this.appConfiguration.getKeepAuthenticatorAttributesOnAcrChange().booleanValue()) {
                this.authenticationService.copyAuthenticatorExternalAttributes(session, unauthenticatedSession);
            }
            if (session != null && session.getPermissionGrantedMap() != null && session.getPermissionGrantedMap().getPermissionGranted() != null) {
                for (Map.Entry entry : session.getPermissionGrantedMap().getPermissionGranted().entrySet()) {
                    unauthenticatedSession.addPermission((String)entry.getKey(), (Boolean)entry.getValue());
                }
                this.sessionIdService.remove(session);
            }
            if ((persisted = this.sessionIdService.persistSessionId(unauthenticatedSession, !prompts.contains(Prompt.NONE))) && this.log.isTraceEnabled()) {
                this.log.trace("Session '{}' persisted to DB", (Object)unauthenticatedSession.getId());
            }
            this.sessionId = unauthenticatedSession.getId();
            this.cookieService.createSessionIdCookie(unauthenticatedSession, false);
            this.cookieService.creatRpOriginIdCookie(this.redirectUri);
            this.identity.setSessionId(unauthenticatedSession);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (requestParameterMap.containsKey("login_hint")) {
                hashMap.put("login_hint", requestParameterMap.get("login_hint"));
            }
            if (!(enableRedirect = StringHelper.toBoolean((String)System.getProperty("gluu.enable-redirect", "false"), (boolean)false)) && redirectTo.toLowerCase().endsWith("xhtml")) {
                if (redirectTo.toLowerCase().endsWith("postlogin.xhtml")) {
                    this.authenticator.authenticateWithOutcome();
                } else {
                    this.authenticator.prepareAuthenticationForStep(unauthenticatedSession);
                    this.facesService.renderView(redirectTo);
                }
            } else {
                this.facesService.redirectWithExternal(redirectTo, hashMap);
            }
            return;
        }
        String userCode = (String)session.getSessionAttributes().get("user_code");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)userCode) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.redirectionUriService.validateRedirectionUri(this.clientId, this.redirectUri))) {
            ExternalContext externalContext = this.facesContext.getExternalContext();
            externalContext.setResponseStatus(400);
            externalContext.setResponseContentType("application/json");
            externalContext.getResponseOutputWriter().write(this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_REDIRECT_URI, this.state, ""));
            this.facesContext.responseComplete();
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("checkPermissionGranted, userDn = {}", (Object)session.getUserDn());
        }
        if (prompts.contains(Prompt.SELECT_ACCOUNT)) {
            Map<String, String> requestParameterMap = this.requestParameterService.getAllowedParameters(this.externalContext.getRequestParameterMap());
            String selectAccountPage = this.getSelectAccountPage(client);
            this.log.trace("Select account page: {}" + selectAccountPage);
            this.facesService.redirect(selectAccountPage, requestParameterMap);
            return;
        }
        if (prompts.contains(Prompt.NONE) && prompts.size() > 1) {
            this.invalidRequest();
            return;
        }
        authzRequest.setSessionId(this.sessionId);
        ExternalPostAuthnContext postAuthnContext = new ExternalPostAuthnContext(client, session, authzRequest, prompts);
        boolean forceAuthorization = this.externalPostAuthnService.externalForceAuthorization(client, postAuthnContext);
        boolean hasConsentPrompt = prompts.contains(Prompt.CONSENT);
        if (!hasConsentPrompt && !forceAuthorization) {
            boolean isPairwiseWithOnlyOpenIdScope;
            boolean isTrusted = BooleanUtils.isTrue((Boolean)this.appConfiguration.getTrustedClientEnabled()) && client.getTrustedClient();
            boolean canGrantAccess = BooleanUtils.isTrue((Boolean)this.appConfiguration.getSkipAuthorizationForOpenIdScopeAndPairwiseId()) && SubjectType.PAIRWISE.equals((Object)client.getSubjectType()) && this.hasOnlyOpenidScope();
            boolean bl = isPairwiseWithOnlyOpenIdScope = client.getSubjectType() == SubjectType.PAIRWISE && grantedScopes.size() == 1 && grantedScopes.contains(DefaultScope.OPEN_ID.toString()) && this.scope.equals(DefaultScope.OPEN_ID.toString()) && this.claims == null && this.request == null;
            if (isTrusted || canGrantAccess || isPairwiseWithOnlyOpenIdScope) {
                this.permissionGranted(session);
                return;
            }
            User user = this.sessionIdService.getUser(session);
            ClientAuthorization clientAuthorization = this.clientAuthorizationsService.find(user.getAttribute("inum"), client.getClientId());
            if (clientAuthorization != null && clientAuthorization.getScopes() != null && Arrays.asList(clientAuthorization.getScopes()).containsAll(StringUtils.spaceSeparatedToList((String)this.scope))) {
                this.permissionGranted(session);
                return;
            }
        }
        if (this.externalConsentGatheringService.isEnabled()) {
            if (this.consentGatherer.isConsentGathered()) {
                this.log.trace("Consent-gathered flow passed successfully");
                this.permissionGranted(session);
                return;
            }
            List<String> acrValuesList = this.sessionIdService.acrValuesList(this.acrValues);
            this.log.trace("Starting external consent-gathering flow, acrValues {} ...", acrValuesList);
            boolean result = this.consentGatherer.configure(session.getUserDn(), this.clientId, this.state, acrValuesList);
            if (!result) {
                this.log.error("Failed to initialize external consent-gathering flow.");
                this.permissionDenied();
                return;
            }
        }
    }

    private AuthzDetails prepareAuthzDetails(String authorizationDetails, AuthzRequest authzRequest) {
        this.authzDetails = AuthzDetails.ofSilently((String)authorizationDetails);
        if (this.authzDetails == null || this.authzDetails.getDetails() == null || this.authzDetails.getDetails().isEmpty()) {
            return null;
        }
        authzRequest.setAuthzDetails(this.authzDetails);
        ExecutionContext executionContext = ExecutionContext.of(authzRequest);
        executionContext.setAuthzDetails(this.authzDetails);
        for (AuthzDetail detail : this.authzDetails.getDetails()) {
            String uiRepresentation = this.externalAuthzDetailTypeService.externalGetUiRepresentation(executionContext, detail);
            detail.setUiRepresentation(uiRepresentation);
        }
        return this.authzDetails;
    }

    private String getSelectAccountPage(Client client) {
        ExecutionContext executionContext = ExecutionContext.of(this.externalContext);
        executionContext.setClient(client);
        String selectAccountPageFromScript = this.externalSelectAccountService.externalGetSelectAccountPage(executionContext);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)selectAccountPageFromScript)) {
            return selectAccountPageFromScript;
        }
        return "/selectAccount.xhtml";
    }

    public boolean shouldSkipScript(List<String> acrValues) {
        if (acrValues.size() == 1 && acrValues.contains("simple_password_auth")) {
            return true;
        }
        return acrValues.isEmpty() && BooleanUtils.isFalse((Boolean)this.appConfiguration.getUseHighestLevelScriptIfAcrScriptNotFound()) && "simple_password_auth".equalsIgnoreCase(this.defaultAuthenticationMode.getName());
    }

    private SessionId handleAcrChange(SessionId session, List<Prompt> prompts) {
        if (session != null && session.getState() == SessionIdState.AUTHENTICATED) {
            if (!prompts.contains(Prompt.LOGIN)) {
                prompts.add(Prompt.LOGIN);
            }
            session.getSessionAttributes().put("prompt", StringUtils.implode(prompts, (String)" "));
            session.setState(SessionIdState.UNAUTHENTICATED);
            String remoteIp = this.networkService.getRemoteIp();
            session.getSessionAttributes().put("remote_ip", remoteIp);
            boolean isSessionPersisted = this.sessionIdService.reinitLogin(session, false);
            if (!isSessionPersisted) {
                this.sessionIdService.updateSessionId(session);
            }
        }
        return session;
    }

    private SessionId getSession() {
        return this.authorizeService.getSession(this.sessionId);
    }

    public List<Scope> getScopes() {
        return this.authorizeService.getScopes(this.allowedScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRequestedClaims() {
        HashSet<String> result = new HashSet<String>();
        String requestJwt = this.request;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)requestJwt) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.requestUri)) {
            try {
                URI reqUri = new URI(this.requestUri);
                String reqUriHash = reqUri.getFragment();
                String reqUriWithoutFragment = reqUri.getScheme() + ":" + reqUri.getSchemeSpecificPart();
                try (jakarta.ws.rs.client.Client clientRequest = ClientBuilder.newClient();){
                    Response clientResponse = clientRequest.target(reqUriWithoutFragment).request().buildGet().invoke();
                    clientRequest.close();
                    int status = clientResponse.getStatus();
                    if (status == 200) {
                        String entity = (String)clientResponse.readEntity(String.class);
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqUriHash)) {
                            requestJwt = entity;
                        } else {
                            String hash = Base64Util.base64urlencode((byte[])JwtUtil.getMessageDigestSHA256((String)entity));
                            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)reqUriHash, (CharSequence)hash)) {
                                requestJwt = entity;
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)requestJwt)) {
            try {
                Client client = this.clientService.getClient(this.clientId);
                if (client != null) {
                    JwtAuthorizationRequest jwtAuthorizationRequest = new JwtAuthorizationRequest(this.appConfiguration, this.cryptoProvider, this.request, client);
                    if (jwtAuthorizationRequest.getUserInfoMember() != null) {
                        for (Claim claim : jwtAuthorizationRequest.getUserInfoMember().getClaims()) {
                            result.add(claim.getName());
                        }
                    }
                    if (jwtAuthorizationRequest.getIdTokenMember() != null) {
                        for (Claim claim : jwtAuthorizationRequest.getIdTokenMember().getClaims()) {
                            result.add(claim.getName());
                        }
                    }
                }
            }
            catch (InvalidJwtException | EntryPersistenceException e) {
                this.log.error(e.getMessage(), e);
            }
        }
        return new ArrayList<String>(result);
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getResponseMode() {
        return this.responseMode;
    }

    public void setResponseMode(String responseMode) {
        this.responseMode = responseMode;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public String getUiLocales() {
        return this.uiLocales;
    }

    public void setUiLocales(String uiLocales) {
        this.uiLocales = uiLocales;
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public void setIdTokenHint(String idTokenHint) {
        this.idTokenHint = idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public void setLoginHint(String loginHint) {
        this.loginHint = StringEscapeUtils.escapeEcmaScript((String)loginHint);
    }

    public String getAcrValues() {
        return this.acrValues;
    }

    public void setAcrValues(String acrValues) {
        this.acrValues = acrValues;
    }

    public String getAmrValues() {
        return this.amrValues;
    }

    public void setAmrValues(String amrValues) {
        this.amrValues = amrValues;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void permissionGranted() {
        SessionId session = this.getSession();
        this.permissionGranted(session);
    }

    public void permissionGranted(SessionId session) {
        HttpServletRequest httpRequest = (HttpServletRequest)this.externalContext.getRequest();
        this.authorizeService.permissionGranted(httpRequest, session);
    }

    public void permissionDenied() {
        SessionId session = this.getSession();
        this.authorizeService.permissionDenied(session);
    }

    public void invalidRequest() {
        this.log.trace("invalidRequest");
        StringBuilder sb = new StringBuilder();
        sb.append(this.redirectUri);
        if (this.redirectUri != null && this.redirectUri.contains("?")) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, this.getState()));
        this.facesService.redirectToExternalURL(sb.toString());
    }

    public void consentRequired() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.redirectUri);
        if (this.redirectUri != null && this.redirectUri.contains("?")) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.CONSENT_REQUIRED, this.getState()));
        this.facesService.redirectToExternalURL(sb.toString());
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public List<AuthzDetail> getAuthzDetails() {
        return this.authzDetails != null ? this.authzDetails.getDetails() : Collections.emptyList();
    }

    public String getAuthorizationDetails() {
        return this.authorizationDetails;
    }

    public void setAuthorizationDetails(String authorizationDetails) {
        this.authorizationDetails = authorizationDetails;
    }

    public String getClaims() {
        return this.claims;
    }

    public void setClaims(String claims) {
        this.claims = claims;
    }

    public String getClientDisplayName() {
        this.log.trace("client {}", (Object)this.clientId);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.clientId)) {
            return UNKNOWN;
        }
        Client client = this.clientService.getClient(this.clientId);
        return this.getCheckedClientDisplayName(client);
    }

    public String getClientDisplayName(Client client) {
        this.log.trace("client {}", (Object)client);
        if (client == null) {
            return UNKNOWN;
        }
        return this.getCheckedClientDisplayName(client);
    }

    private String getCheckedClientDisplayName(Client client) {
        if (client == null) {
            return UNKNOWN;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)client.getClientName())) {
            return client.getClientName();
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)client.getClientId())) {
            return client.getClientId();
        }
        return UNKNOWN;
    }

    public String getAuthReqId() {
        return this.authReqId;
    }

    public void setAuthReqId(String authReqId) {
        this.authReqId = authReqId;
    }

    public String getBindingMessage() {
        CibaRequestCacheControl cibaRequestCacheControl;
        String bindingMessage = null;
        if (Strings.isNotBlank((String)this.getAuthReqId()) && (cibaRequestCacheControl = this.cibaRequestService.getCibaRequest(this.authReqId)) != null) {
            bindingMessage = cibaRequestCacheControl.getBindingMessage();
        }
        return bindingMessage;
    }

    public String encodeParameters(String url, Map<String, Object> parameters) {
        if (parameters.isEmpty()) {
            return url;
        }
        StringBuilder builder = new StringBuilder(url);
        for (Map.Entry<String, Object> param : parameters.entrySet()) {
            String parameterName = param.getKey();
            if (this.containsParameter(url, parameterName)) continue;
            Object parameterValue = param.getValue();
            if (parameterValue instanceof Iterable) {
                for (Object value : (Iterable)parameterValue) {
                    builder.append('&').append(parameterName).append('=');
                    if (value == null) continue;
                    builder.append(this.encode(value));
                }
                continue;
            }
            builder.append('&').append(parameterName).append('=');
            if (parameterValue == null) continue;
            builder.append(this.encode(parameterValue));
        }
        if (url.indexOf(63) < 0) {
            builder.setCharAt(url.length(), '?');
        }
        return builder.toString();
    }

    private boolean containsParameter(String url, String parameterName) {
        return url.indexOf("?" + parameterName + "=") > 0 || url.indexOf("&" + parameterName + "=") > 0;
    }

    private String encode(Object value) {
        try {
            return URLEncoder.encode(String.valueOf(value), "UTF-8");
        }
        catch (UnsupportedEncodingException iee) {
            throw new RuntimeException(iee);
        }
    }

    private boolean hasOnlyOpenidScope() {
        return this.getScopes() != null && this.getScopes().size() == 1 && this.getScopes().get(0).getId().equals("openid");
    }

    protected void handleSessionInvalid() {
        this.errorHandlerService.handleError("login.errorSessionInvalidMessage", (IErrorType)AuthorizeErrorResponseType.AUTHENTICATION_SESSION_INVALID, "Create authorization request to start new authentication session.");
    }

    protected void handleScriptError(String facesMessageId) {
        this.errorHandlerService.handleError("login.failedToAuthenticate", (IErrorType)AuthorizeErrorResponseType.INVALID_AUTHENTICATION_METHOD, "Contact administrator to fix specific ACR method issue.");
    }
}

