/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authorize.ws.rs;

import com.google.common.base.Strings;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.common.util.RedirectUri;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.ciba.BackchannelAuthenticationErrorResponseType;
import io.jans.as.model.common.ResponseMode;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.server.authorize.ws.rs.AuthzRequest;
import io.jans.as.server.model.authorize.AuthorizeParamsValidator;
import io.jans.as.server.model.authorize.JwtAuthorizationRequest;
import io.jans.as.server.model.common.DeviceAuthorizationCacheControl;
import io.jans.as.server.model.exception.InvalidRedirectUrlException;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.DeviceAuthorizationService;
import io.jans.as.server.service.RedirectUriResponse;
import io.jans.as.server.service.RedirectionUriService;
import io.jans.as.server.service.external.ExternalAuthzDetailTypeService;
import io.jans.as.server.util.RedirectUtil;
import io.jans.as.server.util.ServerUtil;
import io.jans.orm.exception.EntryPersistenceException;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Named
@Stateless
public class AuthorizeRestWebServiceValidator {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private ClientService clientService;
    @Inject
    private RedirectionUriService redirectionUriService;
    @Inject
    private DeviceAuthorizationService deviceAuthorizationService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ExternalAuthzDetailTypeService externalAuthzDetailTypeService;

    public Client validateClient(String clientId, String state) {
        return this.validateClient(clientId, state, false);
    }

    public Client validateClient(AuthzRequest authzRequest, boolean isPar) {
        Client client = this.validateClient(authzRequest.getClientId(), authzRequest.getState(), isPar);
        authzRequest.setClient(client);
        return client;
    }

    public Client validateClient(String clientId, String state, boolean isPar) {
        if (StringUtils.isBlank((CharSequence)clientId)) {
            this.log.debug("client_id is empty or blank {}.", (Object)clientId);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state, "client_id is empty or blank.")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        try {
            Client client = this.clientService.getClient(clientId);
            if (client == null) {
                this.log.debug("Unable to find client by id {}.", (Object)clientId);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state, "Unable to find client.")).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
            if (client.isDisabled()) {
                this.log.debug("Client {} is disabled.", (Object)clientId);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.DISABLED_CLIENT, state, "Client is disabled.")).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
            if (!isPar && BooleanUtils.isTrue((Boolean)client.getAttributes().getRequirePar())) {
                this.log.debug("Client can performa only PAR requests.");
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, state, "Client can performa only PAR requests.")).type(MediaType.APPLICATION_JSON_TYPE).build());
            }
            return client;
        }
        catch (EntryPersistenceException e) {
            this.log.debug("Unable to find client on AS by client_id: {}", (Object)clientId);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, state, "Unable to find client on AS.")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    public boolean isAuthnMaxAgeValid(Integer maxAge, SessionId sessionUser, Client client) {
        if (maxAge == null) {
            maxAge = client.getDefaultMaxAge();
        }
        if (maxAge == null) {
            return true;
        }
        if (maxAge == 0) {
            return !BooleanUtils.isTrue((Boolean)this.appConfiguration.getDisableAuthnForMaxAgeZero());
        }
        GregorianCalendar userAuthnTime = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        if (sessionUser.getAuthenticationTime() != null) {
            userAuthnTime.setTime(sessionUser.getAuthenticationTime());
        }
        userAuthnTime.add(13, maxAge);
        return userAuthnTime.after(ServerUtil.now());
    }

    public void validateRequestJwt(String request, String requestUri, RedirectUriResponse redirectUriResponse) {
        if (this.appConfiguration.isFapi() && StringUtils.isBlank((CharSequence)request) && StringUtils.isBlank((CharSequence)requestUri)) {
            throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, "request and request_uri are both not specified which is forbidden for FAPI.");
        }
        if (StringUtils.isNotBlank((CharSequence)request) && StringUtils.isNotBlank((CharSequence)requestUri)) {
            throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, "Both request and request_uri are specified which is not allowed.");
        }
    }

    public void validate(AuthzRequest authzRequest, List<ResponseType> responseTypes, Client client) {
        ResponseMode responseMode = authzRequest.getResponseModeEnum();
        String redirectUri = authzRequest.getRedirectUri();
        if (!AuthorizeParamsValidator.validateParams(responseTypes, authzRequest.getPromptList(), authzRequest.getNonce(), this.appConfiguration.isFapi(), responseMode)) {
            if (redirectUri != null && this.redirectionUriService.validateRedirectionUri(client, redirectUri) != null) {
                RedirectUri redirectUriResponse = new RedirectUri(redirectUri, responseTypes, responseMode);
                redirectUriResponse.parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, authzRequest.getState()));
                throw new WebApplicationException(RedirectUtil.getRedirectResponseBuilder(redirectUriResponse, authzRequest.getHttpRequest()).build());
            }
            throw new WebApplicationException(Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, authzRequest.getState(), "Invalid redirect uri.")).build());
        }
    }

    public void validateRequestObject(JwtAuthorizationRequest jwtRequest, RedirectUriResponse redirectUriResponse) {
        long now;
        if (!jwtRequest.getAud().isEmpty() && !jwtRequest.getAud().contains(this.appConfiguration.getIssuer())) {
            this.log.error("Failed to match aud to AS, aud: {}", jwtRequest.getAud());
            throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT);
        }
        if (!this.appConfiguration.isFapi()) {
            return;
        }
        if (jwtRequest.getNestedJwt() != null) {
            SignatureAlgorithm nestedJwtSigAlg = jwtRequest.getNestedJwt().getHeader().getSignatureAlgorithm();
            if (this.appConfiguration.isFapi() && (nestedJwtSigAlg == SignatureAlgorithm.RS256 || nestedJwtSigAlg == SignatureAlgorithm.NONE)) {
                this.log.error("The Nested JWT signature algorithm is not valid.");
                throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT);
            }
        }
        String redirectUri = jwtRequest.getRedirectUri();
        Client client = this.clientService.getClient(jwtRequest.getClientId());
        if (redirectUri != null && this.redirectionUriService.validateRedirectionUri(client, redirectUri) == null) {
            this.log.error(" unregistered redirect uri");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT, jwtRequest.getState(), "The request has unregistered request_uri")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        if (jwtRequest.getExp() == null) {
            this.log.error("The exp claim is not set");
            throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT);
        }
        long expInMillis = (long)jwtRequest.getExp().intValue() * 1000L;
        if (expInMillis < (now = new Date().getTime())) {
            this.log.error("Request object expired. Exp: {}, now: {}", (Object)expInMillis, (Object)now);
            throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT);
        }
        if (jwtRequest.getScopes() == null || jwtRequest.getScopes().isEmpty()) {
            this.log.error("Request object does not have scope claim.");
            throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT);
        }
        if (StringUtils.isBlank((CharSequence)jwtRequest.getNonce())) {
            this.log.error("Request object does not have nonce claim.");
            throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT);
        }
        if (StringUtils.isBlank((CharSequence)jwtRequest.getRedirectUri())) {
            this.log.error("Request object does not have redirect_uri claim.");
            if (redirectUriResponse.getRedirectUri().getBaseRedirectUri() != null) {
                throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT);
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT, jwtRequest.getState(), "Request object does not have redirect_uri claim.")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
    }

    public void validateCibaRequestObject(JwtAuthorizationRequest jwtRequest, String clientId) {
        long now;
        if (jwtRequest.getAud().isEmpty() || !jwtRequest.getAud().contains(this.appConfiguration.getIssuer())) {
            this.log.error("Failed to match aud to AS, aud: {}", jwtRequest.getAud());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
        if (!this.appConfiguration.isFapi()) {
            return;
        }
        if (jwtRequest.getExp() == null) {
            this.log.error("The exp claim is not set");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
        long expInMillis = (long)jwtRequest.getExp().intValue() * 1000L;
        if (expInMillis < (now = new Date().getTime())) {
            this.log.error("Request object expired. Exp: {}, now: {}", (Object)expInMillis, (Object)now);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
        if (jwtRequest.getScopes() == null || jwtRequest.getScopes().isEmpty()) {
            this.log.error("Request object does not have scope claim.");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
        if (StringUtils.isEmpty((CharSequence)jwtRequest.getIss()) || !jwtRequest.getIss().equals(clientId)) {
            this.log.error("Request object has a wrong iss claim, iss: {}", (Object)jwtRequest.getIss());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
        if (jwtRequest.getIat() == null || jwtRequest.getIat() == 0) {
            this.log.error("Request object has a wrong iat claim, iat: {}", (Object)jwtRequest.getIat());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
        int nowInSeconds = Math.toIntExact(System.currentTimeMillis() / 1000L);
        if (jwtRequest.getNbf() == null || jwtRequest.getNbf() > nowInSeconds || jwtRequest.getNbf() < nowInSeconds - this.appConfiguration.getCibaMaxExpirationTimeAllowedSec()) {
            this.log.error("Request object has a wrong nbf claim, nbf: {}", (Object)jwtRequest.getNbf());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
        if (StringUtils.isEmpty((CharSequence)jwtRequest.getJti())) {
            this.log.error("Request object has a wrong jti claim, jti: {}", (Object)jwtRequest.getJti());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
        int result = (StringUtils.isNotBlank((CharSequence)jwtRequest.getLoginHint()) ? 1 : 0) + (StringUtils.isNotBlank((CharSequence)jwtRequest.getLoginHintToken()) ? 1 : 0) + (StringUtils.isNotBlank((CharSequence)jwtRequest.getIdTokenHint()) ? 1 : 0);
        if (result != 1) {
            this.log.error("Request object has too many hints or doesnt have any");
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST)).build());
        }
    }

    public String validateRedirectUri(@NotNull Client client, @Nullable String redirectUri, @Nullable String state, @Nullable String deviceAuthzUserCode, @Nullable HttpServletRequest httpRequest) {
        return this.validateRedirectUri(client, redirectUri, state, deviceAuthzUserCode, httpRequest, AuthorizeErrorResponseType.INVALID_REQUEST_REDIRECT_URI);
    }

    public String validateRedirectUri(@NotNull Client client, @Nullable String redirectUri, @Nullable String state, @Nullable String deviceAuthzUserCode, @Nullable HttpServletRequest httpRequest, @NotNull AuthorizeErrorResponseType error) {
        if (this.appConfiguration.isFapi() && StringUtils.isNotBlank((CharSequence)redirectUri) && StringUtils.isBlank((CharSequence)this.redirectionUriService.validateRedirectionUri(client, redirectUri))) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)error, state, "")).build());
        }
        if (StringUtils.isNotBlank((CharSequence)deviceAuthzUserCode)) {
            DeviceAuthorizationCacheControl deviceAuthorizationCacheControl = this.deviceAuthorizationService.getDeviceAuthzByUserCode(deviceAuthzUserCode);
            redirectUri = this.deviceAuthorizationService.getDeviceAuthorizationPage(deviceAuthorizationCacheControl, client, state, httpRequest);
        } else {
            redirectUri = this.redirectionUriService.validateRedirectionUri(client, redirectUri);
        }
        if (StringUtils.isNotBlank((CharSequence)redirectUri)) {
            return redirectUri;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)error, state, "")).build());
    }

    public void throwInvalidJwtRequestExceptionAsJwtMode(RedirectUriResponse redirectUriResponse, String reason, String state, HttpServletRequest httpRequest) {
        this.log.debug(reason);
        this.log.debug("Invalid JWT authorization request.");
        redirectUriResponse.getRedirectUri().parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT, state));
        throw new WebApplicationException(RedirectUtil.getRedirectResponseBuilder(redirectUriResponse.getRedirectUri(), httpRequest).build());
    }

    public WebApplicationException createInvalidJwtRequestException(RedirectUriResponse redirectUriResponse, String reason) {
        if (this.appConfiguration.isFapi()) {
            this.log.debug(reason);
            return redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT);
        }
        return redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT, reason);
    }

    public void validatePkce(String codeChallenge, RedirectUriResponse redirectUriResponse, Client client) {
        boolean requirePkce;
        boolean bl = requirePkce = BooleanUtils.isTrue((Boolean)this.appConfiguration.getRequirePkce()) || client.getAttributes().getRequirePkce() != false;
        if (requirePkce && Strings.isNullOrEmpty((String)codeChallenge)) {
            this.log.error("PKCE is required but code_challenge is blank.");
            throw redirectUriResponse.createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST);
        }
    }

    public void validateJwtRequest(String clientId, String state, HttpServletRequest httpRequest, List<ResponseType> responseTypes, RedirectUriResponse redirectUriResponse, JwtAuthorizationRequest jwtRequest) {
        try {
            jwtRequest.validate();
            this.validateRequestObject(jwtRequest, redirectUriResponse);
            if (!jwtRequest.getResponseTypes().containsAll(responseTypes) || !responseTypes.containsAll(jwtRequest.getResponseTypes())) {
                throw this.createInvalidJwtRequestException(redirectUriResponse, "The responseType parameter is not the same in the JWT");
            }
            if (StringUtils.isBlank((CharSequence)jwtRequest.getClientId()) || !jwtRequest.getClientId().equals(clientId)) {
                throw this.createInvalidJwtRequestException(redirectUriResponse, "The clientId parameter is not the same in the JWT");
            }
        }
        catch (InvalidRedirectUrlException | WebApplicationException e) {
            throw e;
        }
        catch (InvalidJwtException e) {
            this.log.debug("Invalid JWT authorization request. {}", (Object)e.getMessage());
            redirectUriResponse.getRedirectUri().parseQueryString(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT, state));
            throw new WebApplicationException(RedirectUtil.getRedirectResponseBuilder(redirectUriResponse.getRedirectUri(), httpRequest).build());
        }
        catch (Exception e) {
            this.log.error("Unexpected exception. " + e.getMessage(), (Throwable)e);
        }
    }

    public void checkSignedRequestRequired(AuthzRequest authzRequest) {
        if (Boolean.TRUE.equals(this.appConfiguration.getForceSignedRequestObject()) && StringUtils.isBlank((CharSequence)authzRequest.getRequest()) && StringUtils.isBlank((CharSequence)authzRequest.getRequestUri())) {
            throw this.createInvalidJwtRequestException(authzRequest.getRedirectUriResponse(), "A signed request object is required");
        }
    }

    public void validateNotWebView(HttpServletRequest httpRequest) {
        String headerRequestedWith;
        if (this.appConfiguration.getBlockWebviewAuthorizationEnabled().booleanValue() && (headerRequestedWith = httpRequest.getHeader("X-Requested-With")) != null) {
            this.log.error("Unauthorized, request contains X-Requested-With: {}", (Object)headerRequestedWith);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    public void validateAuthorizationDetails(AuthzRequest authzRequest, Client client) {
        String authorizationDetailsString = authzRequest.getAuthzDetailsString();
        if (StringUtils.isBlank((CharSequence)authorizationDetailsString)) {
            return;
        }
        AuthzDetails authzDetails = AuthzDetails.ofSilently((String)authorizationDetailsString);
        if (authzDetails == null) {
            this.log.debug("Unable to parse 'authorization_details' {}", (Object)authorizationDetailsString);
            throw authzRequest.getRedirectUriResponse().createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_AUTHORIZATION_DETAILS, "Unable to parse 'authorization_details'");
        }
        authzRequest.setAuthzDetails(authzDetails);
        if (authzDetails.getDetails() == null || authzDetails.getDetails().isEmpty()) {
            return;
        }
        Set requestAuthzDetailsTypes = authzDetails.getTypes();
        Set<String> supportedAuthzDetailsTypes = this.externalAuthzDetailTypeService.getSupportedAuthzDetailsTypes();
        if (!supportedAuthzDetailsTypes.containsAll(requestAuthzDetailsTypes)) {
            this.log.debug("Not all authorization_details type are supported. Requested {}. AS supports: {}", (Object)requestAuthzDetailsTypes, supportedAuthzDetailsTypes);
            throw authzRequest.getRedirectUriResponse().createWebException((IErrorType)AuthorizeErrorResponseType.INVALID_AUTHORIZATION_DETAILS, "Found not supported 'authorization_details' type.");
        }
        if (!client.getAttributes().getAuthorizationDetailsTypes().containsAll(requestAuthzDetailsTypes)) {
            this.log.debug("Client does not support all authorization_details types' {}. Client supports {}", (Object)requestAuthzDetailsTypes, (Object)client.getAttributes().getAuthorizationDetailsTypes());
            throw authzRequest.getRedirectUriResponse().createWebException((IErrorType)AuthorizeErrorResponseType.UNAUTHORIZED_CLIENT, "Client does not support authorization_details type'");
        }
        this.externalAuthzDetailTypeService.externalValidateAuthzDetails(authzRequest);
    }

    public void validateRequestParameterSupported(AuthzRequest authzRequest) {
        String request = authzRequest.getRequest();
        String state = authzRequest.getState();
        if (StringUtils.isBlank((CharSequence)request)) {
            return;
        }
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getRequestParameterSupported())) {
            return;
        }
        this.log.debug("'request' support is switched off by requestParameterSupported=false configuration property.");
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.REQUEST_NOT_SUPPORTED, state, "request processing is denied by AS.")).build());
    }

    public void validateRequestUriParameterSupported(AuthzRequest authzRequest) {
        String requestUri = authzRequest.getRequestUri();
        String state = authzRequest.getState();
        if (StringUtils.isBlank((CharSequence)requestUri)) {
            return;
        }
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getRequestUriParameterSupported())) {
            return;
        }
        this.log.debug("'request_uri' support is switched off by requestUriParameterSupported=false configuration property.");
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.REQUEST_URI_NOT_SUPPORTED, state, "request_uri processing is denied by AS")).build());
    }
}

