/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authorize.ws.rs;

import io.jans.as.common.model.registration.Client;
import io.jans.as.model.authzdetails.AuthzDetail;
import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.token.TokenErrorResponseType;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.service.external.ExternalAuthzDetailTypeService;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Stateless
@Named
public class AuthzDetailsService {
    @Inject
    private Logger log;
    @Inject
    private ExternalAuthzDetailTypeService externalAuthzDetailTypeService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;

    public AuthzDetails validateAuthorizationDetails(String authorizationDetailsString, ExecutionContext executionContext) {
        if (StringUtils.isBlank((CharSequence)authorizationDetailsString)) {
            return null;
        }
        AuthzDetails authzDetails = AuthzDetails.ofSilently((String)authorizationDetailsString);
        if (authzDetails == null) {
            this.log.debug("Unable to parse 'authorization_details' {}", (Object)authorizationDetailsString);
            throw new WebApplicationException(this.error(400, (IErrorType)TokenErrorResponseType.INVALID_AUTHORIZATION_DETAILS, "Unable to parse 'authorization_details'").build());
        }
        if (authzDetails.getDetails() == null || authzDetails.getDetails().isEmpty()) {
            return null;
        }
        Set requestAuthzDetailsTypes = authzDetails.getTypes();
        Set<String> supportedAuthzDetailsTypes = this.externalAuthzDetailTypeService.getSupportedAuthzDetailsTypes();
        if (!supportedAuthzDetailsTypes.containsAll(requestAuthzDetailsTypes)) {
            this.log.debug("Not all authorization_details type are supported. Requested {}. AS supports: {}", (Object)requestAuthzDetailsTypes, supportedAuthzDetailsTypes);
            throw new WebApplicationException(this.error(400, (IErrorType)TokenErrorResponseType.INVALID_AUTHORIZATION_DETAILS, "Found not supported 'authorization_details' type.").build());
        }
        Client client = executionContext.getClient();
        if (!client.getAttributes().getAuthorizationDetailsTypes().containsAll(requestAuthzDetailsTypes)) {
            this.log.debug("Client does not support all authorization_details types' {}. Client supports {}", (Object)requestAuthzDetailsTypes, (Object)client.getAttributes().getAuthorizationDetailsTypes());
            throw new WebApplicationException(this.error(400, (IErrorType)TokenErrorResponseType.UNAUTHORIZED_CLIENT, "Client does not support authorization_details type'").build());
        }
        executionContext.setAuthzDetails(authzDetails);
        this.externalAuthzDetailTypeService.externalValidateAuthzDetails(executionContext);
        return authzDetails;
    }

    public Response.ResponseBuilder error(int status, IErrorType type, String reason) {
        return Response.status((int)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.errorResponseFactory.errorAsJson(type, reason));
    }

    public AuthzDetails checkAuthzDetails(AuthzDetails requestedAuthzDetails, AuthzDetails authorizedDetails) {
        if (AuthzDetails.isEmpty((AuthzDetails)authorizedDetails) || AuthzDetails.isEmpty((AuthzDetails)requestedAuthzDetails)) {
            return null;
        }
        ArrayList<AuthzDetail> grantedDetails = new ArrayList<AuthzDetail>();
        block0: for (AuthzDetail authorized : authorizedDetails.getDetails()) {
            for (AuthzDetail requested : requestedAuthzDetails.getDetails()) {
                if (!authorized.getJsonObject().similar((Object)requested.getJsonObject()) || grantedDetails.contains(authorized)) continue;
                grantedDetails.add(authorized);
                continue block0;
            }
        }
        return new AuthzDetails(grantedDetails);
    }

    public AuthzDetails checkAuthzDetailsAndSave(AuthzDetails requestedAuthzDetails, AuthorizationGrant authorizationGrant) {
        AuthzDetails granted = this.checkAuthzDetails(requestedAuthzDetails, authorizationGrant.getAuthzDetails());
        authorizationGrant.setAuthzDetails(granted);
        authorizationGrant.save();
        return granted;
    }
}

