/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authorize.ws.rs;

import com.google.common.collect.Sets;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.AuthorizationChallengeSession;
import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.common.Prompt;
import io.jans.as.model.common.ResponseMode;
import io.jans.as.model.common.ResponseType;
import io.jans.as.model.util.StringUtils;
import io.jans.as.model.util.Util;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.authorize.JwtAuthorizationRequest;
import io.jans.as.server.service.RedirectUriResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.SecurityContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthzRequest {
    private static final Logger log = LoggerFactory.getLogger(AuthzRequest.class);
    private String scope;
    private String responseType;
    private String clientId;
    private String redirectUri;
    private String state;
    private String responseMode;
    private String nonce;
    private String display;
    private String prompt;
    private Integer maxAge;
    private String uiLocales;
    private String idTokenHint;
    private String loginHint;
    private String acrValues;
    private String amrValues;
    private String request;
    private String requestUri;
    private String sessionId;
    private String originHeaders;
    private String codeChallenge;
    private String codeChallengeMethod;
    private String customResponseHeaders;
    private String claims;
    private String authReqId;
    private String dpopJkt;
    private String dpop;
    private String authzDetailsString;
    private AuthzDetails authzDetails;
    private String httpMethod;
    private String authorizationChallengeSession;
    private AuthorizationChallengeSession authorizationChallengeSessionObject;
    private boolean useAuthorizationChallengeSession;
    private HttpServletRequest httpRequest;
    private HttpServletResponse httpResponse;
    private SecurityContext securityContext;
    private Map<String, String> customParameters;
    private JwtAuthorizationRequest jwtRequest;
    private RedirectUriResponse redirectUriResponse;
    private Client client;
    private OAuth2AuditLog auditLog;
    private boolean promptFromJwt;
    private boolean shouldReturnLogoutStatusJwt;

    public boolean getShouldReturnLogoutStatusJwt() {
        return this.shouldReturnLogoutStatusJwt;
    }

    public AuthzRequest setShouldReturnLogoutStatusJwt(boolean shouldReturnSessionJwt) {
        this.shouldReturnLogoutStatusJwt = shouldReturnSessionJwt;
        return this;
    }

    public String getAuthzDetailsString() {
        return this.authzDetailsString;
    }

    public void setAuthzDetailsString(String authzDetailsString) {
        this.authzDetailsString = authzDetailsString;
    }

    public AuthzDetails getAuthzDetails() {
        return this.authzDetails;
    }

    public void setAuthzDetails(AuthzDetails authzDetails) {
        this.authzDetails = authzDetails;
    }

    public String getDpopJkt() {
        return this.dpopJkt;
    }

    public void setDpopJkt(String dpopJkt) {
        this.dpopJkt = dpopJkt;
    }

    public String getDpop() {
        return this.dpop;
    }

    public AuthzRequest setDpop(String dpop) {
        this.dpop = dpop;
        return this;
    }

    public AuthorizationChallengeSession getAuthorizationChallengeSessionObject() {
        return this.authorizationChallengeSessionObject;
    }

    public Map<String, String> getAuthorizationChallengeSessionAttributesSafely() {
        return this.authorizationChallengeSessionObject != null ? this.authorizationChallengeSessionObject.getAttributes().getAttributes() : new HashMap();
    }

    public void setAuthorizationChallengeSessionObject(AuthorizationChallengeSession authorizationChallengeSessionObject) {
        this.authorizationChallengeSessionObject = authorizationChallengeSessionObject;
    }

    public boolean isUseAuthorizationChallengeSession() {
        return this.useAuthorizationChallengeSession;
    }

    public void setUseAuthorizationChallengeSession(boolean useAuthorizationChallengeSession) {
        this.useAuthorizationChallengeSession = useAuthorizationChallengeSession;
    }

    public String getAuthorizationChallengeSession() {
        return this.authorizationChallengeSession;
    }

    public void setAuthorizationChallengeSession(String authorizationChallengeSession) {
        this.authorizationChallengeSession = authorizationChallengeSession;
    }

    public boolean isPromptFromJwt() {
        return this.promptFromJwt;
    }

    public void setPromptFromJwt(boolean promptFromJwt) {
        this.promptFromJwt = promptFromJwt;
    }

    public OAuth2AuditLog getAuditLog() {
        return this.auditLog;
    }

    public void setAuditLog(OAuth2AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public RedirectUriResponse getRedirectUriResponse() {
        return this.redirectUriResponse;
    }

    public void setRedirectUriResponse(RedirectUriResponse redirectUriResponse) {
        this.redirectUriResponse = redirectUriResponse;
    }

    public JwtAuthorizationRequest getJwtRequest() {
        return this.jwtRequest;
    }

    public void setJwtRequest(JwtAuthorizationRequest jwtRequest) {
        this.jwtRequest = jwtRequest;
    }

    public Map<String, String> getCustomParameters() {
        if (this.customParameters == null) {
            this.customParameters = new HashMap<String, String>();
        }
        return this.customParameters;
    }

    public void setCustomParameters(Map<String, String> customParameters) {
        this.customParameters = customParameters;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public List<ResponseType> getResponseTypeList() {
        return ResponseType.fromString((String)this.responseType, (String)" ");
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getResponseMode() {
        return this.responseMode;
    }

    public ResponseMode getResponseModeEnum() {
        return ResponseMode.getByValue((String)this.responseMode);
    }

    public void setResponseMode(String responseMode) {
        this.responseMode = responseMode;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public List<Prompt> getPromptList() {
        return Prompt.fromString((String)this.prompt, (String)" ");
    }

    public void setPromptList(List<Prompt> prompts) {
        this.setPrompt(StringUtils.implode((Collection)Sets.newHashSet(prompts), (String)" "));
    }

    public void addPrompt(Prompt prompt) {
        List<Prompt> prompts = this.getPromptList();
        prompts.add(prompt);
        log.trace("Added prompt '{}'", (Object)prompt);
        this.setPromptList(prompts);
    }

    public void removePrompt(Prompt prompt) {
        List<Prompt> prompts = this.getPromptList();
        prompts.remove(prompt);
        log.trace("Removed prompt '{}'", (Object)prompt);
        this.setPromptList(prompts);
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
        log.trace("Set prompt to '{}'", (Object)prompt);
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public String getUiLocales() {
        return this.uiLocales;
    }

    public List<String> getUiLocalesList() {
        return Util.splittedStringAsList((String)this.uiLocales, (String)" ");
    }

    public void setUiLocales(String uiLocales) {
        this.uiLocales = uiLocales;
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public void setIdTokenHint(String idTokenHint) {
        this.idTokenHint = idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public void setLoginHint(String loginHint) {
        this.loginHint = loginHint;
    }

    public String getAcrValues() {
        return this.acrValues;
    }

    public List<String> getAcrValuesList() {
        return Util.splittedStringAsList((String)this.acrValues, (String)" ");
    }

    public void setAcrValues(String acrValues) {
        this.acrValues = acrValues;
    }

    public String getAmrValues() {
        return this.amrValues;
    }

    public void setAmrValues(String amrValues) {
        this.amrValues = amrValues;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getOriginHeaders() {
        return this.originHeaders;
    }

    public void setOriginHeaders(String originHeaders) {
        this.originHeaders = originHeaders;
    }

    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public void setCodeChallenge(String codeChallenge) {
        this.codeChallenge = codeChallenge;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public void setCodeChallengeMethod(String codeChallengeMethod) {
        this.codeChallengeMethod = codeChallengeMethod;
    }

    public String getCustomResponseHeaders() {
        return this.customResponseHeaders;
    }

    public void setCustomResponseHeaders(String customResponseHeaders) {
        this.customResponseHeaders = customResponseHeaders;
    }

    public String getClaims() {
        return this.claims;
    }

    public void setClaims(String claims) {
        this.claims = claims;
    }

    public String getAuthReqId() {
        return this.authReqId;
    }

    public void setAuthReqId(String authReqId) {
        this.authReqId = authReqId;
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public void setHttpRequest(HttpServletRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public HttpServletResponse getHttpResponse() {
        return this.httpResponse;
    }

    public void setHttpResponse(HttpServletResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public String toString() {
        return "AuthzRequest{scope='" + this.scope + "', responseType='" + this.responseType + "', clientId='" + this.clientId + "', redirectUri='" + this.redirectUri + "', state='" + this.state + "', responseMode='" + this.responseMode + "', nonce='" + this.nonce + "', display='" + this.display + "', prompt='" + this.prompt + "', maxAge=" + this.maxAge + ", uiLocales='" + this.uiLocales + "', idTokenHint='" + this.idTokenHint + "', loginHint='" + this.loginHint + "', acrValues='" + this.acrValues + "', amrValues='" + this.amrValues + "', request='" + this.request + "', requestUri='" + this.requestUri + "', sessionId='" + this.sessionId + "', originHeaders='" + this.originHeaders + "', codeChallenge='" + this.codeChallenge + "', codeChallengeMethod='" + this.codeChallengeMethod + "', customResponseHeaders='" + this.customResponseHeaders + "', claims='" + this.claims + "', authReqId='" + this.authReqId + "', dpopJkt='" + this.dpopJkt + "', dpop='" + this.dpop + "', authzDetailsString='" + this.authzDetailsString + "', authzDetails=" + this.authzDetails + ", httpMethod='" + this.httpMethod + "', authorizationChallengeSession='" + this.authorizationChallengeSession + "', authorizationChallengeSessionObject=" + this.authorizationChallengeSessionObject + ", useAuthorizationChallengeSession=" + this.useAuthorizationChallengeSession + ", httpRequest=" + this.httpRequest + ", httpResponse=" + this.httpResponse + ", securityContext=" + this.securityContext + ", customParameters=" + this.customParameters + ", jwtRequest=" + this.jwtRequest + ", redirectUriResponse=" + this.redirectUriResponse + ", client=" + this.client + ", auditLog=" + this.auditLog + ", promptFromJwt=" + this.promptFromJwt + ", shouldReturnLogoutStatusJwt=" + this.shouldReturnLogoutStatusJwt + "}";
    }
}

