/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authorize.ws.rs;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.common.util.CommonUtils;
import io.jans.as.common.util.RedirectUri;
import io.jans.as.model.authorize.AuthorizeErrorResponseType;
import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.common.ResponseMode;
import io.jans.as.model.config.WebKeysConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.encryption.BlockEncryptionAlgorithm;
import io.jans.as.model.crypto.encryption.KeyEncryptionAlgorithm;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.jwe.Jwe;
import io.jans.as.model.jwk.Algorithm;
import io.jans.as.model.jwk.JSONWebKeySet;
import io.jans.as.model.jwk.KeyOpsType;
import io.jans.as.model.jwk.Use;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.model.jwt.JwtHeader;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.model.util.QueryStringDecoder;
import io.jans.as.model.util.StringUtils;
import io.jans.as.model.util.Util;
import io.jans.as.persistence.model.Par;
import io.jans.as.server.authorize.ws.rs.AuthorizeRestWebServiceValidator;
import io.jans.as.server.authorize.ws.rs.AuthzRequest;
import io.jans.as.server.model.audit.Action;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.authorize.Claim;
import io.jans.as.server.model.authorize.IdTokenMember;
import io.jans.as.server.model.authorize.JwtAuthorizationRequest;
import io.jans.as.server.model.authorize.ScopeChecker;
import io.jans.as.server.model.token.HandleTokenFactory;
import io.jans.as.server.par.ws.rs.ParService;
import io.jans.as.server.service.AcrService;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.RedirectUriResponse;
import io.jans.as.server.service.RedirectionUriService;
import io.jans.as.server.service.RequestParameterService;
import io.jans.as.server.service.ServerCryptoProvider;
import io.jans.as.server.service.external.ExternalAuthenticationService;
import io.jans.as.server.util.ServerUtil;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.slf4j.Logger;

@Stateless
@Named
public class AuthzRequestService {
    public static final String INVALID_JWT_AUTHORIZATION_REQUEST = "Invalid JWT authorization request";
    private static final long ACR_TO_LEVEL_CACHE_LIFETIME_IN_MINUTES = 15L;
    private static final String ACR_TO_LEVEL_KEY = "ACR_TO_LEVEL_KEY";
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizeRestWebServiceValidator authorizeRestWebServiceValidator;
    @Inject
    private ParService parService;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private ScopeChecker scopeChecker;
    @Inject
    private RequestParameterService requestParameterService;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;
    @Inject
    private ClientService clientService;
    @Inject
    private RedirectionUriService redirectionUriService;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private AcrService acrService;
    private final Cache<String, Map<String, Integer>> acrToLevelCache = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.MINUTES).build();

    public Map<String, Integer> getAcrToLevelMap() {
        Map<String, Integer> map = (Map<String, Integer>)this.acrToLevelCache.getIfPresent((Object)ACR_TO_LEVEL_KEY);
        if (map != null) {
            return map;
        }
        map = this.externalAuthenticationService.acrToLevelMapping();
        this.acrToLevelCache.put((Object)ACR_TO_LEVEL_KEY, map);
        return map;
    }

    public void addDeviceSecretToSession(AuthzRequest authzRequest, SessionId sessionId) {
        if (BooleanUtils.isFalse((Boolean)this.appConfiguration.getReturnDeviceSecretFromAuthzEndpoint())) {
            return;
        }
        if (!Arrays.asList(authzRequest.getScope().split(" ")).contains("device_sso")) {
            return;
        }
        if (!ArrayUtils.contains((Object[])authzRequest.getClient().getGrantTypes(), (Object)GrantType.TOKEN_EXCHANGE)) {
            this.log.debug("Skip device secret. Scope has {} value but client does not have Token Exchange Grant Type enabled ('urn:ietf:params:oauth:grant-type:token-exchange')", (Object)"device_sso");
            return;
        }
        String newDeviceSecret = HandleTokenFactory.generateDeviceSecret();
        List deviceSecrets = sessionId.getDeviceSecrets();
        deviceSecrets.add(newDeviceSecret);
        authzRequest.getRedirectUriResponse().getRedirectUri().addResponseParameter("device_secret", newDeviceSecret);
    }

    public boolean processPar(AuthzRequest authzRequest) {
        boolean isPar = Util.isPar((String)authzRequest.getRequestUri());
        if (!isPar && BooleanUtils.isTrue((Boolean)this.appConfiguration.getRequirePar())) {
            this.log.debug("Server configured for PAR only (via requirePar conf property). Failed to find PAR by request_uri (id): {}", (Object)authzRequest.getRequestUri());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, authzRequest.getState(), "Failed to find par by request_uri")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        if (!isPar) {
            return false;
        }
        Par par = this.parService.getParAndValidateForAuthorizationRequest(authzRequest.getRequestUri(), authzRequest.getState(), authzRequest.getClientId());
        authzRequest.setRequestUri(null);
        authzRequest.setRequest(null);
        this.log.debug("Setting request parameters from PAR - {}", (Object)par);
        authzRequest.setResponseType(par.getAttributes().getResponseType());
        authzRequest.setResponseMode(par.getAttributes().getResponseMode());
        authzRequest.setScope(par.getAttributes().getScope());
        authzRequest.setPrompt(par.getAttributes().getPrompt());
        authzRequest.setRedirectUri(par.getAttributes().getRedirectUri());
        authzRequest.setAcrValues(par.getAttributes().getAcrValuesStr());
        authzRequest.setAmrValues(par.getAttributes().getAmrValuesStr());
        authzRequest.setCodeChallenge(par.getAttributes().getCodeChallenge());
        authzRequest.setCodeChallengeMethod(par.getAttributes().getCodeChallengeMethod());
        authzRequest.setState(org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)par.getAttributes().getState()) ? par.getAttributes().getState() : "");
        String authorizationDetails = par.getAttributes().getAuthorizationDetails();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)authorizationDetails)) {
            authzRequest.setAuthzDetailsString(authorizationDetails);
            authzRequest.setAuthzDetails(AuthzDetails.ofSilently((String)authorizationDetails));
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)par.getAttributes().getDpopJkt())) {
            authzRequest.setDpopJkt(par.getAttributes().getDpopJkt());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)par.getAttributes().getNonce())) {
            authzRequest.setNonce(par.getAttributes().getNonce());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)par.getAttributes().getSessionId())) {
            authzRequest.setSessionId(par.getAttributes().getSessionId());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)par.getAttributes().getCustomResponseHeaders())) {
            authzRequest.setCustomResponseHeaders(par.getAttributes().getCustomResponseHeaders());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)par.getAttributes().getClaims())) {
            authzRequest.setClaims(par.getAttributes().getClaims());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)par.getAttributes().getOriginHeaders())) {
            authzRequest.setOriginHeaders(par.getAttributes().getOriginHeaders());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)par.getAttributes().getUiLocales())) {
            authzRequest.setUiLocales(par.getAttributes().getUiLocales());
        }
        if (!par.getAttributes().getCustomParameters().isEmpty()) {
            if (authzRequest.getCustomParameters() == null) {
                authzRequest.setCustomParameters(new HashMap<String, String>());
            }
            authzRequest.getCustomParameters().putAll(par.getAttributes().getCustomParameters());
        }
        return isPar;
    }

    public void processRequestObject(AuthzRequest authzRequest, Client client, Set<String> scopes, User user) {
        HashSet jwtResponseModes;
        RedirectUriResponse redirectUriResponse = authzRequest.getRedirectUriResponse();
        JwtAuthorizationRequest jwtRequest = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)authzRequest.getRequest()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)authzRequest.getRequestUri())) {
            try {
                jwtRequest = JwtAuthorizationRequest.createJwtRequest(authzRequest.getRequest(), authzRequest.getRequestUri(), client, redirectUriResponse, this.cryptoProvider, this.appConfiguration);
                if (jwtRequest == null) {
                    throw this.authorizeRestWebServiceValidator.createInvalidJwtRequestException(redirectUriResponse, "Failed to parse jwt.");
                }
                authzRequest.setJwtRequest(jwtRequest);
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jwtRequest.getState())) {
                    authzRequest.setState(jwtRequest.getState());
                    redirectUriResponse.setState(authzRequest.getState());
                }
                if (this.appConfiguration.isFapi() && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)jwtRequest.getState())) {
                    authzRequest.setState("");
                    redirectUriResponse.setState("");
                }
                if (jwtRequest.getRedirectUri() != null) {
                    if (!jwtRequest.getRedirectUri().equals(authzRequest.getRedirectUri())) {
                        this.log.error("The redirect_uri parameter in url is not the same as in the JWT");
                        throw this.authorizeRestWebServiceValidator.createInvalidJwtRequestException(redirectUriResponse, "The redirect_uri parameter in url is not the same as in the JWT");
                    }
                    if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.redirectionUriService.validateRedirectionUri(client, jwtRequest.getRedirectUri()))) {
                        this.log.error("redirect_uri in request object is not valid.");
                        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_REDIRECT_URI, authzRequest.getState(), "")).build());
                    }
                    redirectUriResponse.getRedirectUri().setBaseRedirectUri(jwtRequest.getRedirectUri());
                }
                SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)jwtRequest.getAlgorithm());
                if (Boolean.TRUE.equals(this.appConfiguration.getForceSignedRequestObject()) && signatureAlgorithm == SignatureAlgorithm.NONE) {
                    throw this.authorizeRestWebServiceValidator.createInvalidJwtRequestException(redirectUriResponse, "A signed request object is required");
                }
                if (!jwtRequest.getScopes().isEmpty()) {
                    if (!scopes.contains("openid")) {
                        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_SCOPE, authzRequest.getState(), "scope parameter does not contain openid value which is required.")).build());
                    }
                    scopes.clear();
                    scopes.addAll(this.scopeChecker.checkScopesPolicy(client, Lists.newArrayList(jwtRequest.getScopes())));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jwtRequest.getNonce())) {
                    authzRequest.setNonce(jwtRequest.getNonce());
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jwtRequest.getCodeChallenge())) {
                    authzRequest.setCodeChallenge(jwtRequest.getCodeChallenge());
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jwtRequest.getCodeChallengeMethod())) {
                    authzRequest.setCodeChallengeMethod(jwtRequest.getCodeChallengeMethod());
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jwtRequest.getDpopJkt())) {
                    authzRequest.setDpopJkt(jwtRequest.getDpopJkt());
                }
                if (jwtRequest.getDisplay() != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)jwtRequest.getDisplay().getParamName())) {
                    authzRequest.setDisplay(jwtRequest.getDisplay().getParamName());
                }
                if (!jwtRequest.getPrompts().isEmpty()) {
                    authzRequest.setPromptList(jwtRequest.getPrompts());
                    authzRequest.setPromptFromJwt(true);
                }
                if (jwtRequest.getResponseMode() != null) {
                    authzRequest.setResponseMode(jwtRequest.getResponseMode().getValue());
                    redirectUriResponse.getRedirectUri().setResponseMode(jwtRequest.getResponseMode());
                }
                this.checkIdTokenMember(authzRequest, redirectUriResponse, user, jwtRequest);
                this.requestParameterService.getCustomParameters(jwtRequest, authzRequest.getCustomParameters());
            }
            catch (WebApplicationException e) {
                JsonWebResponse jwr = this.parseRequestToJwr(authzRequest.getRequest());
                if (jwr != null) {
                    String checkForAlg = jwr.getClaims().getClaimAsString("alg");
                    if ("none".equals(checkForAlg)) {
                        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT, "", "The None algorithm in nested JWT is not allowed for FAPI")).type(MediaType.APPLICATION_JSON_TYPE).build());
                    }
                    ResponseMode responseMode = ResponseMode.getByValue((String)jwr.getClaims().getClaimAsString("response_mode"));
                    if (responseMode == ResponseMode.JWT) {
                        authzRequest.setResponseMode(responseMode.getValue());
                        redirectUriResponse.getRedirectUri().setResponseMode(ResponseMode.JWT);
                        this.fillRedirectUriResponseforJARM(redirectUriResponse, jwr, client);
                        if (this.appConfiguration.isFapi()) {
                            this.authorizeRestWebServiceValidator.throwInvalidJwtRequestExceptionAsJwtMode(redirectUriResponse, INVALID_JWT_AUTHORIZATION_REQUEST, jwr.getClaims().getClaimAsString("state"), authzRequest.getHttpRequest());
                        }
                    }
                }
                throw e;
            }
            catch (Exception e) {
                this.log.error("Invalid JWT authorization request. Message : " + e.getMessage(), (Throwable)e);
                throw this.authorizeRestWebServiceValidator.createInvalidJwtRequestException(redirectUriResponse, INVALID_JWT_AUTHORIZATION_REQUEST);
            }
        }
        if ((jwtResponseModes = Sets.newHashSet((Object[])new ResponseMode[]{ResponseMode.QUERY_JWT, ResponseMode.FRAGMENT_JWT, ResponseMode.JWT, ResponseMode.FORM_POST_JWT})).contains(authzRequest.getResponseModeEnum())) {
            JsonWebResponse jwe = this.parseRequestToJwr(authzRequest.getRequest());
            this.fillRedirectUriResponseforJARM(redirectUriResponse, jwe, client);
        }
        if (jwtRequest != null) {
            this.authorizeRestWebServiceValidator.validateJwtRequest(authzRequest.getClientId(), authzRequest.getState(), authzRequest.getHttpRequest(), authzRequest.getResponseTypeList(), redirectUriResponse, jwtRequest);
        }
    }

    public void handleJwr(AuthzRequest authzRequest, Client client, RedirectUriResponse redirectUriResponse, JsonWebResponse jwr) {
        if (jwr == null) {
            return;
        }
        String checkForAlg = jwr.getClaims().getClaimAsString("alg");
        if ("none".equals(checkForAlg)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST_OBJECT, "", "The None algorithm in nested JWT is not allowed for FAPI")).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        ResponseMode responseMode = ResponseMode.getByValue((String)jwr.getClaims().getClaimAsString("response_mode"));
        if (responseMode == ResponseMode.JWT) {
            authzRequest.setResponseMode(responseMode.getValue());
            redirectUriResponse.getRedirectUri().setResponseMode(ResponseMode.JWT);
            this.fillRedirectUriResponseforJARM(redirectUriResponse, jwr, client);
            if (this.appConfiguration.isFapi()) {
                this.authorizeRestWebServiceValidator.throwInvalidJwtRequestExceptionAsJwtMode(redirectUriResponse, INVALID_JWT_AUTHORIZATION_REQUEST, jwr.getClaims().getClaimAsString("state"), authzRequest.getHttpRequest());
            }
        }
    }

    public void checkIdTokenMember(AuthzRequest authzRequest, RedirectUriResponse redirectUriResponse, User user, JwtAuthorizationRequest jwtRequest) {
        Claim userIdClaim;
        Claim acrClaim;
        IdTokenMember idTokenMember = jwtRequest.getIdTokenMember();
        if (idTokenMember == null) {
            return;
        }
        if (idTokenMember.getMaxAge() != null) {
            authzRequest.setMaxAge(idTokenMember.getMaxAge());
        }
        if ((acrClaim = idTokenMember.getClaim("acr")) != null && acrClaim.getClaimValue() != null) {
            authzRequest.setAcrValues(acrClaim.getClaimValue().getValueAsString());
            this.acrService.applyAcrMappings(authzRequest, this.appConfiguration);
            this.log.debug("ACR values {}", (Object)authzRequest.getAcrValues());
        }
        if ((userIdClaim = idTokenMember.getClaim("sub")) != null && userIdClaim.getClaimValue() != null && userIdClaim.getClaimValue().getValue() != null) {
            String userId;
            String userIdClaimValue = userIdClaim.getClaimValue().getValue();
            if (user != null && !(userId = user.getUserId()).equalsIgnoreCase(userIdClaimValue)) {
                throw new WebApplicationException(redirectUriResponse.createErrorBuilder((IErrorType)AuthorizeErrorResponseType.USER_MISMATCHED).build());
            }
        }
    }

    @Nullable
    public JsonWebResponse parseRequestToJwr(String request) {
        if (request == null) {
            return null;
        }
        String[] parts = request.split("\\.");
        try {
            if (parts.length == 5) {
                String encodedHeader = parts[0];
                JwtHeader jwtHeader = new JwtHeader(encodedHeader);
                String keyId = jwtHeader.getKeyId();
                PrivateKey privateKey = null;
                KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.fromName((String)jwtHeader.getClaimAsString("alg"));
                if (AlgorithmFamily.RSA.equals((Object)keyEncryptionAlgorithm.getFamily())) {
                    privateKey = this.cryptoProvider.getPrivateKey(keyId);
                }
                return Jwe.parse((String)request, privateKey, null);
            }
            return Jwt.parseSilently((String)request);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void fillRedirectUriResponseforJARM(RedirectUriResponse redirectUriResponse, JsonWebResponse jwr, Client client) {
        try {
            String tempRedirectUri;
            if (jwr != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(tempRedirectUri = jwr.getClaims().getClaimAsString("redirect_uri")))) {
                redirectUriResponse.getRedirectUri().setBaseRedirectUri(URLDecoder.decode(tempRedirectUri, "UTF-8"));
            }
            String clientId = client.getClientId();
            redirectUriResponse.getRedirectUri().setIssuer(this.appConfiguration.getIssuer());
            redirectUriResponse.getRedirectUri().setAudience(clientId);
            redirectUriResponse.getRedirectUri().setAuthorizationCodeLifetime(this.appConfiguration.getAuthorizationCodeLifetime());
            redirectUriResponse.getRedirectUri().setSignatureAlgorithm(SignatureAlgorithm.fromString((String)client.getAttributes().getAuthorizationSignedResponseAlg()));
            redirectUriResponse.getRedirectUri().setKeyEncryptionAlgorithm(KeyEncryptionAlgorithm.fromName((String)client.getAttributes().getAuthorizationEncryptedResponseAlg()));
            redirectUriResponse.getRedirectUri().setBlockEncryptionAlgorithm(BlockEncryptionAlgorithm.fromName((String)client.getAttributes().getAuthorizationEncryptedResponseEnc()));
            redirectUriResponse.getRedirectUri().setCryptoProvider(this.cryptoProvider);
            String keyId = null;
            if (client.getAttributes().getAuthorizationEncryptedResponseAlg() != null && client.getAttributes().getAuthorizationEncryptedResponseEnc() != null) {
                JSONObject jsonWebKeys;
                if (client.getAttributes().getAuthorizationSignedResponseAlg() != null) {
                    SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.fromString((String)client.getAttributes().getAuthorizationSignedResponseAlg());
                    String nestedKeyId = new ServerCryptoProvider(this.cryptoProvider).getKeyId((JSONWebKeySet)this.webKeysConfiguration, Algorithm.fromString((String)signatureAlgorithm.getName()), Use.SIGNATURE, KeyOpsType.CONNECT);
                    JSONObject jsonWebKeys2 = CommonUtils.getJwks((Client)client);
                    redirectUriResponse.getRedirectUri().setNestedJsonWebKeys(jsonWebKeys2);
                    String clientSecret = this.clientService.decryptSecret(client.getClientSecret());
                    redirectUriResponse.getRedirectUri().setNestedSharedSecret(clientSecret);
                    redirectUriResponse.getRedirectUri().setNestedKeyId(nestedKeyId);
                }
                if ((jsonWebKeys = CommonUtils.getJwks((Client)client)) != null) {
                    keyId = new ServerCryptoProvider(this.cryptoProvider).getKeyId(JSONWebKeySet.fromJSONObject((JSONObject)jsonWebKeys), Algorithm.fromString((String)client.getAttributes().getAuthorizationEncryptedResponseAlg()), Use.ENCRYPTION, KeyOpsType.CONNECT);
                }
                String sharedSecret = this.clientService.decryptSecret(client.getClientSecret());
                byte[] sharedSymmetricKey = sharedSecret.getBytes(StandardCharsets.UTF_8);
                redirectUriResponse.getRedirectUri().setSharedSymmetricKey(sharedSymmetricKey);
                redirectUriResponse.getRedirectUri().setJsonWebKeys(jsonWebKeys);
                redirectUriResponse.getRedirectUri().setKeyId(keyId);
            } else {
                SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.RS256;
                if (client.getAttributes().getAuthorizationSignedResponseAlg() != null) {
                    signatureAlgorithm = SignatureAlgorithm.fromString((String)client.getAttributes().getAuthorizationSignedResponseAlg());
                }
                keyId = new ServerCryptoProvider(this.cryptoProvider).getKeyId((JSONWebKeySet)this.webKeysConfiguration, Algorithm.fromString((String)signatureAlgorithm.getName()), Use.SIGNATURE, KeyOpsType.CONNECT);
                JSONObject jsonWebKeys = CommonUtils.getJwks((Client)client);
                redirectUriResponse.getRedirectUri().setJsonWebKeys(jsonWebKeys);
                String clientSecret = this.clientService.decryptSecret(client.getClientSecret());
                redirectUriResponse.getRedirectUri().setSharedSecret(clientSecret);
                redirectUriResponse.getRedirectUri().setKeyId(keyId);
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setAcrsIfNeeded(AuthzRequest authzRequest) {
        Client client = authzRequest.getClient();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)authzRequest.getAcrValues())) {
            if (!ArrayUtils.isEmpty((Object[])client.getDefaultAcrValues())) {
                authzRequest.setAcrValues(StringUtils.implode((String[])client.getDefaultAcrValues(), (String)" "));
            }
            return;
        }
        int currentMinAcrLevel = this.getCurrentMinAcrLevel(authzRequest);
        if (currentMinAcrLevel >= client.getAttributes().getMinimumAcrLevel()) {
            return;
        }
        if (BooleanUtils.isNotTrue((Boolean)client.getAttributes().getMinimumAcrLevelAutoresolve())) {
            this.log.error("Current acr level is less then minimum required. currentMinAcrLevel: {}, clientMinAcrLevel: {}", (Object)currentMinAcrLevel, (Object)client.getAttributes().getMinimumAcrLevel());
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, authzRequest.getState(), "Current acr level is less then minimum required by client")).build());
        }
        Map<String, Integer> acrToLevelMap = this.getAcrToLevelMap();
        if (client.getAttributes().getMinimumAcrPriorityList().isEmpty()) {
            for (Map.Entry<String, Integer> entry : acrToLevelMap.entrySet()) {
                if (currentMinAcrLevel >= entry.getValue()) continue;
                authzRequest.setAcrValues(entry.getKey());
                return;
            }
        }
        for (String acr : client.getAttributes().getMinimumAcrPriorityList()) {
            Integer acrLevel = acrToLevelMap.get(acr);
            if (acrLevel == null || acrLevel < currentMinAcrLevel) continue;
            authzRequest.setAcrValues(acr);
            return;
        }
        this.log.error("Current acr level is less then minimum required by client. currentMinAcrLevel: {}, clientAttributes: {}", (Object)currentMinAcrLevel, (Object)client.getAttributes());
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, authzRequest.getState(), "Current acr level is less then minimum required by client:" + client.getClientId())).build());
    }

    public int getCurrentMinAcrLevel(AuthzRequest authzRequest) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)authzRequest.getAcrValues())) {
            return -1;
        }
        Integer currentLevel = null;
        Map<String, Integer> acrToLevelMap = this.getAcrToLevelMap();
        for (String acr : authzRequest.getAcrValuesList()) {
            Integer level = acrToLevelMap.get(acr);
            if (currentLevel == null) {
                currentLevel = level;
                continue;
            }
            if (level == null || level >= currentLevel) continue;
            currentLevel = level;
        }
        return currentLevel != null ? currentLevel : -1;
    }

    public void createRedirectUriResponse(AuthzRequest authzRequest) {
        RedirectUriResponse redirectUriResponse = new RedirectUriResponse(new RedirectUri(authzRequest.getRedirectUri(), authzRequest.getResponseTypeList(), authzRequest.getResponseModeEnum()), authzRequest.getState(), authzRequest.getHttpRequest(), this.errorResponseFactory);
        redirectUriResponse.setFapiCompatible(this.appConfiguration.isFapi());
        authzRequest.setRedirectUriResponse(redirectUriResponse);
    }

    public static boolean canLogWebApplicationException(WebApplicationException e) {
        if (e == null || e.getResponse() == null) {
            return false;
        }
        int status = e.getResponse().getStatus();
        return status != 302;
    }

    public void createOauth2AuditLog(AuthzRequest authzRequest) {
        this.createOauth2AuditLog(authzRequest, Action.USER_AUTHORIZATION);
    }

    public void createOauth2AuditLog(AuthzRequest authzRequest, Action action) {
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(authzRequest.getHttpRequest()), action);
        oAuth2AuditLog.setClientId(authzRequest.getClientId());
        oAuth2AuditLog.setScope(authzRequest.getScope());
        authzRequest.setAuditLog(oAuth2AuditLog);
    }

    public void setCustomParameters(AuthzRequest authzRequest) {
        HttpServletRequest httpRequest = authzRequest.getHttpRequest();
        authzRequest.setCustomParameters(this.requestParameterService.getCustomParameters(QueryStringDecoder.decode((String)httpRequest.getQueryString())));
        if (authzRequest.getCustomParameters() == null) {
            authzRequest.setCustomParameters(new HashMap<String, String>());
        }
        if ("POST".endsWith(authzRequest.getHttpMethod())) {
            this.requestParameterService.addCustomParameters(httpRequest, authzRequest.getCustomParameters());
        }
    }
}

