/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authorize.ws.rs;

import io.jans.as.common.model.registration.Client;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.common.GrantType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.token.TokenErrorResponseType;
import io.jans.as.model.util.StringUtils;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.authorize.ws.rs.DeviceAuthorizationRestWebService;
import io.jans.as.server.model.audit.Action;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.authorize.ScopeChecker;
import io.jans.as.server.model.common.DeviceAuthorizationCacheControl;
import io.jans.as.server.model.common.DeviceAuthorizationStatus;
import io.jans.as.server.model.session.SessionClient;
import io.jans.as.server.security.Identity;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.DeviceAuthorizationService;
import io.jans.as.server.util.ServerUtil;
import io.jans.util.StringHelper;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@Path(value="/")
public class DeviceAuthorizationRestWebServiceImpl
implements DeviceAuthorizationRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private Identity identity;
    @Inject
    private ScopeChecker scopeChecker;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private DeviceAuthorizationService deviceAuthorizationService;
    @Inject
    private ClientService clientService;

    @Override
    public Response deviceAuthorization(String clientId, String scope, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext securityContext) {
        scope = ServerUtil.urlDecode(scope);
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpRequest), Action.DEVICE_CODE_AUTHORIZATION);
        oAuth2AuditLog.setClientId(clientId);
        oAuth2AuditLog.setScope(scope);
        try {
            Client client;
            this.log.debug("Attempting to request device codes: clientId = {}, scope = {}", (Object)clientId, (Object)scope);
            this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.DEVICE_AUTHZ);
            SessionClient sessionClient = this.identity.getSessionClient();
            Client client2 = client = sessionClient != null ? sessionClient.getClient() : null;
            if (client == null && !this.clientService.isPublic(client = this.clientService.getClient(clientId))) {
                this.log.trace("Client is not public and not authenticated. Skip device authorization, clientId: {}", (Object)clientId);
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)TokenErrorResponseType.INVALID_CLIENT, "");
            }
            if (client == null) {
                this.log.trace("Client is not unknown. Skip revoking.");
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.UNAUTHORIZED, (IErrorType)TokenErrorResponseType.INVALID_CLIENT, "");
            }
            if (!this.deviceAuthorizationService.hasDeviceCodeCompatibility(client)) {
                this.log.trace("Device code grant type ({}) is not added to the client {}", (Object)GrantType.DEVICE_CODE.getValue(), (Object)client.getClientId());
                throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)TokenErrorResponseType.INVALID_GRANT, "");
            }
            ArrayList<String> scopes = new ArrayList<String>();
            if (StringHelper.isNotEmpty((String)scope)) {
                Set<String> grantedScopes = this.scopeChecker.checkScopesPolicy(client, scope);
                scopes.addAll(grantedScopes);
            }
            String userCode = StringUtils.generateRandomReadableCode((byte)8);
            String deviceCode = StringUtils.generateRandomCode((byte)24);
            URI verificationUri = UriBuilder.fromUri((String)this.appConfiguration.getIssuer()).path("device-code").build(new Object[0]);
            int expiresIn = this.appConfiguration.getDeviceAuthzRequestExpiresIn();
            int interval = this.appConfiguration.getDeviceAuthzTokenPollInterval();
            long lastAccess = System.currentTimeMillis();
            DeviceAuthorizationStatus status = DeviceAuthorizationStatus.PENDING;
            DeviceAuthorizationCacheControl deviceAuthorizationCacheControl = new DeviceAuthorizationCacheControl(userCode, deviceCode, client, scopes, verificationUri, expiresIn, interval, lastAccess, status);
            this.deviceAuthorizationService.saveInCache(deviceAuthorizationCacheControl, true, true);
            this.log.info("Device authorization flow initiated, userCode: {}, deviceCode: {}, clientId: {}, verificationUri: {}, expiresIn: {}, interval: {}, scopes: {}", new Object[]{userCode, deviceCode, clientId, verificationUri, expiresIn, interval, scopes});
            this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
            return Response.ok().entity((Object)this.getResponseJSONObject(deviceAuthorizationCacheControl).toString(4).replace("\\/", "/")).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (WebApplicationException wae) {
            throw wae;
        }
        catch (Exception e) {
            this.log.error("Problems processing device authorization init flow, clientId: {}, scope: {}", new Object[]{clientId, scope, e});
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private JSONObject getResponseJSONObject(DeviceAuthorizationCacheControl deviceAuthorizationCacheControl) throws JSONException {
        URI verificationUriComplete = UriBuilder.fromUri((URI)deviceAuthorizationCacheControl.getVerificationUri()).queryParam("user_code", new Object[]{deviceAuthorizationCacheControl.getUserCode()}).build(new Object[0]);
        JSONObject responseJsonObject = new JSONObject();
        responseJsonObject.put("device_code", (Object)deviceAuthorizationCacheControl.getDeviceCode());
        responseJsonObject.put("user_code", (Object)deviceAuthorizationCacheControl.getUserCode());
        responseJsonObject.put("verification_uri", (Object)deviceAuthorizationCacheControl.getVerificationUri());
        responseJsonObject.put("verification_uri_complete", (Object)verificationUriComplete.toString());
        responseJsonObject.put("expires_in", deviceAuthorizationCacheControl.getExpiresIn());
        responseJsonObject.put("interval", deviceAuthorizationCacheControl.getInterval());
        return responseJsonObject;
    }
}

