/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authorize.ws.rs;

import io.jans.as.common.model.session.SessionId;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.util.Base64Util;
import io.jans.as.server.i18n.LanguageBean;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.service.external.ExternalAuthenticationService;
import io.jans.jsf2.service.FacesService;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.service.JsonService;
import io.jans.util.StringHelper;
import jakarta.enterprise.context.RequestScoped;
import jakarta.faces.application.FacesMessage;
import jakarta.faces.context.FacesContext;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@RequestScoped
@Named
public class LogoutAction {
    private static final String EXTERNAL_LOGOUT = "external_logout";
    private static final String EXTERNAL_LOGOUT_DATA = "external_logout_data";
    @Inject
    private Logger log;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private JsonService jsonService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private FacesService facesService;
    @Inject
    private FacesContext facesContext;
    @Inject
    private LanguageBean languageBean;
    private String idTokenHint;
    private String postLogoutRedirectUri;
    private SessionId sessionId;

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public void setIdTokenHint(String idTokenHint) {
        this.idTokenHint = idTokenHint;
    }

    public String getPostLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }

    public void redirect() {
        ExternalLogoutResult externalLogoutResult;
        SessionId sessionId = this.sessionIdService.getSessionId();
        boolean validationResult = this.validateParameters();
        if (!validationResult) {
            try {
                this.restoreLogoutParametersFromSession(sessionId);
            }
            catch (IOException ex) {
                this.logoutFailed();
                this.log.debug("Failed to restore logout parameters from session", (Throwable)ex);
            }
            validationResult = this.validateParameters();
            if (!validationResult) {
                this.missingLogoutParameters();
                return;
            }
        }
        if (ExternalLogoutResult.FAILURE == (externalLogoutResult = this.processExternalAuthenticatorLogOut(sessionId))) {
            this.logoutFailed();
            return;
        }
        if (ExternalLogoutResult.REDIRECT == externalLogoutResult) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        if (this.idTokenHint != null && !this.idTokenHint.isEmpty()) {
            sb.append("id_token_hint=").append(this.idTokenHint);
        }
        if (sessionId != null && !this.postLogoutRedirectUri.isEmpty()) {
            sb.append("&sid=").append(sessionId.getOutsideSid());
        }
        if (this.postLogoutRedirectUri != null && !this.postLogoutRedirectUri.isEmpty()) {
            sb.append("&post_logout_redirect_uri=").append(this.postLogoutRedirectUri);
        }
        this.facesService.redirectToExternalURL("restv1/end_session?" + sb.toString());
    }

    private boolean validateParameters() {
        return (StringHelper.isNotEmpty((String)this.idTokenHint) || this.sessionId != null) && StringHelper.isNotEmpty((String)this.postLogoutRedirectUri);
    }

    private ExternalLogoutResult processExternalAuthenticatorLogOut(SessionId sessionId) {
        Boolean endSessionWithAccessToken;
        if (sessionId != null && sessionId.getSessionAttributes().containsKey(EXTERNAL_LOGOUT)) {
            this.log.debug("Detected callback from external system. Resuming logout.");
            return ExternalLogoutResult.SUCCESS;
        }
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByIdToken(this.idTokenHint);
        if (authorizationGrant == null && (endSessionWithAccessToken = this.appConfiguration.getEndSessionWithAccessToken()) != null && endSessionWithAccessToken.booleanValue()) {
            authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(this.idTokenHint);
        }
        if (authorizationGrant == null && sessionId == null) {
            return ExternalLogoutResult.FAILURE;
        }
        String acrValues = authorizationGrant == null ? this.sessionIdService.getAcr(sessionId) : authorizationGrant.getAcrValues();
        boolean isExternalAuthenticatorLogoutPresent = StringHelper.isNotEmpty((String)acrValues);
        if (isExternalAuthenticatorLogoutPresent) {
            this.log.debug("Attemptinmg to execute logout method of '{}' external authenticator.", (Object)acrValues);
            CustomScriptConfiguration customScriptConfiguration = this.externalAuthenticationService.getCustomScriptConfigurationByName(acrValues);
            if (customScriptConfiguration == null) {
                this.log.error("Failed to get ExternalAuthenticatorConfiguration. acr_values: {}", (Object)acrValues);
                return ExternalLogoutResult.FAILURE;
            }
            boolean scriptExternalLogoutResult = this.externalAuthenticationService.executeExternalLogout(customScriptConfiguration, null);
            ExternalLogoutResult externalLogoutResult = scriptExternalLogoutResult ? ExternalLogoutResult.SUCCESS : ExternalLogoutResult.FAILURE;
            String userDn = sessionId != null ? sessionId.getUserDn() : "";
            String sId = sessionId != null ? sessionId.getId() : "";
            this.log.debug("Logout result is '{}' for session '{}', userDn: '{}'", new Object[]{externalLogoutResult, sId, userDn});
            int apiVersion = this.externalAuthenticationService.executeExternalGetApiVersion(customScriptConfiguration);
            if (apiVersion < 3) {
                return externalLogoutResult;
            }
            this.log.trace("According to API version script supports logout redirects");
            String logoutExternalUrl = this.externalAuthenticationService.getLogoutExternalUrl(customScriptConfiguration, null);
            this.log.debug("External logout result is '{}' for user '{}'", (Object)logoutExternalUrl, (Object)userDn);
            if (StringHelper.isEmpty((String)logoutExternalUrl)) {
                return externalLogoutResult;
            }
            try {
                this.storeLogoutParametersInSession(sessionId);
            }
            catch (IOException ex) {
                this.log.debug("Failed to persist logout parameters in session", (Throwable)ex);
                return ExternalLogoutResult.FAILURE;
            }
            this.facesService.redirectToExternalURL(logoutExternalUrl);
            return ExternalLogoutResult.REDIRECT;
        }
        return ExternalLogoutResult.SUCCESS;
    }

    private void storeLogoutParametersInSession(@Nullable SessionId sessionId) throws IOException {
        if (sessionId == null) {
            return;
        }
        Map sessionAttributes = sessionId.getSessionAttributes();
        LogoutParameters logoutParameters = new LogoutParameters(this.idTokenHint, this.postLogoutRedirectUri);
        String logoutParametersJson = this.jsonService.objectToJson((Object)logoutParameters);
        String logoutParametersBase64 = Base64Util.base64urlencode((byte[])logoutParametersJson.getBytes(StandardCharsets.UTF_8));
        sessionAttributes.put(EXTERNAL_LOGOUT, Boolean.toString(true));
        sessionAttributes.put(EXTERNAL_LOGOUT_DATA, logoutParametersBase64);
        this.sessionIdService.updateSessionId(sessionId);
    }

    private boolean restoreLogoutParametersFromSession(SessionId sessionId) throws IllegalArgumentException, IOException {
        if (sessionId == null) {
            return false;
        }
        this.sessionId = sessionId;
        Map sessionAttributes = sessionId.getSessionAttributes();
        boolean restoreParameters = sessionAttributes.containsKey(EXTERNAL_LOGOUT);
        if (!restoreParameters) {
            return false;
        }
        String logoutParametersBase64 = (String)sessionAttributes.get(EXTERNAL_LOGOUT_DATA);
        String logoutParametersJson = new String(Base64Util.base64urldecode((String)logoutParametersBase64), StandardCharsets.UTF_8);
        LogoutParameters logoutParameters = (LogoutParameters)this.jsonService.jsonToObject(logoutParametersJson, LogoutParameters.class);
        this.idTokenHint = logoutParameters.getIdTokenHint();
        this.postLogoutRedirectUri = logoutParameters.getPostLogoutRedirectUri();
        return true;
    }

    public void missingLogoutParameters() {
        String message = this.languageBean.getMessage("logout.missingParameters");
        this.facesContext.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, message, message));
        this.facesService.redirect("/error.xhtml");
    }

    public void logoutFailed() {
        String message = this.languageBean.getMessage("logout.failedToProceed");
        this.facesContext.addMessage(null, new FacesMessage(FacesMessage.SEVERITY_ERROR, message, message));
        this.facesService.redirect("/error.xhtml");
    }

    private static enum ExternalLogoutResult {
        SUCCESS,
        FAILURE,
        REDIRECT;

    }

    public static class LogoutParameters {
        private String idTokenHint;
        private String postLogoutRedirectUri;

        public LogoutParameters() {
        }

        public LogoutParameters(String idTokenHint, String postLogoutRedirectUri) {
            this.idTokenHint = idTokenHint;
            this.postLogoutRedirectUri = postLogoutRedirectUri;
        }

        public String getIdTokenHint() {
            return this.idTokenHint;
        }

        public void setIdTokenHint(String idTokenHint) {
            this.idTokenHint = idTokenHint;
        }

        public String getPostLogoutRedirectUri() {
            return this.postLogoutRedirectUri;
        }

        public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
            this.postLogoutRedirectUri = postLogoutRedirectUri;
        }
    }
}

