/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authzen.ws.rs;

import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.service.DiscoveryService;
import io.jans.as.server.service.LocalResponseCache;
import io.jans.as.server.service.external.ExternalAccessEvaluationDiscoveryService;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
public class AccessEvaluationDiscoveryService {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private LocalResponseCache localResponseCache;
    @Inject
    private ExternalAccessEvaluationDiscoveryService externalAccessEvaluationDiscoveryService;

    public JSONObject discovery(ExecutionContext context) {
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.ACCESS_EVALUATION);
        JSONObject cachedResponse = this.localResponseCache.getAccessEvaluationDiscoveryResponse();
        if (cachedResponse != null) {
            this.log.trace("Cached access evaluation discovery response returned.");
            return cachedResponse;
        }
        JSONObject jsonObj = this.createResponse();
        JSONObject clone = new JSONObject(jsonObj.toString());
        if (!this.externalAccessEvaluationDiscoveryService.modifyDiscovery(jsonObj, context)) {
            jsonObj = clone;
        }
        this.localResponseCache.putAccessEvaluationDiscoveryResponse(jsonObj);
        return jsonObj;
    }

    private JSONObject createResponse() {
        JSONObject jsonObj = new JSONObject();
        if (this.appConfiguration.isFeatureEnabled(FeatureFlagType.ACCESS_EVALUATION)) {
            jsonObj.put("access_evaluation_v1_endpoint", (Object)DiscoveryService.getAccessEvaluationV1Endpoint(this.appConfiguration));
        }
        return jsonObj;
    }
}

