/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.authzen.ws.rs;

import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.gluu.GluuErrorResponseType;
import io.jans.as.server.authzen.ws.rs.AccessEvaluationDiscoveryService;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.util.ServerUtil;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.json.JSONObject;
import org.slf4j.Logger;

@Path(value="/authzen-configuration")
public class AccessEvaluationDiscoveryWS {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AccessEvaluationDiscoveryService accessEvaluationDiscoveryService;

    @GET
    @Produces(value={"application/json"})
    public Response getDiscovery(@Context HttpServletRequest httpRequest, @Context HttpServletResponse httpResponse) {
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.ACCESS_EVALUATION);
        try {
            ExecutionContext context = new ExecutionContext(httpRequest, httpResponse);
            JSONObject response = this.accessEvaluationDiscoveryService.discovery(context);
            String entity = ServerUtil.toPrettyJson(response).replace("\\/", "/");
            this.log.trace("AuthZen Discovery: {}", (Object)entity);
            return Response.ok((Object)entity).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.INTERNAL_SERVER_ERROR, (IErrorType)GluuErrorResponseType.SERVER_ERROR, "Internal error.");
        }
    }
}

