/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.bcauthorize.ws.rs;

import io.jans.as.client.JwkClient;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.service.common.UserService;
import io.jans.as.model.ciba.BackchannelAuthenticationErrorResponseType;
import io.jans.as.model.common.BackchannelTokenDeliveryMode;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.crypto.AbstractCryptoProvider;
import io.jans.as.model.crypto.signature.AlgorithmFamily;
import io.jans.as.model.crypto.signature.ECDSAPublicKey;
import io.jans.as.model.crypto.signature.RSAPublicKey;
import io.jans.as.model.crypto.signature.SignatureAlgorithm;
import io.jans.as.model.error.DefaultErrorResponse;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.exception.InvalidClaimException;
import io.jans.as.model.exception.InvalidJwtException;
import io.jans.as.model.jws.ECDSASigner;
import io.jans.as.model.jws.RSASigner;
import io.jans.as.model.jwt.Jwt;
import io.jans.as.server.audit.ApplicationAuditLogger;
import io.jans.as.server.authorize.ws.rs.AuthorizeRestWebServiceValidator;
import io.jans.as.server.bcauthorize.ws.rs.BackchannelAuthorizeRestWebService;
import io.jans.as.server.ciba.CIBAAuthorizeParamsValidatorService;
import io.jans.as.server.ciba.CIBAEndUserNotificationService;
import io.jans.as.server.model.audit.Action;
import io.jans.as.server.model.audit.OAuth2AuditLog;
import io.jans.as.server.model.authorize.JwtAuthorizationRequest;
import io.jans.as.server.model.authorize.ScopeChecker;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.model.common.CibaRequestCacheControl;
import io.jans.as.server.model.session.SessionClient;
import io.jans.as.server.security.Identity;
import io.jans.as.server.service.ciba.CibaRequestService;
import io.jans.as.server.util.ServerUtil;
import io.jans.util.StringHelper;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

@Path(value="/")
public class BackchannelAuthorizeRestWebServiceImpl
implements BackchannelAuthorizeRestWebService {
    @Inject
    private Logger log;
    @Inject
    private Identity identity;
    @Inject
    private UserService userService;
    @Inject
    private ApplicationAuditLogger applicationAuditLogger;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ScopeChecker scopeChecker;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private CIBAAuthorizeParamsValidatorService cibaAuthorizeParamsValidatorService;
    @Inject
    private CIBAEndUserNotificationService cibaEndUserNotificationService;
    @Inject
    private CibaRequestService cibaRequestService;
    @Inject
    private AbstractCryptoProvider cryptoProvider;
    @Inject
    private AuthorizeRestWebServiceValidator authorizeRestWebServiceValidator;

    @Override
    public Response requestBackchannelAuthorizationPost(String clientId, String scope, String clientNotificationToken, String acrValues, String loginHintToken, String idTokenHint, String loginHint, String bindingMessage, String userCodeParam, Integer requestedExpiry, String request, String requestUri, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext securityContext) {
        scope = ServerUtil.urlDecode(scope);
        OAuth2AuditLog oAuth2AuditLog = new OAuth2AuditLog(ServerUtil.getIpAddress(httpRequest), Action.BACKCHANNEL_AUTHENTICATION);
        oAuth2AuditLog.setClientId(clientId);
        oAuth2AuditLog.setScope(scope);
        this.log.debug("Attempting to request backchannel authorization: clientId = {}, scope = {}, clientNotificationToken = {}, acrValues = {}, loginHintToken = {}, idTokenHint = {}, loginHint = {}, bindingMessage = {}, userCodeParam = {}, requestedExpiry = {}, request= {}", new Object[]{clientId, scope, clientNotificationToken, acrValues, loginHintToken, idTokenHint, loginHint, bindingMessage, userCodeParam, requestedExpiry, request});
        this.log.debug("Attempting to request backchannel authorization: isSecure = {}", (Object)securityContext.isSecure());
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.CIBA);
        Response.ResponseBuilder builder = Response.ok();
        SessionClient sessionClient = this.identity.getSessionClient();
        Client client = null;
        if (sessionClient != null) {
            client = sessionClient.getClient();
        }
        if (client == null) {
            builder = Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode());
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_CLIENT));
            return builder.build();
        }
        if (!this.cibaRequestService.hasCibaCompatibility(client)) {
            builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST));
            return builder.build();
        }
        ArrayList<String> scopes = new ArrayList<String>();
        if (StringHelper.isNotEmpty((String)scope)) {
            Set<String> grantedScopes = this.scopeChecker.checkScopesPolicy(client, scope);
            scopes.addAll(grantedScopes);
        }
        JwtAuthorizationRequest jwtRequest = null;
        if (StringUtils.isNotBlank((CharSequence)request) || StringUtils.isNotBlank((CharSequence)requestUri)) {
            jwtRequest = JwtAuthorizationRequest.createJwtRequest(request, requestUri, client, null, this.cryptoProvider, this.appConfiguration);
            if (jwtRequest == null) {
                this.log.error("The JWT couldn't be processed");
                builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
                builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST));
                throw new WebApplicationException(builder.build());
            }
            this.authorizeRestWebServiceValidator.validateCibaRequestObject(jwtRequest, client.getClientId());
            if (!jwtRequest.getScopes().isEmpty()) {
                scopes.addAll(this.scopeChecker.checkScopesPolicy(client, jwtRequest.getScopes()));
            }
            if (StringUtils.isNotBlank((CharSequence)jwtRequest.getClientNotificationToken())) {
                clientNotificationToken = jwtRequest.getClientNotificationToken();
            }
            if (StringUtils.isNotBlank((CharSequence)jwtRequest.getAcrValues())) {
                acrValues = jwtRequest.getAcrValues();
            }
            if (StringUtils.isNotBlank((CharSequence)jwtRequest.getLoginHintToken())) {
                loginHintToken = jwtRequest.getLoginHintToken();
            }
            if (StringUtils.isNotBlank((CharSequence)jwtRequest.getIdTokenHint())) {
                idTokenHint = jwtRequest.getIdTokenHint();
            }
            if (StringUtils.isNotBlank((CharSequence)jwtRequest.getLoginHint())) {
                loginHint = jwtRequest.getLoginHint();
            }
            if (StringUtils.isNotBlank((CharSequence)jwtRequest.getBindingMessage())) {
                bindingMessage = jwtRequest.getBindingMessage();
            }
            if (StringUtils.isNotBlank((CharSequence)jwtRequest.getUserCode())) {
                userCodeParam = jwtRequest.getUserCode();
            }
            if (jwtRequest.getRequestedExpiry() != null) {
                requestedExpiry = jwtRequest.getRequestedExpiry();
            } else if (jwtRequest.getExp() != null) {
                requestedExpiry = Math.toIntExact((long)jwtRequest.getExp().intValue() - System.currentTimeMillis() / 1000L);
            }
        }
        if (this.appConfiguration.isFapi() && jwtRequest == null) {
            builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST));
            return builder.build();
        }
        User user = null;
        try {
            if (Strings.isNotBlank((String)loginHint)) {
                user = this.userService.getUniqueUserByAttributes(this.appConfiguration.getBackchannelLoginHintClaims(), loginHint);
            } else if (Strings.isNotBlank((String)idTokenHint)) {
                AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByIdToken(idTokenHint);
                if (authorizationGrant == null) {
                    builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
                    builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.UNKNOWN_USER_ID));
                    return builder.build();
                }
                user = authorizationGrant.getUser();
            }
            if (Strings.isNotBlank((String)loginHintToken)) {
                RSAPublicKey publicKey;
                Jwt jwt = Jwt.parse((String)loginHintToken);
                SignatureAlgorithm algorithm = jwt.getHeader().getSignatureAlgorithm();
                String keyId = jwt.getHeader().getKeyId();
                if (algorithm == null || Strings.isBlank((String)keyId)) {
                    builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
                    builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.UNKNOWN_USER_ID));
                    return builder.build();
                }
                boolean validSignature = false;
                if (algorithm.getFamily() == AlgorithmFamily.RSA) {
                    publicKey = JwkClient.getRSAPublicKey((String)client.getJwksUri(), (String)keyId);
                    RSASigner rsaSigner = new RSASigner(algorithm, publicKey);
                    validSignature = rsaSigner.validate(jwt);
                } else if (algorithm.getFamily() == AlgorithmFamily.EC) {
                    publicKey = JwkClient.getECDSAPublicKey((String)client.getJwksUri(), (String)keyId);
                    ECDSASigner ecdsaSigner = new ECDSASigner(algorithm, (ECDSAPublicKey)publicKey);
                    validSignature = ecdsaSigner.validate(jwt);
                }
                if (!validSignature) {
                    builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
                    builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.UNKNOWN_USER_ID));
                    return builder.build();
                }
                JSONObject subject = jwt.getClaims().getClaimAsJSON("subject");
                if (subject == null || !subject.has("subject_type") || !subject.has(subject.getString("subject_type"))) {
                    builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
                    builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.UNKNOWN_USER_ID));
                    return builder.build();
                }
                String subjectTypeKey = subject.getString("subject_type");
                String subjectTypeValue = subject.getString(subjectTypeKey);
                user = this.userService.getUniqueUserByAttributes(this.appConfiguration.getBackchannelLoginHintClaims(), subjectTypeValue);
            }
        }
        catch (InvalidJwtException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (JSONException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        if (user == null) {
            builder = Response.status((int)Response.Status.BAD_REQUEST.getStatusCode());
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.UNKNOWN_USER_ID));
            return builder.build();
        }
        try {
            String userCode = (String)user.getAttribute("jansBackchannelUsrCode", true, false);
            DefaultErrorResponse cibaAuthorizeParamsValidation = this.cibaAuthorizeParamsValidatorService.validateParams(scopes, clientNotificationToken, client.getBackchannelTokenDeliveryMode(), loginHintToken, idTokenHint, loginHint, bindingMessage, client.getBackchannelUserCodeParameter(), userCodeParam, userCode, requestedExpiry);
            if (cibaAuthorizeParamsValidation != null) {
                builder = Response.status((int)cibaAuthorizeParamsValidation.getStatus());
                builder.entity((Object)this.errorResponseFactory.errorAsJson(cibaAuthorizeParamsValidation.getType(), cibaAuthorizeParamsValidation.getReason()));
                return builder.build();
            }
            String deviceRegistrationToken = (String)user.getAttribute("jansBackchannelDeviceRegistrationTkn", true, false);
            if (deviceRegistrationToken == null) {
                builder = Response.status((int)Response.Status.UNAUTHORIZED.getStatusCode());
                builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.UNAUTHORIZED_END_USER_DEVICE));
                return builder.build();
            }
            int expiresIn = requestedExpiry != null ? requestedExpiry.intValue() : this.appConfiguration.getBackchannelAuthenticationResponseExpiresIn();
            Integer interval = client.getBackchannelTokenDeliveryMode() == BackchannelTokenDeliveryMode.PUSH ? null : Integer.valueOf(this.appConfiguration.getBackchannelAuthenticationResponseInterval());
            long currentTime = new Date().getTime();
            CibaRequestCacheControl cibaRequestCacheControl = new CibaRequestCacheControl(user, client, expiresIn, scopes, clientNotificationToken, bindingMessage, currentTime, acrValues);
            this.cibaRequestService.save(cibaRequestCacheControl, expiresIn);
            String authReqId = cibaRequestCacheControl.getAuthReqId();
            this.cibaEndUserNotificationService.notifyEndUser(cibaRequestCacheControl.getScopesAsString(), cibaRequestCacheControl.getAcrValues(), authReqId, deviceRegistrationToken);
            builder.entity((Object)this.getJSONObject(authReqId, expiresIn, interval).toString(4).replace("\\/", "/"));
            builder.type(MediaType.APPLICATION_JSON_TYPE);
            builder.cacheControl(ServerUtil.cacheControl(true, false));
        }
        catch (JSONException e) {
            builder = Response.status((int)400);
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST));
            this.log.error(e.getMessage(), (Throwable)e);
        }
        catch (InvalidClaimException e) {
            builder = Response.status((int)400);
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)BackchannelAuthenticationErrorResponseType.INVALID_REQUEST));
            this.log.error(e.getMessage(), (Throwable)e);
        }
        this.applicationAuditLogger.sendMessage(oAuth2AuditLog);
        return builder.build();
    }

    private JSONObject getJSONObject(String authReqId, int expiresIn, Integer interval) throws JSONException {
        JSONObject responseJsonObject = new JSONObject();
        responseJsonObject.put("auth_req_id", (Object)authReqId);
        responseJsonObject.put("expires_in", expiresIn);
        if (interval != null) {
            responseJsonObject.put("interval", (Object)interval);
        }
        return responseJsonObject;
    }
}

