/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.ciba;

import io.jans.as.model.configuration.AppConfiguration;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@Named
public class CIBAConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(CIBAConfigurationService.class);
    @Inject
    private AppConfiguration appConfiguration;

    public void processConfiguration(JSONObject jsonConfiguration) {
        try {
            jsonConfiguration.put("backchannel_authentication_endpoint", (Object)this.appConfiguration.getBackchannelAuthenticationEndpoint());
            JSONArray backchannelTokenDeliveryModesSupported = new JSONArray();
            for (String item : this.appConfiguration.getBackchannelTokenDeliveryModesSupported()) {
                backchannelTokenDeliveryModesSupported.put((Object)item);
            }
            if (backchannelTokenDeliveryModesSupported.length() > 0) {
                jsonConfiguration.put("backchannel_token_delivery_modes_supported", (Object)backchannelTokenDeliveryModesSupported);
            }
            JSONArray backchannelAuthenticationRequestSigningAlgValuesSupported = new JSONArray();
            for (String item : this.appConfiguration.getBackchannelAuthenticationRequestSigningAlgValuesSupported()) {
                backchannelAuthenticationRequestSigningAlgValuesSupported.put((Object)item);
            }
            if (backchannelAuthenticationRequestSigningAlgValuesSupported.length() > 0) {
                jsonConfiguration.put("backchannel_authentication_request_signing_alg_values_supported", (Object)backchannelAuthenticationRequestSigningAlgValuesSupported);
            }
            jsonConfiguration.put("backchannel_user_code_parameter_supported", (Object)this.appConfiguration.getBackchannelUserCodeParameterSupported());
        }
        catch (Exception e) {
            log.error("Failed to process CIBA configuration.", (Throwable)e);
        }
    }
}

