/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.clientinfo.ws.rs;

import io.jans.as.common.model.registration.Client;
import io.jans.as.common.service.AttributeService;
import io.jans.as.model.clientinfo.ClientInfoErrorResponseType;
import io.jans.as.model.common.FeatureFlagType;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.persistence.model.Scope;
import io.jans.as.server.clientinfo.ws.rs.ClientInfoRestWebService;
import io.jans.as.server.model.clientinfo.ClientInfoParamsValidator;
import io.jans.as.server.model.common.AbstractToken;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantList;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.ScopeService;
import io.jans.as.server.service.token.TokenService;
import io.jans.as.server.util.ServerUtil;
import io.jans.model.JansAttribute;
import io.jans.orm.model.base.LocalizedString;
import jakarta.inject.Inject;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.Set;
import org.json.JSONObject;
import org.slf4j.Logger;

@Path(value="/")
public class ClientInfoRestWebServiceImpl
implements ClientInfoRestWebService {
    @Inject
    private Logger log;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AuthorizationGrantList authorizationGrantList;
    @Inject
    private ScopeService scopeService;
    @Inject
    private ClientService clientService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private TokenService tokenService;

    @Override
    public Response requestClientInfoGet(String accessToken, String authorization, SecurityContext securityContext) {
        return this.requestClientInfo(accessToken, authorization, securityContext);
    }

    @Override
    public Response requestClientInfoPost(String accessToken, String authorization, SecurityContext securityContext) {
        return this.requestClientInfo(accessToken, authorization, securityContext);
    }

    public Response requestClientInfo(String accessToken, String authorization, SecurityContext securityContext) {
        if (this.tokenService.isBearerAuthToken(authorization)) {
            accessToken = this.tokenService.getBearerToken(authorization);
        }
        this.log.debug("Attempting to request Client Info, Access token = {}, Is Secure = {}", (Object)accessToken, (Object)securityContext.isSecure());
        this.errorResponseFactory.validateFeatureEnabled(FeatureFlagType.CLIENTINFO);
        Response.ResponseBuilder builder = Response.ok();
        if (!ClientInfoParamsValidator.validateParams(accessToken)) {
            builder = Response.status((int)400);
            builder.entity((Object)this.errorResponseFactory.errorAsJson((IErrorType)ClientInfoErrorResponseType.INVALID_REQUEST, "Failed to validate access token."));
        } else {
            AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(accessToken);
            if (authorizationGrant == null) {
                this.log.trace("Failed to find authorization grant for access token.");
                return Response.status((int)400).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)ClientInfoErrorResponseType.INVALID_TOKEN, "", "Unable to find grant object associated with access token.")).build();
            }
            AbstractToken token = authorizationGrant.getAccessToken(accessToken);
            if (token == null || !token.isValid()) {
                this.log.trace("Invalid access token.");
                return Response.status((int)400).entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)ClientInfoErrorResponseType.INVALID_TOKEN, "", "Invalid access token.")).build();
            }
            builder.cacheControl(ServerUtil.cacheControlWithNoStoreTransformAndPrivate());
            builder.header("Pragma", (Object)"no-cache");
            builder.entity((Object)this.getJSonResponse(authorizationGrant.getClient(), authorizationGrant.getScopes()));
        }
        return builder.build();
    }

    public String getJSonResponse(Client client, Set<String> scopes) {
        JSONObject jsonObj = new JSONObject();
        try {
            for (String scopeName : scopes) {
                Scope scope = this.scopeService.getScopeById(scopeName);
                if (scope.getClaims() == null) continue;
                for (String claimDn : scope.getClaims()) {
                    JansAttribute attribute = this.attributeService.getAttributeByDn(claimDn);
                    String ldapName = attribute.getName();
                    Object attributeValue = this.clientService.getAttribute(client, ldapName);
                    String claimName = attribute.getClaimName();
                    if (attributeValue instanceof LocalizedString) {
                        LocalizedString localizedString = (LocalizedString)attributeValue;
                        localizedString.addToJSON(jsonObj, claimName);
                        continue;
                    }
                    jsonObj.put(claimName, attributeValue);
                }
            }
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        return jsonObj.toString();
    }
}

