/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.exception;

import io.jans.as.server.model.exception.InvalidSessionStateException;
import jakarta.faces.FacesException;
import jakarta.faces.context.ExceptionHandler;
import jakarta.faces.context.ExceptionHandlerWrapper;
import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.ExceptionQueuedEvent;
import jakarta.faces.event.ExceptionQueuedEventContext;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Iterator;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalExceptionHandler
extends ExceptionHandlerWrapper {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    private final ExceptionHandler wrapped;

    GlobalExceptionHandler(ExceptionHandler exception) {
        this.wrapped = exception;
    }

    public ExceptionHandler getWrapped() {
        return this.wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() throws FacesException {
        Iterator i = this.getUnhandledExceptionQueuedEvents().iterator();
        while (i.hasNext()) {
            ExceptionQueuedEvent event = (ExceptionQueuedEvent)i.next();
            ExceptionQueuedEventContext context = (ExceptionQueuedEventContext)event.getSource();
            Throwable t = context.getException();
            FacesContext fc = FacesContext.getCurrentInstance();
            ExternalContext externalContext = fc.getExternalContext();
            try {
                this.logExceptionAsError(t);
                this.performRedirect(externalContext, this.isInvalidSessionStateException(t) ? "/error_session.htm" : "/error_service.htm");
                fc.renderResponse();
            }
            finally {
                i.remove();
            }
        }
        this.getWrapped().handle();
    }

    private void logExceptionAsError(Throwable t) {
        Response response;
        if (!log.isErrorEnabled()) {
            return;
        }
        if (t instanceof WebApplicationException && (response = ((WebApplicationException)t).getResponse()) != null && response.getStatus() == 302) {
            return;
        }
        log.error(t.getMessage(), t);
    }

    private boolean isInvalidSessionStateException(Throwable t) {
        return ExceptionUtils.getRootCause((Throwable)t) instanceof InvalidSessionStateException;
    }

    private void performRedirect(ExternalContext externalContext, String viewId) {
        try {
            externalContext.redirect(externalContext.getRequestContextPath() + viewId);
        }
        catch (Exception e) {
            log.error("Can't perform redirect to viewId: " + viewId, (Throwable)e);
        }
    }
}

