/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;

@WebFilter(filterName="CorrelationIdFilter", asyncSupported=true, urlPatterns={"/*"})
public class CorrelationIdFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String correlationId = httpRequest.getHeader("X-Correlation-Id");
        if (StringUtils.isBlank((CharSequence)correlationId)) {
            correlationId = UUID.randomUUID().toString();
            Cookie[] cookies = httpRequest.getCookies();
            if (cookies == null || Stream.of(cookies).noneMatch(cookie -> cookie.getName().contains("X-Correlation-Id"))) {
                Cookie cookie2 = new Cookie("X-Correlation-Id", correlationId);
                cookie2.setSecure(true);
                cookie2.setHttpOnly(true);
                httpResponse.addCookie(cookie2);
            }
        }
        ThreadContext.put((String)"X-Correlation-Id", (String)correlationId);
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

