/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.jwk.ws.rs;

import io.jans.as.model.config.WebKeysConfiguration;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.jwk.JSONWebKey;
import io.jans.as.server.jwk.ws.rs.JwkRestWebService;
import jakarta.inject.Inject;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;

@Path(value="/")
public class JwkRestWebServiceImpl
implements JwkRestWebService {
    @Inject
    private Logger log;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private WebKeysConfiguration webKeysConfiguration;

    @Override
    public Response requestJwk(SecurityContext sec) {
        this.log.debug("Attempting to request JWK, Is Secure = {}", (Object)sec.isSecure());
        Response.ResponseBuilder builder = Response.ok();
        try {
            WebKeysConfiguration webKeysConfiguration = new WebKeysConfiguration();
            webKeysConfiguration.setKeys(this.filterKeys(this.webKeysConfiguration.getKeys()));
            builder.entity((Object)webKeysConfiguration.toString());
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            builder = Response.status((int)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        return builder.build();
    }

    private List<JSONWebKey> filterKeys(List<JSONWebKey> allKeys) {
        List jwksAlgorithmsSupported = this.appConfiguration.getJwksAlgorithmsSupported();
        if (allKeys == null || allKeys.size() == 0 || jwksAlgorithmsSupported == null || jwksAlgorithmsSupported.size() == 0) {
            return allKeys;
        }
        return allKeys.stream().filter(key -> key.getAlg() == null || jwksAlgorithmsSupported.contains(key.getAlg().getParamName())).collect(Collectors.toList());
    }
}

