/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.authorize;

import io.jans.as.model.util.Util;
import io.jans.as.server.model.authorize.Claim;
import io.jans.as.server.model.authorize.ClaimValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserInfoMember {
    private final List<Claim> claims = new ArrayList<Claim>();
    private final List<String> preferredLocales;

    public UserInfoMember(JSONObject jsonObject) throws JSONException {
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String claimName = (String)iterator.next();
            ClaimValue claimValue = null;
            if (jsonObject.isNull(claimName)) {
                claimValue = ClaimValue.createNull();
            } else {
                JSONObject claimValueJsonObject = jsonObject.getJSONObject(claimName);
                if (claimValueJsonObject.has("essential")) {
                    boolean essential = claimValueJsonObject.getBoolean("essential");
                    claimValue = ClaimValue.createEssential(essential);
                } else if (claimValueJsonObject.has("values")) {
                    JSONArray claimValueJsonArray = claimValueJsonObject.getJSONArray("values");
                    List claimValueArr = Util.asList((JSONArray)claimValueJsonArray);
                    claimValue = ClaimValue.createValueList(claimValueArr);
                }
            }
            Claim claim = new Claim(claimName, claimValue);
            this.claims.add(claim);
        }
        this.preferredLocales = new ArrayList<String>();
        if (jsonObject.has("preferred_locales")) {
            JSONArray preferredLocalesJsonArray = jsonObject.getJSONArray("preferred_locales");
            for (int i = 0; i < preferredLocalesJsonArray.length(); ++i) {
                this.preferredLocales.add(preferredLocalesJsonArray.getString(i));
            }
        }
    }

    public List<Claim> getClaims() {
        return this.claims;
    }

    public List<String> getPreferredLocales() {
        return this.preferredLocales;
    }
}

