/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.common;

import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.model.common.GrantType;
import io.jans.as.server.model.common.AuthorizationCode;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantType;
import java.util.Date;

public class AuthorizationCodeGrant
extends AuthorizationGrant {
    public AuthorizationCodeGrant() {
    }

    public AuthorizationCodeGrant(User user, Client client, Date authenticationTime) {
        this.init(user, client, authenticationTime);
    }

    public void init(User user, Client client, Date authenticationTime) {
        super.init(user, AuthorizationGrantType.AUTHORIZATION_CODE, client, authenticationTime);
        this.setAuthorizationCode(new AuthorizationCode(this.appConfiguration.getAuthorizationCodeLifetime()));
        this.setIsCachedWithNoPersistence(true);
    }

    @Override
    public GrantType getGrantType() {
        return GrantType.AUTHORIZATION_CODE;
    }

    @Override
    public void revokeAllTokens() {
        super.revokeAllTokens();
        if (this.getAuthorizationCode() != null) {
            this.getAuthorizationCode().setRevoked(true);
        }
    }

    @Override
    public void checkExpiredTokens() {
        super.checkExpiredTokens();
        if (this.getAuthorizationCode() != null) {
            this.getAuthorizationCode().checkExpired();
        }
    }
}

