/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.common;

import io.jans.as.common.model.common.User;
import io.jans.as.model.authzdetails.AuthzDetails;
import io.jans.as.model.common.GrantType;
import io.jans.as.server.model.common.AuthorizationGrant;
import io.jans.as.server.model.common.AuthorizationGrantType;
import io.jans.as.server.model.common.CacheGrant;
import io.jans.as.server.model.common.DeviceAuthorizationCacheControl;
import io.jans.service.CacheService;
import jakarta.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public class DeviceCodeGrant
extends AuthorizationGrant {
    private String deviceCode;
    @Inject
    private CacheService cacheService;

    public void init(DeviceAuthorizationCacheControl cacheData, User user) {
        super.init(user, AuthorizationGrantType.DEVICE_CODE, cacheData.getClient(), null);
        this.setDeviceCode(cacheData.getDeviceCode());
        this.setIsCachedWithNoPersistence(true);
        this.setScopes(cacheData.getScopes());
        this.setAuthzDetails(AuthzDetails.ofSilently((String)cacheData.getAuthzDetails()));
    }

    @Override
    public GrantType getGrantType() {
        return GrantType.DEVICE_CODE;
    }

    @Override
    public void save() {
        CacheGrant cachedGrant = new CacheGrant(this, this.appConfiguration);
        String cacheKey = StringUtils.isNotBlank((CharSequence)cachedGrant.getDeviceCode()) ? cachedGrant.getDeviceCode() : cachedGrant.getGrantId();
        this.cacheService.put(cachedGrant.getExpiresIn(), cacheKey, (Object)cachedGrant);
    }

    public String getDeviceCode() {
        return this.deviceCode;
    }

    public void setDeviceCode(String deviceCode) {
        this.deviceCode = deviceCode;
    }
}

