/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.model.token;

import com.google.common.collect.Lists;
import io.jans.as.common.claims.Audience;
import io.jans.as.common.model.common.User;
import io.jans.as.common.model.registration.Client;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.common.service.AttributeService;
import io.jans.as.model.authorize.CodeVerifier;
import io.jans.as.model.common.ScopeType;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.exception.InvalidClaimException;
import io.jans.as.model.jwt.JwtClaims;
import io.jans.as.model.jwt.JwtSubClaimObject;
import io.jans.as.model.token.JsonWebResponse;
import io.jans.as.persistence.model.Scope;
import io.jans.as.server.authorize.ws.rs.AuthzRequest;
import io.jans.as.server.model.authorize.Claim;
import io.jans.as.server.model.authorize.JwtAuthorizationRequest;
import io.jans.as.server.model.common.AbstractToken;
import io.jans.as.server.model.common.AccessToken;
import io.jans.as.server.model.common.AuthorizationCode;
import io.jans.as.server.model.common.CIBAGrant;
import io.jans.as.server.model.common.ExecutionContext;
import io.jans.as.server.model.common.IAuthorizationGrant;
import io.jans.as.server.model.common.RefreshToken;
import io.jans.as.server.model.common.UnmodifiableAuthorizationGrant;
import io.jans.as.server.model.token.JwrService;
import io.jans.as.server.service.AcrService;
import io.jans.as.server.service.ScopeService;
import io.jans.as.server.service.SessionIdService;
import io.jans.as.server.service.date.DateFormatterService;
import io.jans.as.server.service.external.ExternalAuthenticationService;
import io.jans.as.server.service.external.ExternalAuthorizationChallengeService;
import io.jans.as.server.service.external.ExternalDynamicScopeService;
import io.jans.as.server.service.external.ExternalUpdateTokenService;
import io.jans.as.server.service.external.context.DynamicScopeExternalContext;
import io.jans.as.server.service.external.context.ExternalUpdateTokenContext;
import io.jans.as.server.service.token.StatusListService;
import io.jans.model.JansAttribute;
import io.jans.model.custom.script.conf.CustomScriptConfiguration;
import io.jans.model.custom.script.type.auth.PersonAuthenticationType;
import jakarta.ejb.Stateless;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.json.JSONObject;
import org.slf4j.Logger;

@ApplicationScoped
@Stateless
@Named
public class IdTokenFactory {
    @Inject
    private Logger log;
    @Inject
    private ExternalDynamicScopeService externalDynamicScopeService;
    @Inject
    private ExternalAuthenticationService externalAuthenticationService;
    @Inject
    private ExternalUpdateTokenService externalUpdateTokenService;
    @Inject
    private ScopeService scopeService;
    @Inject
    private AttributeService attributeService;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private JwrService jwrService;
    @Inject
    private SessionIdService sessionIdService;
    @Inject
    private DateFormatterService dateFormatterService;
    @Inject
    private StatusListService statusListService;
    @Inject
    private ExternalAuthorizationChallengeService externalAuthorizationChallengeService;

    private void setAmrClaim(JsonWebResponse jwt, String acrValues, Client client) {
        ArrayList amrList = Lists.newArrayList();
        CustomScriptConfiguration script = this.externalAuthenticationService.getCustomScriptConfigurationByName(acrValues);
        if (script != null) {
            amrList.add(Integer.toString(script.getLevel()));
            PersonAuthenticationType externalAuthenticator = (PersonAuthenticationType)script.getExternalType();
            int apiVersion = externalAuthenticator.getApiVersion();
            if (apiVersion > 3) {
                Map authenticationMethodClaimsOrNull = externalAuthenticator.getAuthenticationMethodClaims(script.getConfigurationAttributes());
                this.addToAmrList(amrList, authenticationMethodClaimsOrNull);
            }
        } else {
            AuthzRequest authzRequest = new AuthzRequest();
            authzRequest.setAcrValues(acrValues);
            authzRequest.setClientId(client.getClientId());
            ExecutionContext executionContext = new ExecutionContext();
            executionContext.setAuthzRequest(authzRequest);
            executionContext.setClient(client);
            Map<String, String> amrMap = this.externalAuthorizationChallengeService.getAuthenticationMethodClaims(executionContext);
            this.addToAmrList(amrList, amrMap);
        }
        jwt.getClaims().setClaim("amr", (List)amrList);
    }

    private void addToAmrList(List<String> amrList, Map<String, String> claims) {
        if (claims != null) {
            for (Map.Entry<String, String> entry : claims.entrySet()) {
                amrList.add(entry.getKey() + ":" + entry.getValue());
            }
        }
    }

    private void fillClaims(JsonWebResponse jwr, IAuthorizationGrant authorizationGrant, AuthorizationCode authorizationCode, AccessToken accessToken, RefreshToken refreshToken, ExecutionContext executionContext) throws Exception {
        String state;
        String nonce;
        SessionId session;
        int lifetimeFromScript;
        Client client = authorizationGrant.getClient();
        jwr.getClaims().setIssuer(this.appConfiguration.getIssuer());
        Audience.setAudience((JwtClaims)jwr.getClaims(), (Client)client);
        int lifeTime = this.appConfiguration.getIdTokenLifetime();
        if (client.getAttributes().getIdTokenLifetime() != null && client.getAttributes().getIdTokenLifetime() > 0) {
            lifeTime = client.getAttributes().getIdTokenLifetime();
            this.log.trace("Override id token lifetime with value from client: {}", (Object)client.getClientId());
        }
        if ((lifetimeFromScript = this.externalUpdateTokenService.getIdTokenLifetimeInSeconds(ExternalUpdateTokenContext.of(executionContext))) > 0) {
            lifeTime = lifetimeFromScript;
            this.log.trace("Override id token lifetime with value from script: {}", (Object)lifetimeFromScript);
        }
        Calendar calendar = Calendar.getInstance();
        Date issuedAt = calendar.getTime();
        calendar.add(13, lifeTime);
        Date expiration = calendar.getTime();
        jwr.getClaims().setExpirationTime(expiration);
        jwr.getClaims().setIat(issuedAt);
        jwr.getClaims().setNbf(issuedAt);
        jwr.setClaim("jti", executionContext.getTokenReferenceId());
        if (executionContext.getPreProcessing() != null) {
            executionContext.getPreProcessing().apply(jwr);
        }
        if ((session = this.sessionIdService.getSessionByDn(authorizationGrant.getSessionDn(), true)) != null) {
            jwr.setClaim("sid", session.getOutsideSid());
        }
        this.statusListService.addStatusClaimWithIndex(jwr, executionContext);
        this.addTokenExchangeClaims(jwr, executionContext, session);
        String acrValues = authorizationGrant.getAcrValues();
        acrValues = AcrService.removeParametersFromAgamaAcr(acrValues);
        if (acrValues != null) {
            jwr.setClaim("acr", acrValues);
            this.setAmrClaim(jwr, acrValues, client);
        }
        if (StringUtils.isNotBlank((CharSequence)(nonce = executionContext.getNonce()))) {
            jwr.setClaim("nonce", nonce);
        }
        if (authorizationGrant.getAuthenticationTime() != null) {
            jwr.getClaims().setClaim("auth_time", authorizationGrant.getAuthenticationTime());
        }
        if (authorizationCode != null) {
            String codeHash = AbstractToken.getHash(authorizationCode.getCode(), jwr.getHeader().getSignatureAlgorithm());
            jwr.setClaim("c_hash", codeHash);
        }
        if (accessToken != null) {
            String accessTokenHash = AbstractToken.getHash(accessToken.getCode(), jwr.getHeader().getSignatureAlgorithm());
            jwr.setClaim("at_hash", accessTokenHash);
        }
        if (Strings.isNotBlank((String)(state = executionContext.getState()))) {
            String stateHash = AbstractToken.getHash(state, jwr.getHeader().getSignatureAlgorithm());
            jwr.setClaim("s_hash", stateHash);
        }
        if (authorizationGrant.getGrantType() != null) {
            jwr.setClaim("grant", authorizationGrant.getGrantType().getValue());
        }
        jwr.setClaim("jansOpenIDConnectVersion", this.appConfiguration.getJansOpenIdConnectVersion());
        User user = authorizationGrant.getUser();
        ArrayList<Scope> dynamicScopes = new ArrayList<Scope>();
        if (executionContext.isIncludeIdTokenClaims() && client.isIncludeClaimsInIdToken()) {
            for (String scopeName : executionContext.getScopes()) {
                Scope scope = this.scopeService.getScopeById(scopeName);
                if (scope == null) continue;
                if (ScopeType.DYNAMIC == scope.getScopeType()) {
                    dynamicScopes.add(scope);
                    continue;
                }
                Map<String, Object> claims = this.scopeService.getClaims(user, scope);
                if (Boolean.TRUE.equals(scope.isGroupClaims())) {
                    JwtSubClaimObject groupClaim = new JwtSubClaimObject();
                    groupClaim.setName(scope.getId());
                    for (Map.Entry<String, Object> entry : claims.entrySet()) {
                        String key = entry.getKey();
                        Object value = entry.getValue();
                        if (value instanceof List) {
                            groupClaim.setClaim(key, (List)value);
                            continue;
                        }
                        groupClaim.setClaim(key, (String)value);
                    }
                    jwr.getClaims().setClaim(scope.getId(), groupClaim);
                } else {
                    for (Map.Entry<String, Object> entry : claims.entrySet()) {
                        String key = entry.getKey();
                        Object value = entry.getValue();
                        if (value instanceof List) {
                            jwr.getClaims().setClaim(key, (List)value);
                            continue;
                        }
                        if (value instanceof Boolean) {
                            jwr.getClaims().setClaim(key, (Boolean)value);
                            continue;
                        }
                        if (value instanceof Date) {
                            Serializable formattedValue = this.dateFormatterService.formatClaim((Date)value, key);
                            jwr.getClaims().setClaimObject(key, (Object)formattedValue, true);
                            continue;
                        }
                        jwr.setClaim(key, (String)value);
                    }
                }
                jwr.getClaims().setSubjectIdentifier(authorizationGrant.getUser().getAttribute("inum"));
            }
        }
        this.setClaimsFromJwtAuthorizationRequest(jwr, authorizationGrant, executionContext.getScopes());
        this.setClaimsFromRequestedClaims(executionContext.getClaimsAsString(), jwr, user);
        this.filterClaimsBasedOnAccessToken(jwr, accessToken, authorizationCode);
        this.jwrService.setSubjectIdentifier(jwr, authorizationGrant);
        if (dynamicScopes.size() > 0 && this.externalDynamicScopeService.isEnabled()) {
            UnmodifiableAuthorizationGrant unmodifiableAuthorizationGrant = new UnmodifiableAuthorizationGrant(authorizationGrant);
            DynamicScopeExternalContext dynamicScopeContext = new DynamicScopeExternalContext(dynamicScopes, jwr, unmodifiableAuthorizationGrant);
            this.externalDynamicScopeService.executeExternalUpdateMethods(dynamicScopeContext);
        }
        this.processCiba(jwr, authorizationGrant, refreshToken);
        if (executionContext.getPostProcessor() != null) {
            executionContext.getPostProcessor().apply(jwr);
        }
    }

    private void addTokenExchangeClaims(JsonWebResponse jwr, ExecutionContext executionContext, SessionId sessionId) {
        if (sessionId == null) {
            return;
        }
        String deviceSecret = executionContext.getDeviceSecret();
        if (StringUtils.isBlank((CharSequence)deviceSecret)) {
            deviceSecret = executionContext.getHttpRequest().getParameter("device_secret");
        }
        if (StringUtils.isNotBlank((CharSequence)deviceSecret) && sessionId.getDeviceSecrets().contains(deviceSecret)) {
            jwr.setClaim("ds_hash", CodeVerifier.s256((String)deviceSecret));
        }
    }

    private void filterClaimsBasedOnAccessToken(JsonWebResponse jwr, AccessToken accessToken, AuthorizationCode authorizationCode) {
        if ((accessToken != null || authorizationCode != null) && this.appConfiguration.getIdTokenFilterClaimsBasedOnAccessToken().booleanValue()) {
            JwtClaims claims = jwr.getClaims();
            claims.removeClaim("profile");
            claims.removeClaim("email");
            claims.removeClaim("address");
            claims.removeClaim("phone_number");
        }
    }

    private void setClaimsFromRequestedClaims(String requestedClaims, JsonWebResponse jwr, User user) throws InvalidClaimException {
        JSONObject claimsObj;
        if (requestedClaims != null && (claimsObj = new JSONObject(requestedClaims)).has("id_token")) {
            JSONObject idTokenObj = claimsObj.getJSONObject("id_token");
            Iterator it = idTokenObj.keys();
            while (it.hasNext()) {
                String claimName = (String)it.next();
                JansAttribute jansAttribute = this.attributeService.getByClaimName(claimName);
                if (jansAttribute == null) continue;
                String ldapClaimName = jansAttribute.getName();
                Object attribute = user.getAttribute(ldapClaimName, false, jansAttribute.getOxMultiValuedAttribute().booleanValue());
                if (attribute instanceof List) {
                    jwr.getClaims().setClaim(claimName, (List)attribute);
                    continue;
                }
                if (attribute instanceof Boolean) {
                    jwr.getClaims().setClaim(claimName, (Boolean)attribute);
                    continue;
                }
                if (attribute instanceof Date) {
                    jwr.getClaims().setClaim(claimName, Long.valueOf(((Date)attribute).getTime() / 1000L));
                    continue;
                }
                jwr.setClaim(claimName, (String)attribute);
            }
        }
    }

    private void processCiba(JsonWebResponse jwr, IAuthorizationGrant authorizationGrant, RefreshToken refreshToken) {
        if (!(authorizationGrant instanceof CIBAGrant)) {
            return;
        }
        String refreshTokenHash = AbstractToken.getHash(refreshToken.getCode(), null);
        jwr.setClaim("urn:openid:params:jwt:claim:rt_hash", refreshTokenHash);
        CIBAGrant cibaGrant = (CIBAGrant)authorizationGrant;
        jwr.setClaim("urn:openid:params:jwt:claim:auth_req_id", cibaGrant.getAuthReqId());
    }

    private void setClaimsFromJwtAuthorizationRequest(JsonWebResponse jwr, IAuthorizationGrant authorizationGrant, Set<String> scopes) throws InvalidClaimException {
        JwtAuthorizationRequest requestObject = authorizationGrant.getJwtAuthorizationRequest();
        if (requestObject == null || requestObject.getIdTokenMember() == null) {
            return;
        }
        for (Claim claim : requestObject.getIdTokenMember().getClaims()) {
            Client client;
            boolean optional = true;
            JansAttribute jansAttribute = this.attributeService.getByClaimName(claim.getName());
            if (jansAttribute == null || !this.validateRequesteClaim(jansAttribute, (client = authorizationGrant.getClient()).getClaims(), scopes)) continue;
            String ldapClaimName = jansAttribute.getName();
            Object attribute = authorizationGrant.getUser().getAttribute(ldapClaimName, optional, jansAttribute.getOxMultiValuedAttribute().booleanValue());
            jwr.getClaims().setClaimFromJsonObject(claim.getName(), attribute);
        }
    }

    public JsonWebResponse createJwr(IAuthorizationGrant grant, AuthorizationCode authorizationCode, AccessToken accessToken, RefreshToken refreshToken, ExecutionContext executionContext) throws Exception {
        Client client = grant.getClient();
        JsonWebResponse jwr = this.jwrService.createJwr(client);
        this.fillClaims(jwr, grant, authorizationCode, accessToken, refreshToken, executionContext);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Created claims for id_token, claims: {}", (Object)jwr.getClaims().toJsonString());
        }
        return this.jwrService.encode(jwr, client);
    }

    private boolean validateRequesteClaim(JansAttribute jansAttribute, String[] clientAllowedClaims, Collection<String> scopes) {
        if (jansAttribute == null) {
            return false;
        }
        if (clientAllowedClaims != null) {
            for (String clientAllowedClaim : clientAllowedClaims) {
                if (!jansAttribute.getDn().equals(clientAllowedClaim)) continue;
                return true;
            }
        }
        for (String scopeName : scopes) {
            Scope scope = this.scopeService.getScopeById(scopeName);
            if (scope == null || scope.getClaims() == null) continue;
            for (String claimDn : scope.getClaims()) {
                if (!jansAttribute.getDisplayName().equals(this.attributeService.getAttributeByDn(claimDn).getDisplayName())) continue;
                return true;
            }
        }
        return false;
    }
}

