/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.jans.as.common.service.common.ConfigurationService;
import io.jans.config.CustomProperty;
import io.jans.config.GluuConfiguration;
import io.jans.config.IDPAuthConf;
import io.jans.model.AuthenticationScriptUsageType;
import io.jans.model.SimpleCustomProperty;
import io.jans.model.config.CustomAuthenticationConfiguration;
import io.jans.util.StringHelper;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

@Stateless
@Named
public class LdapCustomAuthenticationConfigurationService
implements Serializable {
    private static final long serialVersionUID = -2225890597520443390L;
    private static final String CUSTOM_AUTHENTICATION_SCRIPT_PROPERTY_NAME = "script.__$__customAuthenticationScript__$__";
    private static final String CUSTOM_AUTHENTICATION_PROPERTY_PREFIX = "property.";
    private static final String CUSTOM_AUTHENTICATION_SCRIPT_USAGE_TYPE = "usage.";
    @Inject
    private Logger log;
    @Inject
    private ConfigurationService configurationService;

    public List<CustomAuthenticationConfiguration> getCustomAuthenticationConfigurations() {
        GluuConfiguration gluuConfiguration = this.configurationService.getConfiguration();
        List authConfigurations = gluuConfiguration.getIdpAuthn();
        ArrayList<CustomAuthenticationConfiguration> customAuthenticationConfigurations = new ArrayList<CustomAuthenticationConfiguration>();
        if (authConfigurations == null) {
            return customAuthenticationConfigurations;
        }
        for (IDPAuthConf authConfiguration : authConfigurations) {
            if (!authConfiguration.getEnabled() || !authConfiguration.getType().equalsIgnoreCase("customAuthentication")) continue;
            CustomAuthenticationConfiguration customAuthenticationConfiguration = this.mapCustomAuthentication(authConfiguration);
            customAuthenticationConfigurations.add(customAuthenticationConfiguration);
        }
        return customAuthenticationConfigurations;
    }

    private CustomAuthenticationConfiguration mapCustomAuthentication(IDPAuthConf oneConf) {
        CustomAuthenticationConfiguration customAuthenticationConfig = new CustomAuthenticationConfiguration();
        customAuthenticationConfig.setName(oneConf.getName());
        customAuthenticationConfig.setLevel(oneConf.getLevel());
        customAuthenticationConfig.setPriority(oneConf.getPriority());
        customAuthenticationConfig.setEnabled(oneConf.getEnabled());
        customAuthenticationConfig.setVersion(oneConf.getVersion());
        for (CustomProperty customProperty : oneConf.getFields()) {
            String attrName;
            if (customProperty.getValues() == null || customProperty.getValues().size() == 0 || StringHelper.isEmpty((String)(attrName = StringHelper.toLowerCase((String)customProperty.getName())))) continue;
            String value = (String)customProperty.getValues().get(0);
            if (attrName.startsWith(CUSTOM_AUTHENTICATION_PROPERTY_PREFIX)) {
                String key = customProperty.getName().substring(CUSTOM_AUTHENTICATION_PROPERTY_PREFIX.length());
                SimpleCustomProperty property = new SimpleCustomProperty(key, value);
                customAuthenticationConfig.getCustomAuthenticationAttributes().add(property);
                continue;
            }
            if (StringHelper.equalsIgnoreCase((String)attrName, (String)CUSTOM_AUTHENTICATION_SCRIPT_PROPERTY_NAME)) {
                customAuthenticationConfig.setCustomAuthenticationScript(value);
                continue;
            }
            if (!StringHelper.equalsIgnoreCase((String)attrName, (String)CUSTOM_AUTHENTICATION_SCRIPT_USAGE_TYPE) || !StringHelper.isNotEmpty((String)value)) continue;
            AuthenticationScriptUsageType authenticationScriptUsageType = AuthenticationScriptUsageType.getByValue((String)value);
            customAuthenticationConfig.setUsageType(authenticationScriptUsageType);
        }
        return customAuthenticationConfig;
    }

    private Object jsonToObject(String json, Class<?> clazz) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readValue(json, clazz);
    }
}

