/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.server.service.cdi.event.AuthConfigurationEvent;
import io.jans.service.cdi.async.Asynchronous;
import io.jans.service.cdi.event.Scheduled;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

@ApplicationScoped
@Named
public class LocalResponseCache {
    public static final int DEFAULT_DISCOVERY_LIFETIME = 60;
    public static final int DEFAULT_ACCESS_EVALUTION_DISCOVERY_LIFETIME = 5;
    public static final int DEFAULT_SECTOR_IDENTIFIER_LIFETIME = 1440;
    private static final String DISCOVERY_CACHE_KEY = "DISCOVERY_CACHE_KEY";
    private static final String ACCESS_EVALUATION_DISCOVERY_CACHE_KEY = "ACCESS_EVALUATION_DISCOVERY_CACHE_KEY";
    @Inject
    private AppConfiguration appConfiguration;
    private final AtomicBoolean rebuilding = new AtomicBoolean(false);
    private Cache<String, JSONObject> discoveryCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.MINUTES).build();
    private Cache<String, List<String>> sectorIdentifierCache = CacheBuilder.newBuilder().expireAfterWrite(1440L, TimeUnit.MINUTES).build();
    private Cache<String, JSONObject> accessEvaluationDiscoveryCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private int currentDiscoveryLifetime = 60;
    private int currentAccessEvaluationDiscoveryLifetime = 5;
    private int currentSectorIdentifierLifetime = 1440;

    public void invalidateDiscoveryCache() {
        this.discoveryCache.invalidate((Object)DISCOVERY_CACHE_KEY);
    }

    public void invalidateAccessEvaluationDiscoveryCache() {
        this.accessEvaluationDiscoveryCache.invalidate((Object)ACCESS_EVALUATION_DISCOVERY_CACHE_KEY);
    }

    @Asynchronous
    public void reloadConfigurationTimerEvent(@Observes @Scheduled AuthConfigurationEvent authConfigurationEvent) {
        try {
            if (this.rebuilding.get()) {
                return;
            }
            this.rebuilding.set(true);
            if (this.currentDiscoveryLifetime != this.appConfiguration.getDiscoveryCacheLifetimeInMinutes()) {
                this.currentDiscoveryLifetime = this.appConfiguration.getDiscoveryCacheLifetimeInMinutes();
                this.discoveryCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.appConfiguration.getDiscoveryCacheLifetimeInMinutes(), TimeUnit.MINUTES).build();
            }
            if (this.currentAccessEvaluationDiscoveryLifetime != this.appConfiguration.getAccessEvaluationDiscoveryCacheLifetimeInMinutes()) {
                this.currentAccessEvaluationDiscoveryLifetime = this.appConfiguration.getAccessEvaluationDiscoveryCacheLifetimeInMinutes();
                this.accessEvaluationDiscoveryCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.appConfiguration.getAccessEvaluationDiscoveryCacheLifetimeInMinutes(), TimeUnit.MINUTES).build();
            }
            if (this.currentSectorIdentifierLifetime != this.appConfiguration.getSectorIdentifierCacheLifetimeInMinutes()) {
                this.currentSectorIdentifierLifetime = this.appConfiguration.getSectorIdentifierCacheLifetimeInMinutes();
                this.sectorIdentifierCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.appConfiguration.getSectorIdentifierCacheLifetimeInMinutes(), TimeUnit.MINUTES).build();
            }
        }
        finally {
            this.rebuilding.set(false);
        }
    }

    public List<String> getSectorRedirectUris(String sectorIdentifierUri) {
        if (this.sectorIdentifierCache == null || this.rebuilding.get()) {
            return null;
        }
        return (List)this.sectorIdentifierCache.getIfPresent((Object)sectorIdentifierUri);
    }

    public void putSectorRedirectUris(String sectorIdentifierUri, List<String> redirectUris) {
        if (this.sectorIdentifierCache == null || this.rebuilding.get()) {
            return;
        }
        this.sectorIdentifierCache.put((Object)sectorIdentifierUri, redirectUris);
    }

    public JSONObject getDiscoveryResponse() {
        if (this.discoveryCache == null || this.rebuilding.get()) {
            return null;
        }
        return (JSONObject)this.discoveryCache.getIfPresent((Object)DISCOVERY_CACHE_KEY);
    }

    public void putDiscoveryResponse(JSONObject response) {
        if (this.discoveryCache == null || this.rebuilding.get()) {
            return;
        }
        this.discoveryCache.put((Object)DISCOVERY_CACHE_KEY, (Object)response);
    }

    public JSONObject getAccessEvaluationDiscoveryResponse() {
        if (this.accessEvaluationDiscoveryCache == null || this.rebuilding.get()) {
            return null;
        }
        return (JSONObject)this.accessEvaluationDiscoveryCache.getIfPresent((Object)ACCESS_EVALUATION_DISCOVERY_CACHE_KEY);
    }

    public void putAccessEvaluationDiscoveryResponse(JSONObject response) {
        if (this.accessEvaluationDiscoveryCache == null || this.rebuilding.get()) {
            return;
        }
        this.accessEvaluationDiscoveryCache.put((Object)ACCESS_EVALUATION_DISCOVERY_CACHE_KEY, (Object)response);
    }
}

