/*
 * Decompiled with CFR 0.152.
 */
package io.jans.as.server.service;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.jans.as.common.model.session.SessionId;
import io.jans.as.model.configuration.AppConfiguration;
import io.jans.as.model.error.ErrorResponseFactory;
import io.jans.as.model.error.IErrorType;
import io.jans.as.model.session.EndSessionErrorResponseType;
import io.jans.as.model.util.QueryStringDecoder;
import io.jans.as.model.util.Util;
import io.jans.as.server.service.ClientService;
import io.jans.as.server.service.LocalResponseCache;
import io.jans.as.server.session.ws.rs.EndSessionService;
import jakarta.ejb.Stateless;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
@Named
public class RedirectionUriService {
    private static final Logger log = LoggerFactory.getLogger(RedirectionUriService.class);
    @Inject
    private ClientService clientService;
    @Inject
    private ErrorResponseFactory errorResponseFactory;
    @Inject
    private AppConfiguration appConfiguration;
    @Inject
    private LocalResponseCache localResponseCache;
    @Inject
    private EndSessionService endSessionService;

    public String validateRedirectionUri(String clientIdentifier, String redirectionUri) {
        io.jans.as.common.model.registration.Client client = this.clientService.getClient(clientIdentifier);
        if (client == null) {
            return null;
        }
        return this.validateRedirectionUri(client, redirectionUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSectorRedirectUris(String sectorIdentiferUri) {
        ArrayList result = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)sectorIdentiferUri)) {
            return result;
        }
        List<String> sectorRedirectUris = this.localResponseCache.getSectorRedirectUris(sectorIdentiferUri);
        if (sectorRedirectUris != null) {
            return sectorRedirectUris;
        }
        String entity = null;
        try (Client clientRequest = ClientBuilder.newClient();){
            Response clientResponse = clientRequest.target(sectorIdentiferUri).request().buildGet().invoke();
            int status = clientResponse.getStatus();
            if (status != 200) {
                ArrayList arrayList = result;
                return arrayList;
            }
            entity = (String)clientResponse.readEntity(String.class);
        }
        JSONArray sectorIdentifierJsonArray = new JSONArray(entity);
        for (int i = 0; i < sectorIdentifierJsonArray.length(); ++i) {
            result.add(sectorIdentifierJsonArray.getString(i));
        }
        this.localResponseCache.putSectorRedirectUris(sectorIdentiferUri, result);
        return result;
    }

    public String validateRedirectionUri(@NotNull io.jans.as.common.model.registration.Client client, String redirectionUri) {
        try {
            String sectorIdentifierUri = client.getSectorIdentifierUri();
            String[] redirectUris = client.getRedirectUris();
            if (StringUtils.isNotBlank((CharSequence)sectorIdentifierUri)) {
                redirectUris = this.getSectorRedirectUris(sectorIdentifierUri).toArray(new String[0]);
            }
            if (StringUtils.isBlank((CharSequence)redirectionUri) && redirectUris != null && redirectUris.length == 1) {
                log.trace("First redirect_uri is returned.");
                return redirectUris[0];
            }
            if (StringUtils.isNotBlank((CharSequence)redirectionUri)) {
                if (redirectUris != null) {
                    log.trace("Validating redirection URI: clientIdentifier = {}, redirectionUri = {}, found = {}", new Object[]{client.getClientId(), redirectionUri, redirectUris.length});
                    if (RedirectionUriService.isUriEqual(redirectionUri, redirectUris)) {
                        log.trace("Redirect URI 'equals' found, clientId = {}, redirectionUri = {}", (Object)client.getClientId(), (Object)redirectionUri);
                        return redirectionUri;
                    }
                    log.trace("RedirectionUri didn't match with any of the client redirect uris, clientId = {}, redirectionUri = {}", (Object)client.getClientId(), (Object)redirectionUri);
                }
                if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getRedirectUrisRegexEnabled())) {
                    if (RedirectionUriService.isAllowedByRegExp(redirectionUri, client)) {
                        log.trace("RedirectionUri is allowed by regexp, clientId = {}, redirectionUri = {}, regexp = {}", new Object[]{client.getClientId(), redirectionUri, client.getAttributes().getRedirectUrisRegex()});
                        return redirectionUri;
                    }
                    log.trace("RedirectionUri didn't match with client regular expression, clientId = {}, redirectionUri = {}", (Object)client.getClientId(), (Object)redirectionUri);
                }
            } else {
                log.warn("RedirectionUri is blank, clientId = {}", (Object)client.getClientId());
            }
        }
        catch (Exception e) {
            log.error(String.format("Problems validating redirection uri, clientId = %s, redirectionUri = %s", client.getClientId(), redirectionUri), (Throwable)e);
            return null;
        }
        return null;
    }

    public static boolean isAllowedByRegExp(String redirectUri, io.jans.as.common.model.registration.Client client) {
        if (client == null) {
            return false;
        }
        String redirectUrisRegex = client.getAttributes().getRedirectUrisRegex();
        return StringUtils.isNotBlank((CharSequence)redirectUrisRegex) && redirectUri.matches(redirectUrisRegex);
    }

    public static boolean isUriEqual(String redirectionUri, String[] redirectUris) {
        String redirectUriWithoutParams = RedirectionUriService.uriWithoutParams(redirectionUri);
        for (String uri : redirectUris) {
            log.debug("Comparing {} == {}", (Object)uri, (Object)redirectionUri);
            if (uri.equals(redirectionUri)) {
                return true;
            }
            String uriWithoutParams = RedirectionUriService.uriWithoutParams(uri);
            Map<String, String> params = RedirectionUriService.getParams(uri);
            if ((!uriWithoutParams.equals(redirectUriWithoutParams) || params.size() != 0 || RedirectionUriService.getParams(redirectionUri).size() != 0) && (!uriWithoutParams.equals(redirectUriWithoutParams) || params.size() <= 0 || !RedirectionUriService.compareParams(redirectionUri, uri))) continue;
            return true;
        }
        return false;
    }

    public String validatePostLogoutRedirectUri(String clientId, String postLogoutRedirectUri) {
        boolean isBlank = Util.isNullOrEmpty((String)postLogoutRedirectUri);
        io.jans.as.common.model.registration.Client client = this.clientService.getClient(clientId);
        if (client != null) {
            String[] postLogoutRedirectUris = client.getPostLogoutRedirectUris();
            log.debug("Validating post logout redirect URI: clientId = {}, postLogoutRedirectUri = {}", (Object)clientId, (Object)postLogoutRedirectUri);
            return this.validatePostLogoutRedirectUri(postLogoutRedirectUri, postLogoutRedirectUris);
        }
        if (!isBlank) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)EndSessionErrorResponseType.POST_LOGOUT_URI_NOT_ASSOCIATED_WITH_CLIENT, "`post_logout_redirect_uri` is not added to associated client.");
        }
        return null;
    }

    public String validatePostLogoutRedirectUri(SessionId sessionId, String postLogoutRedirectUri) {
        if (sessionId == null) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)EndSessionErrorResponseType.SESSION_NOT_PASSED, "Session object is not found.");
        }
        if (Strings.isNullOrEmpty((String)postLogoutRedirectUri)) {
            throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)EndSessionErrorResponseType.POST_LOGOUT_URI_NOT_PASSED, "`post_logout_redirect_uri` is empty.");
        }
        HashSet clientsByDns = sessionId.getPermissionGrantedMap() != null ? this.clientService.getClient(sessionId.getPermissionGrantedMap().getClientIds(true), true) : Sets.newHashSet();
        log.trace("Validating post logout redirect URI: postLogoutRedirectUri = {}", (Object)postLogoutRedirectUri);
        for (io.jans.as.common.model.registration.Client client : clientsByDns) {
            String[] postLogoutRedirectUris = client.getPostLogoutRedirectUris();
            String validatedUri = this.validatePostLogoutRedirectUri(postLogoutRedirectUri, postLogoutRedirectUris);
            if (!StringUtils.isNotBlank((CharSequence)validatedUri)) continue;
            return validatedUri;
        }
        throw this.errorResponseFactory.createWebApplicationException(Response.Status.BAD_REQUEST, (IErrorType)EndSessionErrorResponseType.POST_LOGOUT_URI_NOT_ASSOCIATED_WITH_CLIENT, "Unable to validate `post_logout_redirect_uri`");
    }

    public String validatePostLogoutRedirectUri(String postLogoutRedirectUri, String[] allowedPostLogoutRedirectUris) {
        if (BooleanUtils.isTrue((Boolean)this.appConfiguration.getAllowPostLogoutRedirectWithoutValidation()) && this.endSessionService.isUrlWhiteListed(postLogoutRedirectUri)) {
            return postLogoutRedirectUri;
        }
        if (allowedPostLogoutRedirectUris != null && StringUtils.isNotBlank((CharSequence)postLogoutRedirectUri)) {
            if (RedirectionUriService.isUriEqual(postLogoutRedirectUri, allowedPostLogoutRedirectUris)) {
                return postLogoutRedirectUri;
            }
        } else if (allowedPostLogoutRedirectUris != null && allowedPostLogoutRedirectUris.length == 1) {
            return allowedPostLogoutRedirectUris[0];
        }
        return "";
    }

    public static Map<String, String> getParams(String uri) {
        int paramsIndex;
        Map<String, String> params = new HashMap<String, String>();
        if (uri != null && (paramsIndex = uri.indexOf("?")) != -1) {
            String queryString = uri.substring(paramsIndex + 1);
            params = QueryStringDecoder.decode((String)queryString);
        }
        return params;
    }

    public static String uriWithoutParams(String uri) {
        int paramsIndex;
        if (uri != null && (paramsIndex = uri.indexOf("?")) != -1) {
            return uri.substring(0, paramsIndex);
        }
        return uri;
    }

    public static boolean compareParams(String uri1, String uri2) {
        if (StringUtils.isBlank((CharSequence)uri1) || StringUtils.isBlank((CharSequence)uri2)) {
            return false;
        }
        Map<String, String> params1 = RedirectionUriService.getParams(uri1);
        Map<String, String> params2 = RedirectionUriService.getParams(uri2);
        return params1.equals(params2);
    }
}

